#include "../binary_c.h"
#ifdef BSE
void stellar_timescales_high_mass_GB(const double mass,
                                     const double mp2,
                                     double * const timescales,
                                     double * const luminosities,
                                     const double * RESTRICT const giant_branch_parameters)
{
#ifndef USE_BSE_TIMESCALES_H
    /* 
     * Note that for M>metallicity_parameters(3) there is no
     * GB as the star goes from
     * HG -> CHeB -> AGB. So in effect timescales(1) refers to the time of
     * Helium ignition and not the BGB.
     */
    timescales[T_HE_IGNITION] = timescales[T_BGB];
    timescales[T_HE_BURNING] = thef(mass,
                                    1.0,
                                    mp2,
                                    giant_branch_parameters)
        *timescales[T_BGB];
    
#endif
    /* 
     * This now represents the luminosity at the end of CHeB, ie. BAGB
     */
    luminosities[L_HE_BURNING] = luminosities[L_BAGB];

    /* 
     * We set luminosities(3) to be the luminosity at the end of the HG
     */
    luminosities[L_BGB] = luminosities[L_HE_IGNITION];

}
#endif
