#include "../binary_c.h"
#ifdef BSE
void stellar_timescales_helium_stars(const double mass,
                                     const double mt,
                                     double *tm,
                                     double *tn,
                                     double * RESTRICT const timescales,
                                     double * RESTRICT const luminosities,
                                     double * RESTRICT const GB,
                                     struct stardata_t * const stardata,
                                     struct star_t * const star)
{  
    /* Helium stars */
    
    /*
     * Calculate Helium star Main Sequence lifetime.
     */
    *tm = themsf(mass); 
    Dprint("Set Hestar MS lifetime %g from mass=%g\n",*tm,mass);

    /* 
     * Estimate the core mass and increase 
     * the HeMS time if necessary
     */

    /*
     * Zero- and terminal age Helium star main sequence luminosity
     */
    luminosities[L_ZAMS] = lzhef(mass);
    luminosities[L_END_MS] = luminosities[L_ZAMS]*(1.0+0.45+Max(0.0,(0.85-0.08*mass)));

    /*
     * Set the Helium star GB parameters
     */
    GB[GB_A_HE] = 8.0E-05;
    GB[GB_B] = 4.1E+04;
    GB[GB_D] = 5.5E+04/(1.0+0.4*Pow4(mass));
    GB[GB_p] = 5.0;
    GB[GB_q] = 3.0; 
    const double mp=1.0-GB[GB_p];
    const double mq=1.0-GB[GB_q];
    const double ip=-1.0/mp;
    const double ipq=(1.0/(GB[GB_p]-GB[GB_q]));
    const double invD=1.0/GB[GB_D];
    GB[GB_Mx] = pow(GB[GB_B]*invD,ipq);

    /* 
     * Change in slope of giant L-Mc relation.
     */
    luminosities[L_LMX] = GB[GB_D]*pow(GB[GB_Mx],GB[GB_p]);

    /*
     * Set Helium star GB timescales 
     */
    double mc1 = mcgbf(luminosities[L_END_MS],
                       GB,
                       luminosities[L_LMX]);
                      

    double i_he=1.0/GB[GB_A_HE];

    double y=ip*i_he*invD;
    timescales[T_GIANT_TINF_1] = *tm + y*pow(mc1,mp);
    timescales[T_GIANT_TX] = timescales[T_GIANT_TINF_1] - (timescales[T_GIANT_TINF_1] - *tm)*pow((GB[GB_Mx]/mc1),mp);
    timescales[T_GIANT_TINF_2] = timescales[T_GIANT_TX] + (1.0/((GB[6]-1.0)*GB[8]*GB[3]))*pow(GB[7],(1.0-GB[6]));
           
    /*
     * Get an idea of when Mc = Min(Mt,Mc,C,max) on the GB
     */
    double mcmax = Min(
        Min(mt,
            1.45*mt-0.31),
        Max(stardata->preferences->chandrasekhar_mass,
            0.773*mass-0.35)
        );
    if(Less_or_equal(mcmax,GB[GB_Mx]))
    {
	timescales[T_TMCMAX] = timescales[T_GIANT_TINF_1] - y*pow(mcmax,mp);
    }
    else
    {
        const double y2 = -i_he/(mq*GB[GB_B]);
        timescales[T_TMCMAX] = timescales[T_GIANT_TINF_2] - y2*pow(mcmax,mq);
    }
                
    timescales[T_TMCMAX] = Max(timescales[T_TMCMAX],*tm);
    *tn = timescales[T_TMCMAX];
}
#endif//BSE
