#include "../binary_c.h"

void stellar_timescales_GB_parameters(
    const double mass, /* phase start mass */
    const double mp6, /* f(Z) = metallicity_parameters[6] */
    double * RESTRICT const GB /* set in this subroutine */
    )
{
    /*
     * Set the GB parameters
     */
    GB[GB_EFFECTIVE_AH] = pow(10.0,
                              Max(-4.8,
                                  Min(-5.7+0.8*mass,
                                      -4.1+0.14*mass)));
    GB[GB_A_H_HE] = 1.27e-05;
    GB[GB_A_HE] = 8.0e-05;
    GB[GB_B] = Max(3.0e+04,
                   500.0 + 1.75e+04*pow(mass,0.6));
  
    if(mass < 2.5)
    {
        if (mass<2.0)
        {
            GB[GB_D] = mp6;
            GB[GB_p] = 6.0;
            GB[GB_q] = 3.0;
        }     
        else 
        {
            double x = mass-2.0;
            x+=x;
            GB[GB_p] = 6.0 - x;
            GB[GB_q] = 3.0 - x;
            x *= mp6 - (0.975*mp6 - 0.45);
            GB[GB_D] = mp6 - x;
        }
    }
    else
    {
        GB[GB_D] = Max(-1.0,
                       0.5*mp6 - 0.06*mass);
        GB[GB_D] = Max(GB[GB_D],
                       0.975*mp6 - 0.18*mass);
        GB[GB_p] = 5.0;
        GB[GB_q] = 2.0;
    }
            
    GB[GB_D] = pow(10.0,GB[GB_D]);

}
