#include "../binary_c.h"

void stellar_structure_make_massless_remnant(struct star_t * newstar)
{
    /*
     * Turn a star into a massless remnant
     */
    newstar->phase_start_mass = 0.0;
    newstar->mass = 0.0;
    newstar->core_mass=0.0;
    newstar->menv = 0.0;
    newstar->age = 0.0;
    newstar->tm = 0.0;
    newstar->tn = 0.0;
    newstar->luminosity = REMNANT_LUMINOSITY;
    newstar->radius = REMNANT_RADIUS;
    newstar->rzams = REMNANT_RADIUS;
    newstar->rtms = REMNANT_RADIUS;
    newstar->core_radius = REMNANT_RADIUS;
    newstar->renv = REMNANT_RADIUS;
    newstar->k2 = 0.0;
    newstar->angular_momentum = 0.0;
    newstar->stellar_type = MASSLESS_REMNANT;
}
