#ifndef HRDIAG_MACROS_H
#define HRDIAG_MACROS_H

/* Macro for calling stellar_timescales (used a lot!) */
#define call_calc_lt(A,B,C)  stellar_timescales((A),            \
                                                (B),            \
                                                (C),            \
                                                tm,             \
                                                tn,             \
                                                timescales,     \
                                                luminosities,   \
                                                GB,             \
                                                stardata,       \
                                                star);

#define call_calc_lt2(A,B,C)  stellar_timescales((A),                   \
                                                 (B),                   \
                                                 (C),                   \
                                                 &(newstar->tm),        \
                                                 &(newstar->tn),        \
                                                 newstar->timescales,   \
                                                 newstar->luminosities, \
                                                 newstar->GB,           \
                                                 stardata,              \
                                                 newstar);

#define call_calc_ltvar(S) stellar_timescales((S)->stellar_type,        \
                                              (S)->phase_start_mass,    \
                                              (S)->mass,                \
                                              &((S)->tm),               \
                                              &((S)->tn),               \
                                              (S)->timescales,          \
                                              (S)->luminosities,        \
                                              (S)->GB,                  \
                                              stardata,                 \
                                              oldstar);

/* caller Ids: use these to ID which function calls hrdiag() */
#define STELLAR_STRUCTURE_CALLER_RLOF_mass_transfer_rate 1
#define STELLAR_STRUCTURE_CALLER_stellar_evolution 2
#define STELLAR_STRUCTURE_CALLER_common_envelope_evolution 3
#define STELLAR_STRUCTURE_CALLER_initialize_parameters 4
#define STELLAR_STRUCTURE_CALLER_reinitialize_parameters 5
#define STELLAR_STRUCTURE_CALLER_loop_iteration_merger 6
#define STELLAR_STRUCTURE_CALLER_make_BSE_tables 7
#define STELLAR_STRUCTURE_CALLER_supernova 8
#define STELLAR_STRUCTURE_CALLER_common_envelope_evolution_dm_bisector 9
#define STELLAR_STRUCTURE_CALLER_common_envelope_evolution_add_dm_to_envelope 10


#define Stellar_structure_caller_string(C) (                            \
        (C) == STELLAR_STRUCTURE_CALLER_RLOF_mass_transfer_rate ? "RLOF mass transfer rate" : \
        (C) == STELLAR_STRUCTURE_CALLER_stellar_evolution ? "Stellar evolution" : \
        (C) == STELLAR_STRUCTURE_CALLER_common_envelope_evolution ? "Common envelope evolution" : \
        (C) == STELLAR_STRUCTURE_CALLER_common_envelope_evolution_dm_bisector ? "Common envelope evolution dm bisector" : \
        (C) == STELLAR_STRUCTURE_CALLER_common_envelope_evolution_add_dm_to_envelope ? "Common envelope evolution add dm to envelope" : \
        (C) == STELLAR_STRUCTURE_CALLER_reinitialize_parameters ? "Initialize parameters" : \
        (C) == STELLAR_STRUCTURE_CALLER_reinitialize_parameters ? "Reinitialize parameters" : \
        (C) == STELLAR_STRUCTURE_CALLER_loop_iteration_merger ? "Loop iteration merger" : \
        (C) == STELLAR_STRUCTURE_CALLER_make_BSE_tables ? "Make BSE tables" : \
        (C) == STELLAR_STRUCTURE_CALLER_supernova ? "Supernova" :       \
        "Unknown" )

#define RLOF_CALL (caller_id == STELLAR_STRUCTURE_CALLER_RLOF_mass_transfer_rate)

#endif
