
#include "../binary_c.h"

#ifdef BSE

#include "stellar_structure_debug.h"

/*
 * Old-fashioned way of calling stellar_structure - 
 * here for compatibility only
 */

void stellar_structure_longcall(double * const phase_start_mass, /** stellar mass at the start of the current stellar evolutionary phase */
                                double * const phase_start_core_mass, /* ditto for the core */ 
                                double * const age, /** current age in Myr **/
                                double * const mt, /** current mass in solar units **/
                                double * const tm, /** double in, main sequence time **/
                                double * const tn, /** double in, nuclear burning time **/
                                double * const timescales, /** array in, time scale for different stages **/
                                double * const luminosities, /** array in, characteristic luminosity **/
                                double * const GB, /** array in, giant branch parameters **/
                                double * const r, /** stellar radius in solar units **/
                                double * const lum,/** characteristic luminosity **/
                                Stellar_type * const stellar_type, /** stellar type **/
                                double * const core_mass, /** core mass **/
                                double * const CO_core_mass,
                                double * const GB_core_mass,
                                double * const max_MS_core_mass,
                                double * const rc /** core radius **/,
                                double * const menv, /* envelope mass */
                                double * const renv, /* envelope radius */
                                double * const k2, /* radius of gyration of the envelope */
                       
                                /* TPAGB parameters */
                                double * const  time_first_pulse,
                                double * const  num_thermal_pulses,
                                double * const  time_prev_pulse,
                                double * const  prev_tagb,
                                double * const  menv_1tp,
                                double * const  mc_1tp,
                                double * const  core_mass_no_3dup,
                                double * const  interpulse_period,
                                double * const  time_next_pulse,
                                double * const  lambda_3dup,
                                double * const  num_thermal_pulses_since_mcmin,
                                double * const  spiky_luminosity,

                                Supernova_type * const SN_type, /* SN type, if one happens */
                                const Boolean allow_SN, /* if TRUE, set up new SN */
                                struct star_t * const star,
                                struct stardata_t * const stardata,
                                const Caller_id caller_id)
{
    
    /* make the new stellar structure struct */
    star->phase_start_mass = *phase_start_mass;
    star->mass = *mt;
    star->core_mass = *core_mass;
    star->GB_core_mass = *GB_core_mass;
    star->CO_core_mass = *CO_core_mass;
    star->max_MS_core_mass = *max_MS_core_mass;
    star->phase_start_core_mass = *phase_start_core_mass;
    star->menv = *menv;
    star->tm = *tm;
    star->tn = *tn;
    star->luminosity = *lum;
    star->radius = *r;
    star->core_radius = *rc;
    star->renv = *renv;
    star->k2 = *k2;
    star->age = *age;

    star->time_first_pulse = * time_first_pulse;
    star->num_thermal_pulses = * num_thermal_pulses;
    star->time_prev_pulse = * time_prev_pulse;
    star->prev_tagb= * prev_tagb;
    star->menv_1tp= * menv_1tp;
    star->mc_1tp= * mc_1tp;
    star->core_mass_no_3dup= * core_mass_no_3dup;
    star->interpulse_period= * interpulse_period;
    star->time_next_pulse= * time_next_pulse;
    star->lambda_3dup= * lambda_3dup;
    star->num_thermal_pulses_since_mcmin= * num_thermal_pulses_since_mcmin;
    
    star->spiky_luminosity= * spiky_luminosity;

    star->stellar_type = *stellar_type;
    star->timescales = timescales;
    star->luminosities = luminosities;
    star->GB = GB;

    /*
     * Note: preserve any oncoming SN
     */
    star->SN_type = star->SN_type==SN_NONE ? SN_NONE : star->SN_type;

    stellar_structure(star,
                      stardata,
                      timescales,
                      luminosities,
                      GB,
                      allow_SN,
                      caller_id);

    *mt = star->mass;
    *phase_start_mass = star->phase_start_mass;
    *phase_start_core_mass = star->phase_start_core_mass;
    *core_mass = star->core_mass;
    *GB_core_mass = star->GB_core_mass;
    *CO_core_mass = star->CO_core_mass;
    *max_MS_core_mass = star->max_MS_core_mass;

    *menv = star->menv;
    *age = star->age;
    *tm = star->tm;
    *tn = star->tn;
    *lum = star->luminosity;
    *r = star->radius;
    *rc = star->core_radius;
    *renv = star->renv;
    *k2 = star->k2;
        
    * time_first_pulse = star->time_first_pulse;
    * num_thermal_pulses = star->num_thermal_pulses;
    
    * time_prev_pulse = star->time_prev_pulse;
    * prev_tagb  = star->prev_tagb;
    * menv_1tp = star->menv_1tp;
    * mc_1tp = star->mc_1tp;
    * core_mass_no_3dup = star->core_mass_no_3dup;
    * interpulse_period = star->interpulse_period;
    * time_next_pulse = star->time_next_pulse;
    * lambda_3dup = star->lambda_3dup;
    * num_thermal_pulses_since_mcmin = star->num_thermal_pulses_since_mcmin;
    
    * spiky_luminosity = star->spiky_luminosity;

    *stellar_type = star->stellar_type;
    *SN_type = star->SN_type;

    if(caller_id == STELLAR_STRUCTURE_CALLER_common_envelope_evolution_dm_bisector)
    {
        free_supernova(stardata,star);
    }

}
#endif//BSE
