#include "../binary_c.h"

/*
 * Function to return TRUE if the star ignites helium on the giant branch
 */
Boolean Pure_function stellar_structure_giant_branch_helium_ignition(struct stardata_t * const stardata,
                                                                     struct star_t * const star)
{
    return Boolean_(
#ifdef BSE
    Less_or_equal(star->phase_start_mass,
                  stardata->common.metallicity_parameters[ZPAR_MASS_FGB])
#endif//BSE

#ifdef BINT
    /*
     * Fitting formula from BSE (H00 Eq.3, HPhD Eq.2.3)
     *
     * TODO : update to use tables
     */
    FALSE
#endif//BINT
        
        );
}
