#include "../binary_c.h"
#include "stellar_structure_debug.h"

void stellar_structure_algorithm(struct star_t * newstar,
                                 struct star_t * oldstar,
                                 struct stardata_t *stardata,
                                 const Caller_id caller_id)
{
    switch(stardata->preferences->stellar_structure_algorithm)
    {

    case STELLAR_STRUCTURE_ALGORITHM_NONE:
        /* do nothing */
        Copy_star(oldstar,newstar);
        break;
    
    case STELLAR_STRUCTURE_ALGORITHM_EXTERNAL_FUNCTION:
        /*
         * Use an externally defined function
         */
        if(stardata->preferences->stellar_structure_function == NULL)
        {
            Exit_binary_c(BINARY_C_POINTER_FAILURE,
                          "Attempt to call an external stellar structure function which has not been defined. Oops!\n");
        }
        stardata->preferences->stellar_structure_function(
            caller_id,stardata,oldstar,newstar);
        break;
        
    case STELLAR_STRUCTURE_ALGORITHM_MODIFIED_BSE:
        /*
         * The BSE algorithm
         */
#ifdef BSE
        stellar_structure_BSE(newstar,oldstar,stardata,caller_id);
#else
        Exit_binary_c(BINARY_C_ALGORITHM_OUT_OF_RANGE,
                      "Algorithm BSE is not built or linked in");
#endif
        break;
#ifdef BINT        
    case STELLAR_STRUCTURE_ALGORITHM_BINT:
        /*
         * New BINT algorithm
         */
        BINT_stellar_structure(newstar,oldstar,stardata,caller_id);
        break;
#else
        Exit_binary_c(BINARY_C_ALGORITHM_OUT_OF_RANGE,
                      "Algorithm BINT is not built or linked in");
#endif//BINT
    default:
        Exit_binary_c(BINARY_C_ALGORITHM_OUT_OF_RANGE,
                      "Unknown stellar struture algorithm %d\n",
                      stardata->preferences->stellar_structure_algorithm);
    }
}
