#include "../binary_c.h"
#include "stellar_structure_debug.h"

void stellar_structure_NS(struct star_t * newstar,
                          struct stardata_t * stardata)
{
    Dprint("stellar_structure_NS\n");
    newstar->core_mass = newstar->mass;
    newstar->GB_core_mass = 0.0;
    newstar->CO_core_mass = newstar->mass;
    newstar->luminosity = lns(newstar->mass,newstar->age);
    newstar->radius = rns(newstar->mass);

    if(newstar->core_mass > stardata->preferences->max_neutron_star_mass)
    {
        /*
         * Accretion induced Black Hole : 
         * NB no new_supernova required: nothing is lost
         */
        Dprint("Accretion induced Black Hole?\n");
        if(newstar->SN_type == SN_NONE)
        {
            newstar->SN_type = SN_AIC_BH;
            struct star_t * news =
                new_supernova(stardata,
                              newstar,
                              Other_star_struct(newstar),
                              newstar);
            if(news)
            {
                news->stellar_type = BLACK_HOLE;
                news->age = 0.0;
                news->mass = newstar->mass;
            }
        }
    }
    
}
