#include "../binary_c.h"

void set_stellar_structure_struct_from_star(struct star_t * newstar,
                                            struct star_t * oldstar)
{
    /*
     * Given a star_t struct, set the new_stellar_structure struct.
     * Does the opposite of set_star_struct_from_stellar_structure.
     */
#define set(x) newstar->x = oldstar->x    
    set(age);
    set(stellar_type);
    set(radius);
    set(mass);
    set(core_mass);
    set(core_radius);
    set(luminosity);
    set(tm);
    set(tn);
    set(renv);
    set(k2);
    set(phase_start_mass);
    set(phase_start_core_mass);
    set(CO_core_mass);
    set(GB_core_mass);
    set(max_MS_core_mass);
    set(time_first_pulse);
    set(num_thermal_pulses);
    set(time_prev_pulse);
    set(prev_tagb);
    set(menv_1tp);
    set(mc_1tp);
    set(core_mass_no_3dup);
    set(interpulse_period);
    set(time_next_pulse);
    set(lambda_3dup);
    set(num_thermal_pulses_since_mcmin);
    set(spiky_luminosity);
    memcpy(newstar->derivative,
           oldstar->derivative,
           NUMBER_OF_STELLAR_DERIVATIVES*sizeof(double));
    set(stellar_type);
    set(SN_type);
}
