#include "../binary_c.h"

/*
 * Remnant radius
 */
#ifdef BSE
double Pure_function remnant_radius(int stellar_type,
                                    double mass,
                                    double mc, 
                                    double r,
                                    double *metallicity_parameters,
                                    struct stardata_t * stardata
    )
{
    double rr=0.0;
    if(stellar_type<=FIRST_GIANT_BRANCH)
    {
        rr = mass>metallicity_parameters[ZPAR_MASS_HE_FLASH] ? rzhef(mc) : rwd(mc,stardata);
    }
    else if(stellar_type==CORE_HELIUM_BURNING || stellar_type==EARLY_ASYMPTOTIC_GIANT_BRANCH)
    {
        rr = rzhef(mc);
    }
    else if(stellar_type<COWD)
    {
        rr = rwd(mc,stardata);
    }
    else
    {
        rr = r;
    }
    return rr;
}
#endif //BSE
