#!/bin/bash

# make data objects for common envelope evolution with binary_c
# http://gareus.org/wiki/embedding_resources_in_executables

: ${CC:="gcc"}
: ${OBJCOPY_OPTS:="-I binary -B i386:x86-64 -O elf64-x86-64"}

# Miller Bertolami's post-AGB tables
HFILE=miller_bertolami_postagb.h
TMPFILE=miller_bertolami_postagb.dat
OBJFILE=miller_bertolami_postagb.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \*    | ./double2bin > $TMPFILE

    # The Miller Bertolami table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE

HFILE=miller_bertolami_postagb_coeffs_L.h
TMPFILE=miller_bertolami_postagb_coeffs_L.dat
OBJFILE=miller_bertolami_postagb_coeffs_L.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \*    | ./double2bin > $TMPFILE

    # The Miller Bertolami table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE

HFILE=miller_bertolami_postagb_coeffs_R.h
TMPFILE=miller_bertolami_postagb_coeffs_R.dat
OBJFILE=miller_bertolami_postagb_coeffs_R.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \*    | ./double2bin > $TMPFILE

    # The Miller Bertolami table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE
