#include "../binary_c.h"

void unresolved_stellar_magnitudes(struct stardata_t * const stardata,
                                   struct store_t * const store,
                                   double ** magnitudes_p)
{
    /*
     * Calculate unresolved binary magnitudes
     *
     * magnitudes_p should not be NULL
     */
    if(*magnitudes_p == NULL)
    {
        *magnitudes_p = Calloc(NUMBER_OF_STELLAR_MAGNITUDES,
                               sizeof(double));
    }
    double * const magnitudes = *magnitudes_p;
    
    /*
     * Get each star's magnitudes
     */
    double ** stellar_mags =
        stardata->tmpstore->stellar_magnitudes;
    
    Star_number k;
    Starloop(k)
    {
        stellar_magnitudes(stardata,
                           &stardata->star[k],
                           &stellar_mags[k]);
    }

    /*
     * Combine the magnitudes. In band x, we have for flux in the band x,
     *
     * m_x = -2.5 log10(flux / reference flux)
     *
     *     = -2.5 log10(flux) + 2.5 log10(reference flux)
     *
     *     = -2.5 log10(flux/Lsun) + 2.5 log10(Lsun) + 2.5 log10(reference flux)
     *
     *
     * So 
     *
     *  log10(flux) = - m_x / 2.5 + log10(reference flux) 
     *
     *  flux = 10 ^ (- m_x / 2.5 + log10(reference flux))
     * 
     *       = 10 ^ (-m_x/2.5) * (reference flux) 
     *
     *
     * In a binary we have
     *
     * flux = (flux1 + flux2)
     *
     *      = (10^(-m_x1/2.5) + 10^(-m_x2/2.5)) * reference_flux 
     *
     *      = 10 ^ (-m_X/2.5) * reference_flux
     *
     *
     * Hence 
     *
     * 10^(-m_x1/2.5) + 10^(-m_x2/2.5) = 10^(-m_X/2.5)
     *
     * m_X = -2.5 * log10(10^(-m_x1/2.5) + 10^(-m_x2/2.5))
     *
     *
     * We can also use the add_magnitudes functions to do this.
     */

    int i;
    for(i=0;i<NUMBER_OF_STELLAR_MAGNITUDES;i++)
    {
        /*
        magnitudes[i] = - 2.5 * log10(
            pow(10.0, - stellar_magnitudes[0][i]/2.5) +
            pow(10.0, - stellar_magnitudes[1][i]/2.5)
            );
        */
        magnitudes[i] = 
            add_magnitudes(stellar_mags[0][i],
                           stellar_mags[1][i]);
        /*
        printf("mag %d = %g\n",i,magnitudes[i]);
        printf("add mags %g\n",
               add_magnitudes(stellar_magnitudes[0][i],
                              stellar_magnitudes[1][i]));
        */
    }
    
}
