#pragma once
#ifndef COLOURS_PROTOTYPES_H
#define COLOURS_PROTOTYPES_H
#ifdef STELLAR_COLOURS

void eldridge2012_magnitudes(struct stardata_t * const stardata,
                          struct star_t * const star,
                          double * RESTRICT const magnitudes);
void eldridge2015_colours(struct stardata_t * const stardata,
                          struct star_t * const star,
                          double * RESTRICT const magnitudes);
void binary_magnitudes(struct stardata_t * const stardata,
                    struct store_t * const store,
                    const Star_number starnum,
                    double * RESTRICT const M_v,
                    double * RESTRICT const U_minus_B, 
                    double * RESTRICT const B_minus_V,
                    double * RESTRICT const V_minus_I,
                    double * RESTRICT const M_b,
                    double * RESTRICT const M_u,
                    double * RESTRICT const M_i,
                    double * RESTRICT const M_bol,
                    double * RESTRICT const L_u,
                    double * RESTRICT const L_b,
                    double * RESTRICT const L_v,
                    double * RESTRICT const L_i);
void gaia_magnitudes(struct stardata_t * stardata,
                  double * RESTRICT const magnitudes,
                  int method);
void stellar_magnitudes(struct stardata_t * const stardata,
                     struct star_t * const star,
                     double ** RESTRICT magnitudes);
double Constant_function add_magnitudes(const double magA,
                                        const double magB);

#ifdef STELLAR_COLOUR_TESTS
void stellar_magnitude_tests(struct stardata_t * const stardata,
                          struct star_t * const star);
#endif
Constant_function double magnitude_from_luminosity(const double luminosity);
Constant_function double luminosity_from_magnitude(const double magnitude);


void unresolved_stellar_magnitudes(struct stardata_t * const stardata,
                                struct store_t * const store,
                                double ** magnitudes_p);
#endif // STELLAR_COLOURS
#endif // COLOURS_PROTOTYPES_H

