#pragma once
#ifndef STELLAR_COLOUR_MACROS_H
#define STELLAR_COLOUR_MACROS_H

#include "eldridge_columns.h"

/* Johnson-Cousins UBVRI */
#define STELLAR_MAGNITUDE_U 0 
#define STELLAR_MAGNITUDE_B 1
#define STELLAR_MAGNITUDE_V 2
#define STELLAR_MAGNITUDE_R 3
#define STELLAR_MAGNITUDE_I 4
#define STELLAR_MAGNITUDE_J 5
#define STELLAR_MAGNITUDE_H 6
#define STELLAR_MAGNITUDE_K 7

/* SDSS ugriz */
#define STELLAR_MAGNITUDE_u 8
#define STELLAR_MAGNITUDE_g 9
#define STELLAR_MAGNITUDE_r 10
#define STELLAR_MAGNITUDE_i 11
#define STELLAR_MAGNITUDE_z 12

/* Hubble */
#define STELLAR_MAGNITUDE_f300w 13
#define STELLAR_MAGNITUDE_f336w 14
#define STELLAR_MAGNITUDE_f435w 15
#define STELLAR_MAGNITUDE_f450w 16
#define STELLAR_MAGNITUDE_f555w 17
#define STELLAR_MAGNITUDE_f606w 18
#define STELLAR_MAGNITUDE_f814w 19

/* Gaia */
#define STELLAR_MAGNITUDE_GAIA_G 20
#define STELLAR_MAGNITUDE_GAIA_GBP 21
#define STELLAR_MAGNITUDE_GAIA_GRP 22
#define STELLAR_MAGNITUDE_GAIA_GRVS 23

#define STELLAR_COLOUR_STRINGS {"U","B","V","R","I","J","H","K","u","g","r","i","z","f300w","f336w","f435w","f450w","f555w","f606w","f814w","G","GBP","GRP","GRVS"}

#define STELLAR_COLOUR_STRING_LENGTH ((size_t)6)

#define NUMBER_OF_STELLAR_MAGNITUDES 24

/* Gaia conversion methods */

#define GAIA_CONVERSION_USE_DEFAULT 0
#define GAIA_CONVERSION_UBVRI_SINGLE 1
#define GAIA_CONVERSION_UBVRI_DOUBLE 2
#define GAIA_CONVERSION_ugriz_SINGLE 3
#define GAIA_CONVERSION_ugriz_DOUBLE 3

#define GAIA_CONVERSION_DEFAULT_METHOD GAIA_CONVERSION_UBVRI_DOUBLE





#endif// COLOUR_MACROS_H
