#!/bin/bash

# make data objects for stellar_colours with binary_c

: ${CC:="gcc"}
: ${OBJCOPY_OPTS:="-I binary -B i386:x86-64 -O elf64-x86-64"}

HFILE=eldridge2015-basel.h
TMPFILE=eldridge2015-basel.dat
OBJFILE=eldridge2015-basel.o

if [ $HFILE -nt $OBJFILE ] ; then

    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
    
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
    
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE


HFILE=eldridge2015-ostar.h
TMPFILE=eldridge2015-ostar.dat
OBJFILE=eldridge2015-ostar.o

if [ $HFILE -nt $OBJFILE ] ; then

    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
    
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
        
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE


HFILE=Kurucz.h
TMPFILE=Kurucz.dat
OBJFILE=Kurucz.o

if [ $HFILE -nt $OBJFILE ] ; then

    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
    
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
    
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE
