/*
 * Calculate stellar colours according to Eldridge's 2015 table
 * for the Basel library and for O stars.
 */
#include "../binary_c.h"

#ifdef STELLAR_COLOURS

#include "stellar_colour_macros.h"
//#include "eldridge2015-ostar.h"
//#include "eldridge2015-basel.h"
#define ELDRIDGE2015_LENGTH_BASEL 29900
#define ELDRIDGE2015_METADATA_BASEL 3,20,1300
#define ELDRIDGE2015_LENGTH_OSTAR 25300
#define ELDRIDGE2015_METADATA_OSTAR 3,20,1100

/*
 * magnitudes should be an array : 
 * double magnitudes[NUMBER_OF_STELLAR_MAGNITUDES]
 */
void eldridge2015_colours(struct stardata_t * const stardata,
                          struct star_t * const star,
                          double * const magnitudes)
{

    //Const_data_table basel[ELDRIDGE2015_LENGTH_BASEL] = {ELDRIDGE2015_DATA_ARRAY_BASEL};
    extern double _binary_eldridge2015_basel_dat_start[];  
    //extern double _binary_eldridge2015_ostar_dat_start[];  

    Const_data_table * basel = _binary_eldridge2015_basel_dat_start;
    //Const_data_table * ostars = _binary_eldridge2015_basel_dat_start;

    //Const_data_table ostars[ELDRIDGE2015_LENGTH_OSTAR] = {ELDRIDGE2015_DATA_ARRAY_OSTAR};
    double param[3] = {
        log10(stardata->common.metallicity/0.02),
        log10(Teff_from_star_struct(star)),
        logg(star),
    };
    double mags[20];

#ifdef CDEBUG
    char *c[STELLAR_COLOUR_STRING_LENGTH] = STELLAR_COLOUR_STRINGS;
#endif

    rinterpolate(basel,
                 stardata->tmpstore->rinterpolate_data,
                 ELDRIDGE2015_METADATA_BASEL,
                 param,
                 mags,
                 0);
    
    /* set magnitudes */


    /* Johnson colours (Vega) */
    magnitudes[STELLAR_MAGNITUDE_U] = mags[ELDRIDGE_U];
    magnitudes[STELLAR_MAGNITUDE_B] = mags[ELDRIDGE_B];
    magnitudes[STELLAR_MAGNITUDE_V] = mags[ELDRIDGE_V];
    magnitudes[STELLAR_MAGNITUDE_R] = mags[ELDRIDGE_R];
    magnitudes[STELLAR_MAGNITUDE_I] = mags[ELDRIDGE_I];
    magnitudes[STELLAR_MAGNITUDE_J] = mags[ELDRIDGE_J];
    magnitudes[STELLAR_MAGNITUDE_H] = mags[ELDRIDGE_H];
    magnitudes[STELLAR_MAGNITUDE_K] = mags[ELDRIDGE_K];

    /*
     * SDSS
     */
    magnitudes[STELLAR_MAGNITUDE_u] = mags[ELDRIDGE_u];
    magnitudes[STELLAR_MAGNITUDE_g] = mags[ELDRIDGE_g];
    magnitudes[STELLAR_MAGNITUDE_r] = mags[ELDRIDGE_r];
    magnitudes[STELLAR_MAGNITUDE_i] = mags[ELDRIDGE_i];
    magnitudes[STELLAR_MAGNITUDE_z] = mags[ELDRIDGE_z];

    /* 
     * Hubble filters
     */
    magnitudes[STELLAR_MAGNITUDE_f300w] = mags[ELDRIDGE_f300w];
    magnitudes[STELLAR_MAGNITUDE_f336w] = mags[ELDRIDGE_f336w];
    magnitudes[STELLAR_MAGNITUDE_f435w] = mags[ELDRIDGE_f435w];
    magnitudes[STELLAR_MAGNITUDE_f450w] = mags[ELDRIDGE_f450w];
    magnitudes[STELLAR_MAGNITUDE_f555w] = mags[ELDRIDGE_f555w];
    magnitudes[STELLAR_MAGNITUDE_f606w] = mags[ELDRIDGE_f606w];
    magnitudes[STELLAR_MAGNITUDE_f814w] = mags[ELDRIDGE_f814w];
            
    /* adjust for the star's luminosity (colours assume L=1) */
    {
        Stellar_magnitude_index i;
        double ll = magnitude_from_luminosity(star->luminosity);
        for(i=0;i<=STELLAR_MAGNITUDE_f814w;i++)
        {
            magnitudes[i] += ll;
        }
    }

#ifdef CDEBUG
    printf("\}\n");
#endif
}


#endif // STELLAR_COLOURS
