#include "../binary_c.h"

void strip_supermassive_star(struct stardata_t * RESTRICT const stardata,
                             struct star_t * RESTRICT const star,
                             const double mass)
{
#ifdef TRIM_SUPERMASSIVE_STARS
#ifdef NUCSYN
    /*
     * Yield the excess mass with the current 
     * surface abundance
     */
    nucsyn_calc_yields(stardata,star,
                       mass - MAXIMUM_STELLAR_MASS,
                       star->Xenv,
                       0.0,NULL,
                       star->starnum,
                       YIELD_NOT_FINAL,
                       NUCSYN_SOURCE_OTHER);
#ifdef NUCSYN_STRIP_AND_MIX
    strip_and_mix_remove_mass(star, mass - MAXIMUM_STELLAR_MASS);
#endif
#endif // NUCSYN
#else
    printf("REDUCER %g\n",mass);
#endif // TRIM_SUPERMASSIVE_STARS
}
