#ifdef ____NOTYET

#include "../binary_c.h"

/*
 * Function to calculate the angular momentum of the envelope,
 * core or the whole star, assuming star->omega or star->omega_core
 * is correct.
 *
 * When there is no envelope, e.g. white dwarfs, neutron stars,
 * black holes, main sequence, we follow the BSE convention and 
 */

#ifdef CORE_OMEGA
#define omega_core star->omega_core
#else
#define omega_core star->omega
#endif
#define omega_env star->omega

double Pure_function stellar_angular_momentum(const struct star_t * star,
                                const int of_what,
                                const double r,
                                const double rc)
{
    double J;
    if(of_what == ANGULAR_MOMENTUM_ENVELOPE)
    {
        /*
         * Return the angular momentum of the envelope
         */
        J = envelope_moment_of_inertia(star,r) * omega_env;
    }
    else if(of_what == ANGULAR_MOMENTUM_CORE)
    {
        /*
         * Return the angular momentum of the core
         */
        if(HAS_BSE_CORE(star->stellar_type))
        {
            J = core_moment_of_inertia(star,rc) * omega_core;
        }
        else
        {
            J = 0.0;
        }
    }
    else
    {
        /*
         * Assume we want the whole star
         */
        J = envelope_moment_of_inertia(star,r) * omega_env +
            core_moment_of_inertia(star,rc) * omega_core;
    }
    return J;
}
#endif
