
/* Prototypes for the single star functions library */

#ifndef SINGLE_STAR_FUNCTIONS_PROTOTYPES_H
#define SINGLE_STAR_FUNCTIONS_PROTOTYPES_H
#include "../binary_c_structures.h"

double calc_stellar_wind_mass_loss(const Stellar_type stellar_type,
                                   const double luminosity,
                                   const double radius,
                                   const double mt,
                                   const double core_mass,
                                   const double roche_lobe_radius,
                                   const double metallicity,
                                   const double omega,
                                   struct stardata_t * RESTRICT const stardata,
                                   const Star_number k);


Constant_function double corerd(const Stellar_type stellar_type,
                                const double core_mass,
                                const double m0,
                                const double phase_start_core_mass,
                                const double mflash,
                                struct stardata_t * RESTRICT const stardata);

void giant_age(double * RESTRICT const mc, 
               const double mt, 
               Stellar_type * RESTRICT const stellar_type,
               double * RESTRICT const m0,  
               double * RESTRICT const age,
               struct stardata_t * const stardata,
               struct star_t * const star);

void calculate_rotation_variables(struct star_t * RESTRICT const star,
                                  const double radius);

double Pure_function Xray_luminosity(const struct star_t * RESTRICT const star);

void magnetic_braking(struct stardata_t * RESTRICT const stardata, 
                      struct star_t * RESTRICT const star);

double E2(struct stardata_t * RESTRICT const stardata,
          const struct star_t * RESTRICT const star);

double Pure_function dynamical_timescale(const struct star_t * RESTRICT star);
double Pure_function dynamical_timescale_envelope(const struct star_t * RESTRICT star);
void strip_supermassive_star(struct stardata_t * RESTRICT const stardata,
                             struct star_t * RESTRICT const star,
                             const double mass);

double breakup_angular_momentum(struct star_t * RESTRICT const star);

double Pure_function stellar_angular_momentum(const struct star_t * RESTRICT const star,
                                const int of_what,
                                const double r,
                                const double rc);

double Pure_function stellar_density(struct star_t * star);

Time Pure_function kelvin_helmholtz_time(struct star_t * RESTRICT star);

#endif /*SINGLE_STAR_FUNCTIONS_PROTOTYPES_H*/
