#include "../binary_c.h"


/*
 * Return Kelvin-Helmholtz time for the star
 * (Hurley et al 2002, Eq.61)
 */

Time Pure_function kelvin_helmholtz_time(struct star_t * RESTRICT star)
{
    
    const double lr = star->luminosity * star->radius;
    Time tkh;
    
    if(unlikely(star->stellar_type == MASSLESS_REMNANT ||
                star->stellar_type == BLACK_HOLE ||
                Is_zero(lr)))
    {
        tkh = 1e20;
    }
    else
    {
        tkh = 1e7 * star->mass / lr *
            (star->mass - 
             ((ON_EITHER_MAIN_SEQUENCE(star->stellar_type)||
               LATER_THAN_WHITE_DWARF(star->stellar_type)) ?
              0.0 : star->core_mass));
    }
    return tkh;
}
