#include "../binary_c.h"

double breakup_angular_momentum(struct star_t * RESTRICT const star)
{
    /*
     * Return the maximum angular momentum this star can hold
     * (without a change in its structure)
     *
     * Returns in code units for angular momentum
     */
    double r = star->radius > star->roche_radius ? 
        star->effective_radius : star->radius;
    calculate_rotation_variables(star,r);
    return moment_of_inertia(star,r) * star->omega_crit; 
}

#ifdef __EXPERIMENTAL_CODE
double core_breakup_angular_momentum(struct star_t * RESTRICT const star)
{
    /*
     * Return the maximum angular momentum the core can hold
     */
#ifdef OMEGA_CORE
#define omega_core star->omega_core
#else
#define omega_core star->omega
#endif
    
    return core_moment_of_inertia(star,star->core_radius) *
        omega_core;
}
#endif
