
/******************************************************************************
 * Segfault catching function, thanks to Keir Fraser for this.
 */

#include "../binary_c.h"
#include <sys/resource.h>

void No_return tstp_handler(int sig,
                            siginfo_t *info,
                            ucontext_t *uc)              
{   
    /*
     * Some output information for segfaults.
     * Given a backtrace if possible.
     */
#define SEGFAULT_MESSAGE "binary_c/nucsyn: Caught segfault - tstp_handler. Signal %d for pid %d.%s\n", \
        sig,                                                            \
        getpid(),                                                       \
        sig==SIGSEGV ? " Consider trying 'ulimit -s unlimited'. ": ""

    if(stdout!=NULL)
    {
        _printf(SEGFAULT_MESSAGE);
        fflush(stdout);
    }
    /*
    if(stderr!=NULL && stderr!=stdout) 
    { 
        fprintf(stderr,SEGFAULT_MESSAGE);
        fflush(stderr);
    }
    */
    
#ifdef BACKTRACE
    Print_trace();
#endif

    
#ifdef BATCHMODE
    if(stdout)
    {
        _printf("fin crash\nfin\ncrash\n");
        fflush(stdout);
    }
#endif
    
    hoover_and_sms(NULL,BINARY_C_CAUGHT_SEGFAULT);
}

