#include "../binary_c.h"

#include <signal.h>
#include <unistd.h>

#if defined LINUX && !defined SEGFAULTS
#define ALTSTACK
#endif

void catch_float_signals(void);
void catch_float(int signo) No_return;

void stackhandler(int sig) No_return;
void No_return stackhandler(int sig)
{
    Exit_binary_c_no_stardata(
        BINARY_C_STACK_HANDLER,
        "Stack handler %d\n",
        sig);
}

char * setup_segfaults()
{
#ifdef ALTSTACK
    /*
     * Set up an alternative stack on which we can 
     * capture segmentation faults.
     *
     * This subroutine should be called only once, 
     * otherwise it will leak memory.
     *
     * The memory in altstack, the pointer which is 
     * returned, is not freed here. You should free it
     * just before exiting binary_c.
     *
     * Also, while this function *can* be called from
     * the shared library interface, it probably shouldn't be,
     * as the parent application should handle segmentation faults
     * itself, and if you run many stars (each of which calls this function)
     * you will suffer a huge memory leak.
     */
    char * altstack = Malloc(2*sizeof(char)*SIGSTKSZ); 
        
    /* set up the segfault stack */
    stack_t ss;
    memset(&ss,0,sizeof(ss));
    ss.ss_size = SIGSTKSZ;
    ss.ss_sp = altstack;
    sigaltstack(&ss,0);
    
    /* set up the signal action */
    struct sigaction sa;
    memset(&sa,0,sizeof(sa));
    sa.sa_handler = (void *)tstp_handler;
    sa.sa_flags = SA_ONSTACK;
    sigfillset(&sa.sa_mask);

    /* capture the signals */
    sigaction(SIGSEGV,&sa,0);
    sigaction(SIGSTKFLT,&sa,0);
    
    /* Set up the segfault catching - thanks to Keir Fraser for this bit */
    /*
      struct sigaction act;
    memset(&act, 0, sizeof(act));
#ifndef __INTEL_COMPILER
    act.sa_handler = (void *)tstp_handler;
#endif
    act.sa_flags = SA_SIGINFO;
    //sigaction(SIGSEGV, &act, NULL);
    */
#endif // ALTSTACK

/*
 * Catch the unix signals SIGALARM and SIGVTALARM?
 * and set the timer 
 * so we can catch runs which go on for too long (5 seconds)
 */
#ifdef LINUX
    reset_binary_c_timeout();
#endif
    catch_timeouts();
    catch_float_signals();
#ifdef ALTSTACK
    return altstack;
#else
    return NULL;
#endif // ALTSTACK
    
}

void catch_timeouts(void)
{
#if defined LINUX && defined CATCH_SIGVTALRM 
    /* Doesn't work on solaris...! */
    signal(SIGVTALRM,catch_timeout);
#endif
}

void uncatch_timeouts(void)
{
#if defined LINUX && defined CATCH_SIGVTALRM
    signal(SIGVTALRM,SIG_IGN);
#endif
}

void catch_float_signals(void)
{
#if defined FPU_CAPTURE_INVALID
    signal(SIGFPE,catch_float);
#endif
}

void No_return catch_float(int signo)
{
    fprintf(stderr,"Caught float signal\n");
    Exit_binary_c_no_stardata(BINARY_C_FLOATING_POINT_ERROR,
                              "Caught SIGFPE\n");
}
