#pragma once
#ifndef SETUP_PROTOTYPES_H
#define SETUP_PROTOTYPES_H
#include "../binary_c_macros.h"
#include "../binary_c_parameters.h"
#include "../binary_c_structures.h"
#include "cmd_line_args.h"

void set_up_variables(const int argc,
		      char ** argv,
		      struct preferences_t * preferences,
		      struct stardata_t * const stardata);

#ifdef BSE
void set_metallicity_parameters(struct stardata_t * RESTRICT const stardata);
void set_metallicity_parameters2(struct stardata_t * RESTRICT const stardata);
#endif
void set_defaults(struct stardata_t * RESTRICT const stardata);
void set_up_memmap(struct stardata_t * RESTRICT const stardata);

void parse_arguments(const int start,
                     const int argc,
                     char ** argv,
                     struct stardata_t * RESTRICT const stardata);

void stardata_status(struct stardata_t * RESTRICT const stardata,
		     const Star_number k);

void version(struct stardata_t * RESTRICT const stardata);

void set_default_preferences(struct preferences_t * RESTRICT const preferences);
    
void default_stardata(struct stardata_t * RESTRICT const stardata);

void force_flushing(void);


void binary_c_help_from_arg(ARG_SUBROUTINE_DECLARATION);
void binary_c_help_all(ARG_SUBROUTINE_DECLARATION) No_return;
void binary_c_speedtests(ARG_SUBROUTINE_DECLARATION) No_return;
void binary_c_warmup_cpu(ARG_SUBROUTINE_DECLARATION);
void list_available_args(ARG_SUBROUTINE_DECLARATION);
void list_available_args_and_exit(ARG_SUBROUTINE_DECLARATION) No_return;
void dummyfunc(ARG_SUBROUTINE_DECLARATION);
void binary_c_version_internal(ARG_SUBROUTINE_DECLARATION);
void version_only(ARG_SUBROUTINE_DECLARATION);
void dumpversion(ARG_SUBROUTINE_DECLARATION) No_return;
double set_effective_metallicity(ARG_SUBROUTINE_DECLARATION);
void set_init_abund(ARG_SUBROUTINE_DECLARATION);
void set_init_abund_mult(ARG_SUBROUTINE_DECLARATION);
void set_init_abund_dex(ARG_SUBROUTINE_DECLARATION);
void set_solar_abund(ARG_SUBROUTINE_DECLARATION);
void set_third_dup_multiplier(ARG_SUBROUTINE_DECLARATION);

#ifdef BATCHMODE
void batchmode_reset_stars(ARG_SUBROUTINE_DECLARATION);
void batchmode_bye(ARG_SUBROUTINE_DECLARATION) No_return;
void batchmode_reset_stars(ARG_SUBROUTINE_DECLARATION);
void batchmode_set_echo_on(ARG_SUBROUTINE_DECLARATION);
void batchmode_set_echo_off(ARG_SUBROUTINE_DECLARATION);
void batchmode_fin(ARG_SUBROUTINE_DECLARATION);
void batchmode_reset_stars_defaults(ARG_SUBROUTINE_DECLARATION);
void batchmode_status(ARG_SUBROUTINE_DECLARATION);
void batchmode_go(ARG_SUBROUTINE_DECLARATION);
void batchmode_gogo(ARG_SUBROUTINE_DECLARATION) No_return;
void batchmode_reset_prefs(ARG_SUBROUTINE_DECLARATION);
void batchmode_defaults(ARG_SUBROUTINE_DECLARATION);
#endif // BATCHMODE

void reset_stars_defaults(ARG_SUBROUTINE_DECLARATION);
Random_seed random_seed(void);
void show_cmd_line_args(const struct stardata_t * const stardata,
                        FILE * stream);

void parse_arguments_from_string(const char * RESTRICT const argstring,
                                 int * RESTRICT const argc,
                                 struct stardata_t * RESTRICT stardata);
char **split_commandline(const char * RESTRICT const cmdline,
                         int * RESTRICT const argc);
void split_commandline_free(char ** argv,
                            const int argc);

void new_system(struct stardata_t ** stardata,
                struct stardata_t *** previous_stardatas,
                struct preferences_t ** preferences,
                struct store_t ** store,
                char ** argv,
                const int argc);

void set_cmd_line_macro_pairs(struct stardata_t * RESTRICT const stardata,
                              struct cmd_line_arg_t * const cmd_line_args2,
                              unsigned int arg_count);
void set_metallicities(struct stardata_t * RESTRICT const stardata);
char * cmd_line_argstring(struct stardata_t * const stardata);


#endif /* SETUP_PROTOYPES_H */
