/*
 * This function initializes the metallicties used in various parts
 * of binary_c
 */
#include "../binary_c.h"

void set_metallicities(struct stardata_t * RESTRICT const stardata)
{
    /*
     * If the effective or nucsyn metallicity are < 0, 
     * set it to the metallicity
     */
    if(Negative_nonzero(stardata->common.effective_metallicity))
    {
        stardata->common.effective_metallicity =
            stardata->common.metallicity;
        Dprint("Set effective metallicity %g\n",
               stardata->common.effective_metallicity);
    }
#ifdef NUCSYN
    if(Negative_nonzero(stardata->common.nucsyn_metallicity))
    {
        stardata->common.nucsyn_metallicity =
            stardata->common.metallicity;
        Dprint("Set nucsyn metallicity %g\n",
               stardata->common.nucsyn_metallicity);
    }
#endif // NUCSYN
}
