
#include "../binary_c.h"

#define dprint(P,...) Dprint_to_pointer((P),TRUE,__VA_ARGS__);

void set_defaults(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Set defaults into stardata
     */
    Star_number k;
    Starloop(k)
    {
        dprint(stardata,"Call init star for star %d\n",k);
        init_star(stardata,&((stardata)->star[k]));
        (stardata)->star[k].starnum = k;
    }

    dprint(stardata,"call init model\n");    
    init_model(&(stardata)->model);

    dprint(stardata,"call init common\n");
    init_common(stardata);

    set_default_preferences(stardata->preferences);
}
