#include "../binary_c.h"
#include "cmd_line_macro_pairs.h"

static struct cmd_line_arg_t * match_a(char * const VARNAME,
                                       struct cmd_line_arg_t ** const __prevarg,
                                       char ** const __prevstring,
                                       struct cmd_line_arg_t * const cmd_line_args2,
                                       unsigned int arg_count);

void set_cmd_line_macro_pairs(struct stardata_t * RESTRICT const stardata,
                              struct cmd_line_arg_t * const cmd_line_args2,
                              unsigned int arg_count)
{
    /*
     * Here we map a command line argument's value to a macro so you 
     * can use the macro as the argument, rather than just a number.
     *
     * Usage:
     * 
     * Add_value_macro_pair("the_argument",
     *                      C_MACRO);
     */
    unsigned int __i;
    struct cmd_line_arg_t * __prevarg = NULL; 
    char * __prevstring = NULL;
    Add_value_macro_pair("stellar_structure_algorithm",
                         STELLAR_STRUCTURE_ALGORITHM_MODIFIED_BSE);
    Add_value_macro_pair("stellar_structure_algorithm",
                         STELLAR_STRUCTURE_ALGORITHM_NONE);
    Add_value_macro_pair("stellar_structure_algorithm",
                         STELLAR_STRUCTURE_ALGORITHM_EXTERNAL_FUNCTION);
    Add_value_macro_pair("stellar_structure_algorithm",
                         STELLAR_STRUCTURE_ALGORITHM_BINT);
    Add_value_macro_pair("stellar_type_1",
                         LOW_MASS_MAIN_SEQUENCE);
    Add_value_macro_pair("stellar_type_1",
                         LOW_MASS_MS);
    Add_value_macro_pair("stellar_type_1",
                         MAIN_SEQUENCE);
    Add_value_macro_pair("stellar_type_1",
                         MS);
    Add_value_macro_pair("stellar_type_1",
                         HG);
    Add_value_macro_pair("stellar_type_1",
                         HERTZSPRUNG_GAP);
    Add_value_macro_pair("stellar_type_1",
                         GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_1",
                         FIRST_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_1",
                         CHeB);
    Add_value_macro_pair("stellar_type_1",
                         CORE_HELIUM_BURNING);
    Add_value_macro_pair("stellar_type_1",
                         EAGB);
    Add_value_macro_pair("stellar_type_1",
                         EARLY_ASYMPTOTIC_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_1",
                         TPAGB);
    Add_value_macro_pair("stellar_type_1",
                         THERMALLY_PULSING_ASYMPTOTIC_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_1",
                         HeMS);
    Add_value_macro_pair("stellar_type_1",
                         NAKED_MAIN_SEQUENCE_HELIUM_STAR);
    Add_value_macro_pair("stellar_type_1",
                         HeHG);
    Add_value_macro_pair("stellar_type_1",
                         NAKED_HELIUM_STAR_HERTZSPRUNG_GAP);
    Add_value_macro_pair("stellar_type_1",
                         HeGB);
    Add_value_macro_pair("stellar_type_1",
                         NAKED_HELIUM_STAR_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_1",
                         HeWD);
    Add_value_macro_pair("stellar_type_1",
                         HELIUM_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_1",
                         COWD);
    Add_value_macro_pair("stellar_type_1",
                         CARBON_OXYGEN_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_1",
                         ONeWD);
    Add_value_macro_pair("stellar_type_1",
                         OXYGEN_NEON_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_1",
                         NS);
    Add_value_macro_pair("stellar_type_1",
                         NEUTRON_STAR);
    Add_value_macro_pair("stellar_type_1",
                         BH);
    Add_value_macro_pair("stellar_type_1",
                         BLACK_HOLE);
    Add_value_macro_pair("stellar_type_1",
                         MASSLESS_REMNANT);
    Add_value_macro_pair("stellar_type_2",
                         LOW_MASS_MAIN_SEQUENCE);
    Add_value_macro_pair("stellar_type_2",
                         LOW_MASS_MS);
    Add_value_macro_pair("stellar_type_2",
                         MAIN_SEQUENCE);
    Add_value_macro_pair("stellar_type_2",
                         MS);
    Add_value_macro_pair("stellar_type_2",
                         HG);
    Add_value_macro_pair("stellar_type_2",
                         HERTZSPRUNG_GAP);
    Add_value_macro_pair("stellar_type_2",
                         GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_2",
                         FIRST_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_2",
                         CHeB);
    Add_value_macro_pair("stellar_type_2",
                         CORE_HELIUM_BURNING);
    Add_value_macro_pair("stellar_type_2",
                         EAGB);
    Add_value_macro_pair("stellar_type_2",
                         EARLY_ASYMPTOTIC_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_2",
                         TPAGB);
    Add_value_macro_pair("stellar_type_2",
                         THERMALLY_PULSING_ASYMPTOTIC_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_2",
                         HeMS);
    Add_value_macro_pair("stellar_type_2",
                         NAKED_MAIN_SEQUENCE_HELIUM_STAR);
    Add_value_macro_pair("stellar_type_2",
                         HeHG);
    Add_value_macro_pair("stellar_type_2",
                         NAKED_HELIUM_STAR_HERTZSPRUNG_GAP);
    Add_value_macro_pair("stellar_type_2",
                         HeGB);
    Add_value_macro_pair("stellar_type_2",
                         NAKED_HELIUM_STAR_GIANT_BRANCH);
    Add_value_macro_pair("stellar_type_2",
                         HeWD);
    Add_value_macro_pair("stellar_type_2",
                         HELIUM_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_2",
                         COWD);
    Add_value_macro_pair("stellar_type_2",
                         CARBON_OXYGEN_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_2",
                         ONeWD);
    Add_value_macro_pair("stellar_type_2",
                         OXYGEN_NEON_WHITE_DWARF);
    Add_value_macro_pair("stellar_type_2",
                         NS);
    Add_value_macro_pair("stellar_type_2",
                         NEUTRON_STAR);
    Add_value_macro_pair("stellar_type_2",
                         BH);
    Add_value_macro_pair("stellar_type_2",
                         BLACK_HOLE);
    Add_value_macro_pair("stellar_type_2",
                         MASSLESS_REMNANT);
    Add_value_macro_pair("vrot1",
                         VROT_BSE);
    Add_value_macro_pair("vrot1",
                         VROT_NON_ROTATING);
    Add_value_macro_pair("vrot1",
                         VROT_BREAKUP);
    Add_value_macro_pair("vrot1",
                         VROT_SYNC);
    Add_value_macro_pair("vrot2",
                         VROT_BSE);
    Add_value_macro_pair("vrot2",
                         VROT_NON_ROTATING);
    Add_value_macro_pair("vrot2",
                         VROT_BREAKUP);
    Add_value_macro_pair("vrot2",
                         VROT_SYNC);
    Add_value_macro_pair("wind_angular_momentum_loss",
                         WIND_ANGMOM_LOSS_BSE);
    Add_value_macro_pair("wind_angular_momentum_loss",
                         WIND_ANGMOM_LOSS_LW);
    Add_value_macro_pair("wind_angular_momentum_loss",
                         WIND_ANGMOM_LOSS_LW_HYBRID);
    Add_value_macro_pair("wind_angular_momentum_loss",
                         WIND_ANGMOM_LOSS_SPHERICALLY_SYMMETRIC);
    Add_value_macro_pair("gravitational_radiation_model",
                         GRAVITATIONAL_RADIATION_BSE);
    Add_value_macro_pair("gravitational_radiation_model",
                         GRAVITATIONAL_RADIATION_BSE_WHEN_NO_RLOF);
    Add_value_macro_pair("gravitational_radiation_model",
                         GRAVITATIONAL_RADIATION_NONE);
    Add_value_macro_pair("gravitational_radiation_model",
                         GRAVITATIONAL_RADIATION_LANDAU_LIFSHITZ);
    Add_value_macro_pair("gravitational_radiation_model",
                         GRAVITATIONAL_RADIATION_LANDAU_LIFSHITZ_WHEN_NO_RLOF);
    Add_value_macro_pair("magnetic_braking_algorithm",
                         MAGNETIC_BRAKING_ALGORITHM_HURLEY_2002);
    Add_value_macro_pair("magnetic_braking_algorithm",
                         MAGNETIC_BRAKING_ALGORITHM_ANDRONOV_2003);
    Add_value_macro_pair("magnetic_braking_algorithm",
                         MAGNETIC_BRAKING_ALGORITHM_BARNES_2010);
    Add_value_macro_pair("magnetic_braking_algorithm",
                         MAGNETIC_BRAKING_ALGORITHM_RAPPAPORT_1983);
    Add_value_macro_pair("E2_prescription",
                         E2_HURLEY_2002);
    Add_value_macro_pair("E2_prescription",
                         E2_IZZARD);
    Add_value_macro_pair("RLOF_method",
                         RLOF_METHOD_BSE);
    Add_value_macro_pair("RLOF_method",
                         RLOF_METHOD_ADAPTIVE);
    Add_value_macro_pair("RLOF_method",
                         RLOF_METHOD_RITTER);
    Add_value_macro_pair("RLOF_method",
                         RLOF_METHOD_CLAEYS);
    Add_value_macro_pair("RLOF_interpolation_method",
                         RLOF_INTERPOLATION_BINARY_C);
    Add_value_macro_pair("RLOF_interpolation_method",
                         RLOF_INTERPOLATION_BSE);
    Add_value_macro_pair("RLOF_angular_momentum_transfer_model",
                         RLOF_ANGULAR_MOMENTUM_TRANSFER_MODEL_BSE);
    Add_value_macro_pair("RLOF_angular_momentum_transfer_model",
                         RLOF_ANGULAR_MOMENTUM_TRANSFER_MODEL_CONSERVATIVE);
    Add_value_macro_pair("nonconservative_angmom_gamma",
                         RLOF_NONCONSERVATIVE_GAMMA_DONOR);
    Add_value_macro_pair("nonconservative_angmom_gamma",
                         RLOF_NONCONSERVATIVE_GAMMA_ISOTROPIC);
    Add_value_macro_pair("hachisu_qcrit",
                         HACHISU_IGNORE_QCRIT);
    Add_value_macro_pair("comenv_prescription",
                         COMENV_BSE);
    Add_value_macro_pair("comenv_prescription",
                         COMENV_NELEMANS_TOUT);
    Add_value_macro_pair("comenv_prescription",
                         COMENV_NANDEZ2016);
    Add_value_macro_pair("lambda_ce",
                         LAMBDA_CE_DEWI_TAURIS);
    Add_value_macro_pair("lambda_ce",
                         LAMBDA_CE_WANG_2016);
    Add_value_macro_pair("lambda_ce",
                         LAMBDA_CE_POLYTROPE);
    Add_value_macro_pair("comenv_merger_spin_method",
                         COMENV_MERGER_SPIN_METHOD_SPECIFIC);
    Add_value_macro_pair("comenv_merger_spin_method",
                         COMENV_MERGER_SPIN_METHOD_CONSERVE_ANGMOM);
    Add_value_macro_pair("comenv_merger_spin_method",
                         COMENV_MERGER_SPIN_METHOD_CONSERVE_OMEGA);
    Add_value_macro_pair("comenv_merger_spin_method",
                         COMENV_MERGER_SPIN_METHOD_BREAKUP);
    Add_value_macro_pair("comenv_ejection_spin_method",
                         COMENV_EJECTION_SPIN_METHOD_DO_NOTHING);
    Add_value_macro_pair("comenv_ejection_spin_method",
                         COMENV_EJECTION_SPIN_METHOD_SYNCHRONIZE);
    Add_value_macro_pair("disc_log",
                         DISC_LOG_LEVEL_NONE);
    Add_value_macro_pair("disc_log",
                         DISC_LOG_LEVEL_NORMAL);
    Add_value_macro_pair("disc_log",
                         DISC_LOG_LEVEL_SUBTIMESTEP);
    Add_value_macro_pair("disc_log",
                         DISC_LOG_LEVEL_NORMAL_FIRST_DISC_ONLY);
    Add_value_macro_pair("disc_log",
                         DISC_LOG_LEVEL_SUBTIMESTEP_FIRST_DISC_ONLY);
    Add_value_macro_pair("disc_log2d",
                         DISC_LOG_LEVEL_NONE);
    Add_value_macro_pair("disc_log2d",
                         DISC_LOG_LEVEL_NORMAL);
    Add_value_macro_pair("disc_log2d",
                         DISC_LOG_LEVEL_SUBTIMESTEP);
    Add_value_macro_pair("disc_log2d",
                         DISC_LOG_LEVEL_NORMAL_FIRST_DISC_ONLY);
    Add_value_macro_pair("disc_log2d",
                         DISC_LOG_LEVEL_SUBTIMESTEP_FIRST_DISC_ONLY);
    Add_value_macro_pair("cbdisc_inner_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_INSTANT);
    Add_value_macro_pair("cbdisc_inner_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_INFINITE);
    Add_value_macro_pair("cbdisc_inner_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_VISCOUS);
    Add_value_macro_pair("cbdisc_inner_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_ORBIT);
    Add_value_macro_pair("cbdisc_outer_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_INSTANT);
    Add_value_macro_pair("cbdisc_outer_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_INFINITE);
    Add_value_macro_pair("cbdisc_outer_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_VISCOUS);
    Add_value_macro_pair("cbdisc_outer_edge_stripping_timescale",
                         DISC_STRIPPING_TIMESCALE_ORBIT);
    Add_value_macro_pair("cbdisc_eccentricity_pumping_method",
                         CBDISC_ECCENTRICITY_PUMPING_NONE);
    Add_value_macro_pair("cbdisc_eccentricity_pumping_method",
                         CBDISC_ECCENTRICITY_PUMPING_DERMINE);
    Add_value_macro_pair("equation_of_state_algorithm",
                         EQUATION_OF_STATE_PACZYNSKI);
    Add_value_macro_pair("opacity_algorithm",
                         OPACITY_ALGORITHM_PACZYNSKI);
    Add_value_macro_pair("opacity_algorithm",
                         OPACITY_ALGORITHM_FERGUSON_OPAL);
    Add_value_macro_pair("opacity_algorithm",
                         OPACITY_ALGORITHM_STARS);
    Add_value_macro_pair("beta_reverse_nova",
                         BETA_REVERSE_NOVAE_GEOMETRY);
    Add_value_macro_pair("wind_mass_loss",
                         WIND_ALGORITHM_NONE);
    Add_value_macro_pair("wind_mass_loss",
                         WIND_ALGORITHM_HURLEY2002);
    Add_value_macro_pair("wind_mass_loss",
                         WIND_ALGORITHM_SCHNEIDER2018);
    Add_value_macro_pair("gbwind",
                         GB_WIND_REIMERS);
    Add_value_macro_pair("gbwind",
                         GB_WIND_SCHROEDER_CUNTZ_2005);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_BLOECKER);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_VW93_KARAKAS);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_VW93_ORIG);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_REIMERS);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_VAN_LOON);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_ROB_CWIND);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_VW93_KARAKAS_CARBON_STARS);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_VW93_ORIG_CARBON_STARS);
    Add_value_macro_pair("tpagbwind",
                         AGB_WIND_MATTSSON);
    Add_value_macro_pair("wr_wind",
                         WR_WIND_BSE);
    Add_value_macro_pair("wr_wind",
                         WR_WIND_MAEDER_MEYNET);
    Add_value_macro_pair("wr_wind",
                         WR_WIND_NUGIS_LAMERS);
    Add_value_macro_pair("wr_wind",
                         WR_WIND_ELDRIDGE);
    Add_value_macro_pair("overspin_algorithm",
                         OVERSPIN_BSE);
    Add_value_macro_pair("overspin_algorithm",
                         OVERSPIN_MASSLOSS);
    Add_value_macro_pair("rotationally_enhanced_mass_loss",
                         ROTATIONALLY_ENHNACED_MASSLOSS_NONE);
    Add_value_macro_pair("rotationally_enhanced_mass_loss",
                         ROTATIONALLY_ENHNACED_MASSLOSS_LANGER_FORMULA);
    Add_value_macro_pair("rotationally_enhanced_mass_loss",
                         ROTATIONALLY_ENHNACED_MASSLOSS_ANGMOM);
    Add_value_macro_pair("rotationally_enhanced_mass_loss",
                         ROTATIONALLY_ENHNACED_MASSLOSS_LANGER_FORMULA_AND_ANGMOM);
    Add_value_macro_pair("WRLOF_method",
                         WRLOF_NONE);
    Add_value_macro_pair("WRLOF_method",
                         WRLOF_Q_DEPENDENT);
    Add_value_macro_pair("WRLOF_method",
                         WRLOF_QUADRATIC);
    Add_value_macro_pair("BH_prescription",
                         BH_HURLEY2002);
    Add_value_macro_pair("BH_prescription",
                         BH_BELCZYNSKI);
    Add_value_macro_pair("BH_prescription",
                         BH_SPERA2015);
    Add_value_macro_pair("BH_prescription",
                         BH_FRYER12_DELAYED);
    Add_value_macro_pair("BH_prescription",
                         BH_FRYER12_RAPID);
    Add_value_macro_pair("type_Ia_MCh_supernova_algorithm",
                         TYPE_IA_MCH_SUPERNOVA_ALGORITHM_DD2);
    Add_value_macro_pair("type_Ia_MCh_supernova_algorithm",
                         TYPE_IA_MCH_SUPERNOVA_ALGORITHM_SEITENZAHL2013);
    Add_value_macro_pair("type_Ia_MCh_supernova_algorithm",
                         TYPE_IA_MCH_SUPERNOVA_ALGORITHM_SEITENZAHL2013_AUTOMATIC);
    Add_value_macro_pair("type_Ia_sub_MCh_supernova_algorithm",
                         TYPE_IA_SUB_MCH_SUPERNOVA_ALGORITHM_LIVNE_ARNETT_1995);
    Add_value_macro_pair("WDWD_merger_algorithm",
                         WDWD_MERGER_ALGORITHM_BSE);
    Add_value_macro_pair("WDWD_merger_algorithm",
                         WDWD_MERGER_ALGORITHM_PERETS2019);
    Add_value_macro_pair("WDWD_merger_algorithm",
                         WDWD_MERGER_ALGORITHM_CHEN2016);
    Add_value_macro_pair("post_SN_orbit_method",
                         POST_SN_ORBIT_BSE);
    Add_value_macro_pair("post_SN_orbit_method",
                         POST_SN_ORBIT_TT98);
    Add_value_macro_pair("sn_kick_distribution_IBC",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_IBC",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_IBC",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_II",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_II",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_II",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_GRB_COLLAPSAR",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_GRB_COLLAPSAR",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_GRB_COLLAPSAR",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_ECAP",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_ECAP",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_ECAP",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_NS_NS",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_NS_NS",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_NS_NS",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_TZ",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_TZ",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_TZ",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_AIC_BH",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_AIC_BH",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_AIC_BH",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_BH_BH",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_BH_BH",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_BH_BH",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_BH_NS",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_BH_NS",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_BH_NS",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD_subluminous",
                         KICK_VELOCITY_FIXED);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD_subluminous",
                         KICK_VELOCITY_MAXWELLIAN);
    Add_value_macro_pair("sn_kick_distribution_IA_Hybrid_HeCOWD_subluminous",
                         KICK_VELOCITY_CUSTOM);
    Add_value_macro_pair("sn_kick_companion_IA_He",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_ELD",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_AIC",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_ECAP",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_He_Coal",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND_Coal",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_NS_NS",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_GRB_COLLAPSAR",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_HeStarIa",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IBC",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_II",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IIa",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_WDKICK",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_TZ",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_AIC_BH",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_BH_BH",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_BH_NS",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD_subluminous",
                         SN_IMPULSE_NONE);
    Add_value_macro_pair("sn_kick_companion_IA_He",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_ELD",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_AIC",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_ECAP",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_He_Coal",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND_Coal",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_NS_NS",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_GRB_COLLAPSAR",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_HeStarIa",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IBC",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_II",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IIa",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_WDKICK",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_TZ",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_AIC_BH",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_BH_BH",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_BH_NS",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD_subluminous",
                         SN_IMPULSE_LIU2015);
    Add_value_macro_pair("sn_kick_companion_IA_He",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_ELD",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_AIC",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_ECAP",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_He_Coal",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_CHAND_Coal",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_NS_NS",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_GRB_COLLAPSAR",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_HeStarIa",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IBC",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_II",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IIa",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_WDKICK",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_TZ",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_AIC_BH",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_BH_BH",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_BH_NS",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD_subluminous",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD_subluminous",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("sn_kick_companion_IA_Hybrid_HeCOWD_subluminous",
                         SN_IMPULSE_WHEELER1975);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_RANDOM);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_FORWARD);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_BACKWARD);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_STRAIGHT_UP);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_INWARD);
    Add_value_macro_pair("wd_kick_direction",
                         KICK_OUTWARD);
    Add_value_macro_pair("wd_kick_when",
                         WD_KICK_END_AGB);
    Add_value_macro_pair("wd_kick_when",
                         WD_KICK_FIRST_RLOF);
    Add_value_macro_pair("wd_kick_when",
                         WD_KICK_AT_GIVEN_PULSE);
    Add_value_macro_pair("wd_kick_when",
                         WD_KICK_AT_EVERY_PULSE);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_AG89);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_KARAKAS2002);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_LODDERS2003);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_ASPLUND2005);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_GARCIABERRO);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_GREVESSE_NOELS_1993);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_ASPLUND2009);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_KOBAYASHI2011_ASPLUND2009);
    Add_value_macro_pair("initial_abundance_mix",
                         NUCSYN_INIT_ABUND_MIX_LODDERS2010);
    Add_value_macro_pair("small_envelope_method",
                         SMALL_ENVELOPE_METHOD_BSE);
    Add_value_macro_pair("small_envelope_method",
                         SMALL_ENVELOPE_METHOD_MILLER_BERTOLAMI);
    Add_value_macro_pair("AGB_core_algorithm",
                         AGB_CORE_ALGORITHM_DEFAULT);
    Add_value_macro_pair("AGB_core_algorithm",
                         AGB_CORE_ALGORITHM_HURLEY);
    Add_value_macro_pair("AGB_core_algorithm",
                         AGB_CORE_ALGORITHM_KARAKAS);
    Add_value_macro_pair("AGB_radius_algorithm",
                         AGB_RADIUS_ALGORITHM_DEFAULT);
    Add_value_macro_pair("AGB_radius_algorithm",
                         AGB_RADIUS_ALGORITHM_HURLEY);
    Add_value_macro_pair("AGB_radius_algorithm",
                         AGB_RADIUS_ALGORITHM_KARAKAS);
    Add_value_macro_pair("AGB_luminosity_algorithm",
                         AGB_LUMINOSITY_ALGORITHM_DEFAULT);
    Add_value_macro_pair("AGB_luminosity_algorithm",
                         AGB_LUMINOSITY_ALGORITHM_HURLEY);
    Add_value_macro_pair("AGB_luminosity_algorithm",
                         AGB_LUMINOSITY_ALGORITHM_KARAKAS);
    Add_value_macro_pair("AGB_3dup_algorithm",
                         AGB_THIRD_DREDGE_UP_ALGORITHM_DEFAULT);
    Add_value_macro_pair("AGB_3dup_algorithm",
                         AGB_THIRD_DREDGE_UP_ALGORITHM_HURLEY);
    Add_value_macro_pair("AGB_3dup_algorithm",
                         AGB_THIRD_DREDGE_UP_ALGORITHM_KARAKAS);
    Add_value_macro_pair("AGB_3dup_algorithm",
                         AGB_THIRD_DREDGE_UP_ALGORITHM_STANCLIFFE);
    Add_value_macro_pair("angelou_lithium_decay_function",
                         ANGELOU_LITHIUM_DECAY_FUNCTION_EXPONENTIAL);
    Add_value_macro_pair("internal_buffering",
                         INTERNAL_BUFFERING_OFF);
    Add_value_macro_pair("internal_buffering",
                         INTERNAL_BUFFERING_PRINT);
    Add_value_macro_pair("internal_buffering",
                         INTERNAL_BUFFERING_STORE);
    Add_value_macro_pair("cbdisc_mass_loss_inner_viscous_accretion_method",
                         CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_YOUNG_CLARKE_2015);
    Add_value_macro_pair("cbdisc_mass_loss_inner_viscous_accretion_method",
                         CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_GEROSA_2015);
    Add_value_macro_pair("cbdisc_mass_loss_inner_viscous_accretion_method",
                         CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_EQUAL);
    Add_value_macro_pair("cbdisc_mass_loss_inner_viscous_accretion_method",
                         CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_NONE);
    Add_value_macro_pair("accretion_start_time",
                         ARTIFICIAL_ACCRETION_IGNORE);
    Add_value_macro_pair("accretion_end_time",
                         ARTIFICIAL_ACCRETION_IGNORE);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_BSE);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_HJELLMING_WEBBINK);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_Q_NO_COMENV);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_CHEN_HAN_TABLE);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_CHEN_HAN_FORMULA);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_GE2015);
    Add_value_macro_pair("qcrit_GB",
                         QCRIT_GB_VOS2018);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_BSE);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_HJELLMING_WEBBINK);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_Q_NO_COMENV);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_CHEN_HAN_TABLE);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_CHEN_HAN_FORMULA);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_GE2015);
    Add_value_macro_pair("qcrit_EAGB",
                         QCRIT_GB_VOS2018);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_BSE);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_HJELLMING_WEBBINK);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_Q_NO_COMENV);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_CHEN_HAN_TABLE);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_CHEN_HAN_FORMULA);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_GE2015);
    Add_value_macro_pair("qcrit_TPAGB",
                         QCRIT_GB_VOS2018);
    Add_value_macro_pair("solver",
                         SOLVER_FORWARD_EULER);
    Add_value_macro_pair("solver",
                         SOLVER_RK2);
    Add_value_macro_pair("solver",
                         SOLVER_RK4);
    Add_value_macro_pair("solver",
                         SOLVER_PREDICTOR_CORRECTOR);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_hydrogen_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_helium_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_other_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_hydrogen_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_helium_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_other_donor",
                         DONOR_RATE_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_hydrogen_donor",
                         DONOR_RATE_ALGORITHM_BSE);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_helium_donor",
                         DONOR_RATE_ALGORITHM_BSE);
    Add_value_macro_pair("WD_accretion_rate_novae_upper_limit_other_donor",
                         DONOR_RATE_ALGORITHM_BSE);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_hydrogen_donor",
                         DONOR_RATE_ALGORITHM_BSE);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_helium_donor",
                         DONOR_RATE_ALGORITHM_BSE);
    Add_value_macro_pair("WD_accretion_rate_new_giant_envelope_lower_limit_other_donor",
                         DONOR_RATE_ALGORITHM_BSE);

    Add_value_macro_pair("nova_retention_method",
                         NOVA_RETENTION_ALGORITHM_CONSTANT);
    Add_value_macro_pair("nova_retention_method",
                         NOVA_RETENTION_ALGORITHM_CLAEYS2014);
    Add_value_macro_pair("nova_retention_method",
                         NOVA_RETENTION_ALGORITHM_HILLMAN2015);
    Add_value_macro_pair("effective_metallicity",
                         DEFAULT_TO_METALLICITY);
    Add_value_macro_pair("nucsyn_metallicity",
                         DEFAULT_TO_METALLICITY);

    
    /*
     * ARGUMENT MACROS
     *
     * Here we map the %d in an argument name to a macro.
     */
    Add_argument_macro_pair("timestep_multiplier%d",
                            NONE,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            PREMS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            PREROCHE_MS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            PREROCHE_HG,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            HG,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            FGB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CHeB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            EAGB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            EAGB_AXEL,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            EAGB_PREROCHE,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TPAGB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TPAGB_NUCSYN_INTERPULSE,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TPAGB_NUCSYN_SPEEDUP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TPAGB_NUCSYN_PREROCHE,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TPAGB_NUCSYN_KARAKAS_SMOOTH,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            HeMS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            HeHG_GB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            OTHER_STELLAR_TYPES,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            STELLAR_ANGMOM,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            STELLAR_MASS_LOSS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            STELLAR_MAGNETIC_BRAKING,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CIRCUMBINARY_DISC,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            RESOLVE_POSTAGB,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            DISC,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            FASTWIND,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            SELMA,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CEMP_POSTMS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CEMP_NOTEMP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CEMP_EMP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CEMP_NEARLY,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CEMP_FLOOR,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            FABIAN_IMF_LOG,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            HRD1,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            HRD2,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            BLUE_STRAGGLER,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            YVT,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MINIMUM_TIMESTEP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MAXIMUM_TIMESTEP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            NOVAE,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            ARTIFICIAL_ACCRETION,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            SN,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MASS_GAIN,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MASS_LOSS,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TIDES,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            NUCSYN_ANGELOU_LITHIUM,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            CARBON_BURNING,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            BURN_IN,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            RADIUS_CHANGES,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MASSLESS_REMNANT,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            ORBITAL_ANGMOM,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            STELLAR_ANGMOM2,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TIDES2,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MASS_GAIN2,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            MASS_LOSS2,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            GRAVITATIONAL_WAVE_RADIATION,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            RLOF,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            FIXED_TIMESTEP,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            TIME_REMAINING,
                            DT_LIMIT_);
    Add_argument_macro_pair("timestep_multiplier%d",
                            ZOOMFAC,
                            DT_LIMIT_);
    Add_argument_macro_pair("use_fixed_timestep_%d",
                            YIELDS,
                            FIXED_TIMESTEP_);
    Add_argument_macro_pair("use_fixed_timestep_%d",
                            TEST,
                            FIXED_TIMESTEP_);
}

static struct cmd_line_arg_t * match_a(char * const var_name,
                                       struct cmd_line_arg_t ** const __prevarg,
                                       char ** const __prevstring,
                                       struct cmd_line_arg_t * const cmd_line_args2,
                                       unsigned int arg_count)
{   
    struct cmd_line_arg_t * a = NULL;
    
    if(__prevarg != NULL &&
       *__prevarg != NULL &&                                     
       Strings_equal(var_name,
                     *__prevstring))                          
    {                                                           
        /* cache match previous */                              
        a = *__prevarg;                                          
    }                                                        
    else                                                     
    {                                                        
        /* loop to find next match or leave a as  NULL */    
        unsigned int __i;
        for(__i=0; __i<arg_count; __i++)                     
        {
            if(Strings_equal(var_name,
                             cmd_line_args2[__i].name))
            {
                a = &cmd_line_args2[__i];
                __i = arg_count;
                /* update cache */
                *__prevarg = a;
                *__prevstring = (char*)a->name;
            }
        }
    }
    return a;
}

