#include "../binary_c.h"
/*
 * Return a new random seed.
 */

Random_seed random_seed(void)
{
    Random_seed ret;
    
    /*
     * Change random seed every millisecond,nanosecond or second
     * every second
     */ 
    long int t;

#ifdef NANOSECOND_RANDOMNESS
    /*
     * nanosecond accuracy
     */
    struct timespec ts;
    timespec_get(&ts,
                 TIME_UTC);
    t = 1000*1000*1000*ts.tv_sec + ts.tv_nsec;
    //printf("TRAND NANO %ld = 1e9 * %ld + %ld\n",
    //t,(long int)ts.tv_sec,(long int)ts.tv_nsec);
#elif defined MILLISECOND_RANDOMNESS
    /* 
     * millisecond accuracy
     */
    struct timeb tp;
    ftime(&tp);
    t = 1000 * tp.time + tp.millitm;
    //printf("TRAND MILLI %ld = 1000 * %ld + %ld\n",
    //t,(long int)tp.time,(long int)tp.millitm);
#else
    /*
     * 1-second accuracy is sometimes good enough
     */
    t = time(NULL) * rand();
#endif

    /*
     * NB -1 to make sure it's negative! (just in case t=0)
     */
    ret = (Random_seed)(((long int)(t))%((int)DAY_LENGTH_IN_SECONDS)-1);
    if(ret==0) ret = +1;
               
    return ret;
}
