#pragma once
#ifndef CMD_LINE_MACROS_H
#define CMD_LINE_MACROS_H

/* 
 * Define macros that depend on code build options
 */ 


#ifdef RANDOM_SYSTEMS
#define RANDOM_SYSTEMS_VAR &(stardata->preferences->random_systems)
#else
#define RANDOM_SYSTEMS_VAR NULL
#endif

#ifdef FILE_LOG
#define LOG_FILENAME_VAR &(stardata->preferences->log_filename)
#else
#define LOG_FILENAME_VAR NULL
#endif

#ifdef FILE_LOG
#define API_LOG_FILENAME_PREFIX_VAR &(stardata->preferences->api_log_filename_prefix)
#else
#define API_LOG_FILENAME_PREFIX_VAR NULL
#endif


#ifdef COMENV_MS_ACCRETION
#define CE_MS_ACCRETION_FRACTION_VAR &(stardata->preferences->comenv_ns_accretion_fraction);
#define CE_MS_ACCRETION_MASS_VAR &(stardata->preferences->comenv_ns_accretion_mass);
#else
#define CE_MS_ACCRETION_FRACTION_VAR NULL
#define CE_MS_ACCRETION_MASS_VAR NULL
#endif

#ifdef COMENV_NS_ACCRETION
#define CE_NS_ACCRETION_FRACTION_VAR &(stardata->preferences->comenv_ns_accretion_fraction);
#define CE_NS_ACCRETION_MASS_VAR &(stardata->preferences->comenv_ns_accretion_mass);
#else
#define CE_NS_ACCRETION_FRACTION_VAR NULL
#define CE_NS_ACCRETION_MASS_VAR NULL
#endif

#ifdef PHASE_VOLUME
#define PHASEVOL_VAR &(stardata->model.phasevol)
#else
#define PHASEVOL_VAR NULL
#endif

#ifdef VW93_MIRA_SHIFT
#define VW93_MIRA_SHIFT_VAR &(stardata->preferences->vw93_mira_shift)
#else
#define VW93_MIRA_SHIFT_VAR NULL
#endif

#ifdef VW93_MULTIPLIER
#define VW93_MULTIPLIER_VAR &(stardata->preferences->vw93_multiplier)
#else
#define VW93_MULTIPLIER_VAR NULL
#endif

#ifdef HRDIAG
#define HRDIAG_OUTPUT_VAR &(stardata->preferences->hrdiag_output)
#else
#define HRDIAG_OUTPUT_VAR NULL
#endif

#ifdef MATTSSON_MASS_LOSS
#define MATTSSON_ORICH_TPAGBWIND_VAR &(stardata->preferences->mattsson_Orich_tpagbwind)
#else
#define MATTSSON_ORICH_TPAGBWIND_VAR NULL
#endif


#define ROTATIONALLY_ENHANCED_MASS_LOSS_VAR &(stardata->preferences->rotationally_enhanced_mass_loss)
#define ROTATIONALLY_ENHANCED_EXPONENT_VAR &(stardata->preferences->rotationally_enhanced_exponent)

#ifdef PRE_MAIN_SEQUENCE
#define PRE_MAIN_SEQUENCE_VAR &(stardata->preferences->pre_main_sequence)
#define PRE_MAIN_SEQUENCE_FIT_LOBES_VAR &(stardata->preferences->pre_main_sequence_fit_lobes)
#else
#define PRE_MAIN_SEQUENCE_VAR NULL
#define PRE_MAIN_SEQUENCE_FIT_LOBES_VAR NULL
#endif


#ifdef TIMESTEP_MODULATION
#define TIMESTEP_MODULATOR_VAR &(stardata->preferences->timestep_modulator)
#else
#define TIMESTEP_MODULATOR_VAR NULL
#endif

#ifdef RLOF_RADATION_CORRECTION
#define RLOF_F_VAR &(stardata->preferences->RLOF_f)
#else
#define RLOF_F_VAR NULL
#endif

#ifdef RLOF_MDOT_MODULATION
#define RLOF_MDOT_MODULATOR_VAR &(stardata->preferences->RLOF_mdot_factor)
#else
#define RLOF_MDOT_MODULATOR_VAR NULL
#endif

#ifdef MANUAL_VROT
#define VROT_1_VAR &(stardata->star[0].vrot0)
#define VROT_2_VAR &(stardata->star[1].vrot0)
#else
#define VROT_1_VAR NULL
#define VROT_2_VAR NULL
#endif

#ifdef WD_KICKS
#define WD_SIGMA_VAR &(stardata->preferences->sn_kick_dispersion[SN_WDKICK])
#define WD_KICK_DIRECTION_VAR &(stardata->preferences->wd_kick_direction)
#define WD_KICK_WHEN_VAR &(stardata->preferences->wd_kick_when)
#define WD_KICK_PULSE_NUMBER_VAR &(stardata->preferences->wd_kick_pulse_number)
#else
#define WD_SIGMA_VAR NULL
#define WD_KICK_DIRECTION_VAR NULL
#define WD_KICK_WHEN_VAR NULL
#define WD_KICK_PULSE_NUMBER_VAR NULL
#endif

#ifdef WRLOF_MASS_TRANSFER
#define WRLOF_METHOD_VAR &(stardata->preferences->WRLOF_method)
#else
#define WRLOF_METHOD_VAR NULL
#endif

#ifdef FABIAN_IMF_LOG
#define NEXT_FABIAN_IMF_LOG_TIME_VAR &(stardata->model.next_fabian_imf_log_time)
#define NEXT_FABIAN_IMF_LOG_TIMESTEP_VAR &(stardata->model.fabian_imf_log_timestep)
#else
#define NEXT_FABIAN_IMF_LOG_TIME_VAR NULL
#define NEXT_FABIAN_IMF_LOG_TIMESTEP_VAR NULL
#endif

#define NUCSYN_DTFAC_VAR &(stardata->preferences->dtfac)

#ifdef NUCSYN
#define NUCSYN_METALLICITY_VAR &(stardata->common.nucsyn_metallicity)

#define NUCSYN_LAMBDA_MIN_VAR &(stardata->preferences->lambda_min)
#define NUCSYN_LAMBDA_MULTIPLIER_VAR &(stardata->preferences->lambda_multiplier)
#define NUCSYN_MINIMUM_ENVELOPE_MASS_FOR_THIRD_DREDGE_UP_VAR &(stardata->preferences->minimum_envelope_mass_for_third_dredgeup)
#define NUCSYN_INITIAL_ABUNDANCE_MIX_VAR &(stardata->preferences->initial_abundance_mix)
#define NO_THERMOHALINE_MIXING_VAR &(stardata->preferences->no_thermohaline_mixing)
#define INIT_ABUNDS_VAR &(stardata->preferences->initial_abunds_only)
#define NUCSYN_HBBTFAC_VAR &(stardata->preferences->hbbtfac)
#define NUCSYN_DELTA_MCMIN_VAR &(stardata->preferences->delta_mcmin)
#define INITIAL_ABUNDANCE_MIX_VAR &(stardata->preferences->initial_abundance_mix)
#define NUCSYN_TYPE_IA_MCH_SUPERNOVA_ALGORITHM_VAR &(stardata->preferences->type_Ia_MCh_supernova_algorithm) 
#define NUCSYN_TYPE_IA_SUB_MCH_SUPERNOVA_ALGORITHM_VAR &(stardata->preferences->type_Ia_sub_MCh_supernova_algorithm)
#define NUCSYN_SEITENZAHL2013_VAR &(stardata->preferences->Seitenzahl2013_model)

#else

#define NUCSYN_METALLICITY_VAR NULL

#define NUCSYN_LAMBDA_MIN_VAR NULL
#define NUCSYN_LAMBDA_MULTIPLIER_VAR NULL
#define NUCSYN_MINIMUM_ENVELOPE_MASS_FOR_THIRD_DREDGE_UP_VAR NULL
#define NUCSYN_INITIAL_ABUNDANCE_MIX_VAR NULL
#define NO_THERMOHALINE_MIXING_VAR NULL
#define INIT_ABUNDS_VAR NULL
#define NUCSYN_HBBTFAC_VAR NULL
#define NUCSYN_DELTA_MCMIN_VAR NULL
#define INITIAL_ABUNDANCE_MIX_VAR NULL
#define NUCSYN_TYPE_IA_MCH_SUPERNOVA_ALGORITHM_VAR NULL
#define NUCSYN_TYPE_IA_SUB_MCH_SUPERNOVA_ALGORITHM_VAR NULL
#define NUCSYN_SEITENZAHL2013_VAR NULL
#endif

#if (defined NUCSYN) && (defined LITHIUM_TABLES)
#define LITHIUM_GB_POST_1DUP_VAR &(stardata->preferences->lithium_GB_post_1DUP)
#define LITHIUM_GB_POST_HEFLASH_VAR &(stardata->preferences->lithium_GB_post_Heflash)
#define LITHIUM_GB_HBB_MULTIPLIER_VAR &(stardata->preferences->lithium_hbb_multiplier)
#else
#define LITHIUM_GB_POST_1DUP_VAR NULL
#define LITHIUM_GB_POST_HEFLASH_VAR NULL
#define LITHIUM_GB_HBB_MULTIPLIER_VAR NULL
#endif

#if (defined NUCSYN) && (defined NUCLEAR_REACTION_RATE_MULTIPLIERS)
#define NUCSYN_REACTION_RATE_MULTIPLIERS_VAR &(stardata->preferences->reaction_rate_multipliers)
#else
#define NUCSYN_REACTION_RATE_MULTIPLIERS_VAR NULL
#endif

#if (defined NUCSYN) && (defined NUCSYN_SPARSE_YIELDS)
#define NUCSYN_YIELDS_DT_VAR &(stardata->preferences->yields_dt)
#else
#define NUCSYN_YIELDS_DT_VAR NULL
#endif
#if (defined NUCSYN) && (defined NUCSYN_SPARSE_YIELDS)
#define NUCSYN_YIELDS_LOGDT_VAR &(stardata->preferences->yields_logdt)
#else
#define NUCSYN_YIELDS_LOGDT_VAR NULL
#endif
#if (defined NUCSYN) && (defined NUCSYN_SPARSE_YIELDS)
#define NUCSYN_YIELDS_STARTLOGTIME_VAR &(stardata->preferences->yields_startlogtime)
#else
#define NUCSYN_YIELDS_STARTLOGTIME_VAR NULL
#endif
#if (defined NUCSYN) && (defined NUCSYN_SPARSE_YIELDS)
#define NUCSYN_YIELDS_LOGTIMES_VAR &(stardata->preferences->yields_logtimes)
#else
#define NUCSYN_YIELDS_LOGTIMES_VAR NULL
#endif


#if (defined NUCSYN) && (defined NUCSYN_TPAGB_HBB)
#define NeNaMgAl_VAR &(stardata->preferences->NeNaMgAl)
#else
#define NeNaMgAl_VAR NULL
#endif



#if (defined NUCSYN) && (defined NUCSYN_S_PROCESS)
#define NUCSYN_C13_EFF_VAR &(stardata->preferences->c13_eff)
#define NUCSYN_MC13_POCKET_MULTIPLIER_VAR &(stardata->preferences->mc13_pocket_multiplier)
#else
#define NUCSYN_C13_EFF_VAR NULL
#define NUCSYN_MC13_POCKET_MULTIPLIER_VAR NULL
#endif

#if (defined NUCSYN) && (defined USE_TABULAR_INTERSHELL_ABUNDANCES_KARAKAS_2012)
#define NUCSYN_MASS_OF_PMZ_VAR &(stardata->preferences->pmz_mass)
#else
#define NUCSYN_MASS_OF_PMZ_VAR NULL
#endif

#if (defined NUCSYN) && (defined NUCSYN_GCE_OUTFLOW_CHECKS)
#define NUCSYN_ESCAPE_VELOCITY_VAR &(stardata->preferences->escape_velocity)
#define NUCSYN_ESCAPE_FRACTION_VAR &(stardata->preferences->escape_fraction)
#else
#define NUCSYN_ESCAPE_VELOCITY_VAR NULL
#define NUCSYN_ESCAPE_FRACTION_VAR NULL
#endif 

#if defined(NUCSYN) && defined(NUCSYN_CEMP_LOGGING)
#define NUCSYN_CEMP_LOGG_MAXIMUM_VAR &(stardata->preferences->CEMP_logg_maximum)
#define NUCSYN_CEMP_CFE_MINIMUM_VAR &(stardata->preferences->CEMP_cfe_minimum)
#define NUCSYN_CEMP_MINIMUM_AGE_VAR &(stardata->preferences->CEMP_minimum_age)
#else
#define NUCSYN_CEMP_LOGG_MAXIMUM_VAR NULL
#define NUCSYN_CEMP_CFE_MINIMUM_VAR NULL
#define NUCSYN_CEMP_MINIMUM_AGE_VAR NULL
#endif

#if defined(NUCSYN) && defined(CN_THICK_DISC)
#define THICK_DISC_START_AGE &(stardata->preferences->thick_disc_start_age)
#define THICK_DISC_END_AGE &(stardata->preferences->thick_disc_end_age)
#define THICK_DISC_LOGG_MIN &(stardata->preferences->thick_disc_logg_min)
#define THICK_DISC_LOGG_MAX &(stardata->preferences->thick_disc_logg_max)
#else
#define THICK_DISC_START_AGE NULL
#define THICK_DISC_END_AGE NULL
#define THICK_DISC_LOGG_MIN NULL
#define THICK_DISC_LOGG_MAX NULL
#endif

#ifdef EVOLUTION_SPLITTING
#define EVOLUTION_SPLITTING_VAR &(stardata->preferences->evolution_splitting)
#define EVOLUTION_SPLITTING_MAXDEPTH_VAR &(stardata->preferences->evolution_splitting_maxdepth)
#define EVOLUTION_SPLITTING_SN_N_VAR &(stardata->preferences->evolution_splitting_sn_n)
#else
#define EVOLUTION_SPLITTING_VAR NULL
#define EVOLUTION_SPLITTING_SN_N_VAR NULL
#define EVOLUTION_SPLITTING_MAXDEPTH_VAR NULL
#endif

#ifdef DISCS
#ifdef DISC_LOG
#define DISC_LOG_VAR &(stardata->preferences->disc_log)
#define DISC_LOG2D_VAR &(stardata->preferences->disc_log2d)
#define DISC_LOG_DT_VAR &(stardata->preferences->disc_log_dt)
#else
#define DISC_LOG_VAR NULL
#define DISC_LOG2D_VAR NULL
#define DISC_LOG_DT_VAR NULL
#endif//DISC_LOG

#if defined DISC_LOG || defined DISC_LOG_2D
#define DISC_LOG_DIRECTORY_VAR &(stardata->preferences->disc_log_directory)
#else
#define DISC_LOG_DIRECTORY_VAR NULL
#endif

#define DISC_TIMESTEP_FACTOR_VAR &(stardata->preferences->disc_timestep_factor)
#define DISC_N_MONTE_CARLO_GUESSES_VAR &(stardata->preferences->disc_n_monte_carlo_guesses)
#define CBDISC_GAMMA_VAR &(stardata->preferences->cbdisc_gamma)
#define CBDISC_MAX_LIFETIME_VAR &(stardata->preferences->cbdisc_max_lifetime)
#define CBDISC_ALPHA_VAR &(stardata->preferences->cbdisc_alpha)
#define CBDISC_KAPPA_VAR &(stardata->preferences->cbdisc_kappa)
#define CBDISC_TORQUEF_VAR &(stardata->preferences->cbdisc_torqueF)
#define CBDISC_START_DM_VAR &(stardata->preferences->cbdisc_init_dM)
#define CBDISC_START_DJDM_VAR &(stardata->preferences->cbdisc_init_dJdM)
#define CBDISC_OUTER_EDGE_STRIPPING_VAR &(stardata->preferences->cbdisc_outer_edge_stripping)
#define CBDISC_INNER_EDGE_STRIPPING_VAR &(stardata->preferences->cbdisc_inner_edge_stripping)
#define CBDISC_OUTER_EDGE_TIMESCALE_VAR &(stardata->preferences->cbdisc_outer_edge_stripping_timescale)
#define CBDISC_INNER_EDGE_TIMESCALE_VAR &(stardata->preferences->cbdisc_inner_edge_stripping_timescale)

#define CBDISC_MASS_LOSS_RATE_VAR &(stardata->preferences->cbdisc_mass_loss_constant_rate)
#define CBDISC_MASS_LOSS_INNER_VISCOUS_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_inner_viscous_multiplier)
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ANGULAR_MOMENTUM_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_inner_viscous_angular_momentum_multiplier)
#define CBDISC_MASS_LOSS_INNER_L2_CROSS_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_inner_L2_cross_multiplier)
#define CBDISC_MASS_LOSS_ISM_RAM_PRESSURE_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_ISM_ram_pressure_multiplier)
#define CBDISC_MASS_LOSS_ISM_PRESSURE_VAR &(stardata->preferences->cbdisc_mass_loss_ISM_pressure)
#define CBDISC_MINIMUM_LUMINOSITY_VAR &(stardata->preferences->cbdisc_minimum_luminosity)
#define CBDISC_MINIMUM_MASS_VAR &(stardata->preferences->cbdisc_minimum_mass)
#define CBDISC_MINIMUM_FRING_VAR &(stardata->preferences->cbdisc_minimum_fRing)
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_VAR &(stardata->preferences->cbdisc_mass_loss_inner_viscous_accretion_method)
#define CBDISC_RESONANCE_MULTIPLIER_VAR &(stardata->preferences->cbdisc_resonance_multiplier)
#define CBDISC_RESONANCE_DAMPING_VAR &(stardata->preferences->cbdisc_resonance_damping)
#define CBDISC_FAIL_RING_INSIDE_SEPARATION &(stardata->preferences->cbdisc_fail_ring_inside_separation)
#define CBDISC_MASS_LOSS_FUV_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_FUV_multiplier)
#define CBDISC_MASS_LOSS_XRAY_MULTIPLIER_VAR &(stardata->preferences->cbdisc_mass_loss_Xray_multiplier)
#define CBDISC_VISCOUS_PHOTOEVAPORATION_COUPLING_VAR &(stardata->preferences->cbdisc_viscous_photoevaporation_coupling)
#define CBDISC_VISCOUS_L2_COUPLING_VAR &(stardata->preferences->cbdisc_viscous_L2_coupling)

#ifdef DISCS_CIRCUMBINARY_FROM_COMENV
#define COMENV_DISC_ANGMOM_FRACTION_VAR &(stardata->preferences->comenv_disc_angmom_fraction)
#define COMENV_DISC_MASS_FRACTION_VAR &(stardata->preferences->comenv_disc_mass_fraction)
#else
#define COMENV_DISC_ANGMOM_FRACTION_VAR NULL
#define COMENV_DISC_MASS_FRACTION_VAR NULL
#endif // DISCS_CIRCUMBINARY_FROM_COMENV

#ifdef DISCS_CIRCUMBINARY_FROM_WIND
#define WIND_DISC_ANGMOM_FRACTION_VAR &(stardata->preferences->wind_disc_angmom_fraction)
#define WIND_DISC_MASS_FRACTION_VAR &(stardata->preferences->wind_disc_mass_fraction)
#else
#define WIND_DISC_ANGMOM_FRACTION_VAR NULL
#define WIND_DISC_MASS_FRACTION_VAR NULL
#endif // DISCS_CIRCUMBINARY_FROM_WIND

#define CBDISC_MINIMUM_EVAPORATION_TIMESCALE_VAR &(stardata->preferences->cbdisc_minimum_evaporation_timescale)
    
#else // DISCS
#define DISC_LOG_VAR NULL
#define DISC_LOG_DT_VAR NULL
#define DISC_TIMESTEP_FACTOR_VAR NULL
#define DISC_N_MONTE_CARLO_GUESSES_VAR NULL
#define CBDISC_GAMMA_VAR NULL
#define CBDISC_MAX_LIFETIME_VAR NULL
#define CBDISC_ALPHA_VAR NULL
#define CBDISC_KAPPA_VAR NULL
#define CBDISC_TORQUEF_VAR NULL
#define CBDISC_START_DM_VAR NULL
#define CBDISC_START_DJDM_VAR NULL
#define CBDISC_MASS_LOSS_RATE_VAR NULL
#define CBDISC_MASS_LOSS_INNER_VISCOUS_MULTIPLIER_VAR NULL
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ANGULAR_MOMENTUM_MULTIPLIER_VAR NULL
#define CBDISC_MASS_LOSS_INNER_L2_CROSS_MULTIPLIER_VAR NULL
#define CBDISC_MASS_LOSS_ISM_RAM_PRESSURE_MULTIPLIER_VAR NULL
#define CBDISC_MASS_LOSS_ISM_PRESSURE_VAR NULL
#define CBDISC_MASS_LOSS_FUV_MULTIPLIER_VAR NULL
#define CBDISC_MASS_LOSS_XRAY_MULTIPLIER_VAR NULL
#define CBDISC_MINIMUM_LUMINOSITY_VAR NULL
#define CBDISC_MINIMUM_MASS_VAR NULL
#define CBDISC_MINIMUM_FRING_VAR NULL
#define COMENV_DISC_ANGMOM_FRACTION_VAR NULL
#define COMENV_DISC_MASS_FRACTION_VAR NULL
#define WIND_DISC_ANGMOM_FRACTION_VAR NULL
#define WIND_DISC_MASS_FRACTION_VAR NULL
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_VAR NULL
#define CBDISC_RESONANCE_MULTIPLIER_VAR NULL
#define CBDISC_RESONANCE_DAMPING_VAR NULL
#define CBDISC_VISCOUS_PHOTOEVAPORATION_COUPLING_VAR NULL
#define CBDISC_VISCOUS_L2_COUPLING_VAR NULL
#define CBDISC_FAIL_RING_INSIDE_SEPARATION NULL
#define CBDISC_OUTER_EDGE_STRIPPING_VAR NULL
#define CBDISC_INNER_EDGE_STRIPPING_VAR NULL
#define CBDISC_OUTER_EDGE_TIMESCALE_VAR NULL
#define CBDISC_INNER_EDGE_TIMESCALE_VAR NULL
#define CBDISC_MINIMUM_EVAPORATION_TIMESCALE_VAR NULL
#define DISC_LOG_VAR NULL
#define DISC_LOG2D_VAR NULL
#define DISC_LOG_DT_VAR NULL
#define DISC_LOG_DIRECTORY_VAR NULL

#endif // DISCS


#ifdef CBDISC_ECCENTRICITY_PUMPING
#define CBDISC_ECCENTRICITY_PUMPING_METHOD_VAR &(stardata->preferences->cbdisc_eccentricity_pumping_method)
#else
#define CBDISC_ECCENTRICITY_PUMPING_METHOD_VAR NULL
#endif

#ifdef COMENV_POLYTROPES
#define COMENV_SPLITMASS_VAR &(stardata->preferences->comenv_splitmass)
#else
#define COMENV_SPLITMASS_VAR NULL
#endif

#ifdef EQUATION_OF_STATE_ALGORITHMS
#define EQUATION_OF_STATE_VAR &(stardata->preferences->equation_of_state_algorithm)
#else
#define EQUATION_OF_STATE_VAR NULL
#endif

#ifdef OPACITY_ALGORITHMS
#define OPACITY_VAR &(stardata->preferences->opacity_algorithm)
#else
#define OPACITY_VAR NULL
#endif

#ifdef NUCSYN_ANGELOU_LITHIUM

#define ANGELOU_LITHIUM_DECAY_FUNCTION_VAR &(stardata->preferences->angelou_lithium_decay_function)
#define ANGELOU_LITHIUM_VROT_TRIGGER_VAR &(stardata->preferences->angelou_lithium_vrot_trigger)
#define ANGELOU_LITHIUM_VROTFRAC_TRIGGER_VAR &(stardata->preferences->angelou_lithium_vrotfrac_trigger)

#define ANGELOU_LITHIUM_MS_TIME_VAR &(stardata->preferences->angelou_lithium_MS_time)
#define ANGELOU_LITHIUM_LMMS_TIME_VAR &(stardata->preferences->angelou_lithium_LMMS_time)
#define ANGELOU_LITHIUM_HG_TIME_VAR &(stardata->preferences->angelou_lithium_HG_time)
#define ANGELOU_LITHIUM_GB_TIME_VAR &(stardata->preferences->angelou_lithium_GB_time)
#define ANGELOU_LITHIUM_CHeB_TIME_VAR &(stardata->preferences->angelou_lithium_CHeB_time)
#define ANGELOU_LITHIUM_EAGB_TIME_VAR &(stardata->preferences->angelou_lithium_EAGB_time)
#define ANGELOU_LITHIUM_TPAGB_TIME_VAR &(stardata->preferences->angelou_lithium_TPAGB_time)

#define ANGELOU_LITHIUM_MS_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_MS_decay_time)
#define ANGELOU_LITHIUM_LMMS_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_LMMS_decay_time)
#define ANGELOU_LITHIUM_HG_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_HG_decay_time)
#define ANGELOU_LITHIUM_GB_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_GB_decay_time)
#define ANGELOU_LITHIUM_CHeB_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_CHeB_decay_time)
#define ANGELOU_LITHIUM_EAGB_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_EAGB_decay_time)
#define ANGELOU_LITHIUM_TPAGB_DECAY_TIME_VAR &(stardata->preferences->angelou_lithium_TPAGB_decay_time)
    
#define ANGELOU_LITHIUM_MS_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_MS_massfrac)
#define ANGELOU_LITHIUM_LMMS_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_LMMS_massfrac)
#define ANGELOU_LITHIUM_HG_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_HG_massfrac)
#define ANGELOU_LITHIUM_GB_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_GB_massfrac)
#define ANGELOU_LITHIUM_CHeB_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_CHeB_massfrac)
#define ANGELOU_LITHIUM_EAGB_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_EAGB_massfrac)
#define ANGELOU_LITHIUM_TPAGB_MASSFRAC_VAR &(stardata->preferences->angelou_lithium_TPAGB_massfrac)

#else
#define ANGELOU_LITHIUM_DECAY_FUNCTION_VAR NULL
#define ANGELOU_LITHIUM_LMMS_TIME_VAR NULL
#define ANGELOU_LITHIUM_MS_TIME_VAR NULL
#define ANGELOU_LITHIUM_HG_TIME_VAR NULL
#define ANGELOU_LITHIUM_GB_TIME_VAR NULL
#define ANGELOU_LITHIUM_CHeB_TIME_VAR NULL
#define ANGELOU_LITHIUM_EAGB_TIME_VAR NULL
#define ANGELOU_LITHIUM_TPAGB_TIME_VAR NULL
#define ANGELOU_LITHIUM_MS_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_LMMS_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_HG_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_GB_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_CHeB_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_EAGB_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_TPAGB_MASSFRAC_VAR NULL
#define ANGELOU_LITHIUM_LMMS_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_MS_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_HG_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_GB_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_CHeB_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_EAGB_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_TPAGB_DECAY_TIME_VAR NULL
#define ANGELOU_LITHIUM_VROT_TRIGGER_VAR NULL
#define ANGELOU_LITHIUM_VROTFRAC_TRIGGER_VAR NULL

#endif // NUCSYN_ANGELOU_LITHIUM


#ifdef REVERSE_TIME
#define REVERSE_TIME_VAR &(stardata->preferences->reverse_time)
#else
#define REVERSE_TIME_VAR NULL
#endif

#ifdef CIRCUMBINARY_DISK_DERMINE
#define ALPHACB_VAR &(stardata->preferences->alphaCB)
#else
#define ALPHACB_VAR NULL
#endif//CIRCUMBINARY_DISK_DERMINE

#ifdef GAIAHRD
#define GAIA_TEFF_BINWIDTH &stardata->preferences->gaia_Teff_binwidth
#define GAIA_L_BINWIDTH &stardata->preferences->gaia_L_binwidth
#else
#define GAIA_TEFF_BINWIDTH NULL
#define GAIA_L_BINWIDTH NULL
#endif//GAIAHRD


#endif// CMD_LINE_MACROS_H
