#pragma once
#ifndef CMD_LINE_MACRO_PAIRS_H
#define CMD_LINE_MACRO_PAIRS_H

/*
 * VALUES of arguments
 * 
 * Add a macro-value pair where the macro is MACRO
 * and the variable to be set is named by string VARNAME
 *
 * The straight loop through cmd_line_args2 is inefficient,
 * but this is done only once so it's hard to care enough to optimize.
 */
#define Add_value_macro_pair(VARNAME,MACRO)                             \
    {                                                                   \
        struct cmd_line_arg_t * const a =                               \
            match_a(VARNAME,                                            \
                    &__prevarg,                                         \
                    &__prevstring,                                      \
                    cmd_line_args2,                                     \
                    arg_count);                                         \
                                                                        \
        /* found a match : process */                                   \
        if(a != NULL)                                                   \
        {                                                               \
            a->npairs++;                                                \
            a->pairs =                                                  \
                Realloc(a->pairs,                                       \
                        sizeof(struct arg_pair_t)*                      \
                        a->npairs);                                     \
            struct arg_pair_t * const p = a->pairs + a->npairs - 1;     \
            p->string = #MACRO ;                                        \
            p->value = (MACRO);                                         \
            Cprint("p string %s, value %g\n",                           \
                   p->string,                                           \
                   p->value);                                           \
        }                                                               \
    }

/*
 * ARGUMENT macro pairs
 *
 *
 */
#define Add_argument_macro_pair(VARNAME,MACRO,PREFIX)                   \
    for(__i=0; __i<arg_count; __i++)                                    \
    {                                                                   \
        struct cmd_line_arg_t * a = &cmd_line_args2[__i];               \
        if(Strings_equal((VARNAME),a->name))                            \
        {                                                               \
            a->nargpairs++;                                             \
            a->argpairs = Realloc(a->argpairs,                          \
                                  sizeof(struct arg_pair_t)*            \
                                  a->nargpairs);                        \
            Cprint("matched arg %s %s : nargpairs upped to %u : argpairs = %p\n", \
                   (VARNAME),                                           \
                   a->name,                                             \
                   a->nargpairs,                                        \
                   a->argpairs);                                        \
            struct arg_pair_t * p = a->argpairs+a->nargpairs-1;         \
            size_t len = strlen(a->name);                               \
            Cprint("Target string %s :: len %zu :: a = %p\n",           \
                   a->name,                                             \
                   len,                                                 \
                   a);                                                  \
            char * format = Malloc(sizeof(char)*(len+1));               \
            strlcpy(format,a->name,len+1);                              \
            Cprint("format %s\n",format);                               \
            size_t __j;                                                 \
            for(__j=0; __j<len-1; __j++)                                \
            {                                                           \
                if(format[__j] == '%'&&                                 \
                   format[__j+1] == 'd')                                \
                {                                                       \
                    Cprint("found %%d at %zu\n",__j);                   \
                    format[__j+1] = 's';                                \
                    __j = len + 1;                                      \
                }                                                       \
            }                                                           \
            Cprint("hence new format \"%s\", len %zu\n",format,len);    \
            Cprint("Set string %s\n",(#MACRO));                         \
            len += sizeof(#MACRO);                                      \
            p->string = Malloc(len + 1);                                \
            size_t x = snprintf(p->string,                              \
                                len,                                    \
                                format,                                 \
                                (#MACRO)) ;                             \
            if(x<0)                                                     \
            {                                                           \
                Exit_binary_c(BINARY_C_SNPRINTF_FAILED,                 \
                              "snprintf failed in cmd_line_macros_pairs.h"); \
            }                                                           \
            p->value = (PREFIX##MACRO);                                 \
            Cprint("p string \"%s\", value %g, x = %zu\n",              \
                   p->string,                                           \
                   p->value,                                            \
                   x);                                                  \
            Safe_free(format);                                          \
        }                                                               \
    }


#endif // CMD_LINE_MACRO_PAIRS_H

