#pragma once
#ifndef CMD_LINE_FUNCTION_MACROS_H
#define CMD_LINE_FUNCTION_MACROS_H

/*
 * Function macros used in the command line
 * argument parsing code of binary_c
 */

#define Arg_set_double                                                  \
    {                                                                   \
        errno = 0;                                                      \
        Boolean __match = FALSE;                                        \
        const struct cmd_line_arg_t * const a = cmd_line_args + i;      \
        c++;                                                            \
        if(isdigit((unsigned char)argv[c][0]) ||                        \
           argv[c][0] == '.' ||                                         \
           argv[c][0] == '-' ||                                         \
           argv[c][0] == '+')                                           \
        {                                                               \
            /* numeric argument */                                      \
            const double test = strtod(argv[c],NULL);                   \
            const int errnum = errno;                                   \
            if(errno)                                                   \
            {                                                           \
                char errstring[100];                                    \
                char * x = strerror_r(errnum,errstring,100);            \
                Exit_binary_c(                                          \
                    BINARY_C_UNDER_OR_OVERFLOW,                         \
                    "Argument %d (string %s after %s) has caused a floating point %sflow (errno = %d which is %s %s)\n", \
                    c,                                                  \
                    argv[c],                                            \
                    argv[c-1],                                          \
                    ((test<0.0)?"under":"over"),                        \
                    errnum,                                             \
                    errstring,                                          \
                    x);                                                 \
            }                                                           \
            *((double*) a->pointer) = a->modulate * test;               \
            __match=TRUE;                                               \
        }                                                               \
        else                                                            \
        {                                                               \
            /* Macro argument */                                        \
            unsigned int __i;                                           \
            for(__i=0;__i<a->npairs;__i++)                              \
            {                                                           \
                const struct arg_pair_t * const p = a->pairs + __i;     \
                if(Strings_equal(p->string,argv[c]))                    \
                {                                                       \
                    Cprint("Matched double %s -> set %s to %g\n",       \
                           p->string,                                   \
                           a->name,                                     \
                           (double)p->value);                           \
                    *((double*)a->pointer) = (double)p->value;          \
                    __match = TRUE;                                     \
                }                                                       \
            }                                                           \
        }                                                               \
        if(__match == FALSE)                                            \
        {                                                               \
            Exit_binary_c(BINARY_C_WRONG_ARGUMENT,                      \
                          "Argument \"%s\" following %s is neither integer not matched an appropriate macro. Please check it!\n", \
                          argv[c],                                      \
                          argv[c-1]);                                   \
        }                                                               \
        Cprint("Set %s to %g\n",                                        \
               a->name,                                                 \
               *((double*) a->pointer));                                \
    }

#define Arg_test_int_under_or_overflow                                  \
    if(test==LONG_MIN || test==LONG_MAX)                                \
    {                                                                   \
        Exit_binary_c(                                                  \
            BINARY_C_UNDER_OR_OVERFLOW,                                 \
            "Argument %d (string %s after %s) has caused a (long) integer %sflow\n", \
            c,argv[c],argv[c-1],((test==LONG_MIN)?"under":"over"));     \
    }


/*
 * Set an integer of type __TYPE
 * which could be int, long int, unsigned int etc. 
 */
#define Arg_set_int_of_type(__TYPE)                                     \
    {                                                                   \
        errno = 0;                                                      \
        c++;                                                            \
        Boolean __match = FALSE;                                        \
        const struct cmd_line_arg_t * const a = cmd_line_args + i;      \
        if(isdigit((unsigned char)argv[c][0]))                          \
        {                                                               \
            const long int test = strtol(argv[c],NULL,10);              \
            Arg_test_int_under_or_overflow;                             \
            *((__TYPE*)a->pointer) = (__TYPE)test;                      \
            __match = TRUE;                                             \
        }                                                               \
        else if(Arg_is_true(argv[c]))                                   \
        {                                                               \
            *((__TYPE*)a->pointer) = TRUE;                              \
            __match = TRUE;                                             \
        }                                                               \
        else if(Arg_is_false(argv[c]))                                  \
        {                                                               \
            *((__TYPE*)a->pointer) = FALSE;                             \
            __match = TRUE;                                             \
        }                                                               \
        else                                                            \
        {                                                               \
            /* Macro argument */                                        \
            unsigned int __i;                                           \
            for(__i=0;__i<a->npairs;__i++)                              \
            {                                                           \
                const struct arg_pair_t * const p = a->pairs + __i;     \
                if(Strings_equal(p->string,argv[c]))                    \
                {                                                       \
                    Cprint("Matched %s -> set %s to %ld\n",             \
                           p->string,                                   \
                           a->name,                                     \
                           (long int)((__TYPE) p->value));              \
                    *((__TYPE*)a->pointer) = (__TYPE)p->value;          \
                    __match = TRUE;                                     \
                }                                                       \
            }                                                           \
        }                                                               \
        if(__match == FALSE)                                            \
        {                                                               \
            Exit_binary_c(BINARY_C_WRONG_ARGUMENT,                      \
                          "Argument \"%s\" following %s is neither integer not matched an appropriate macro. Please check it!\n", \
                          argv[c],                                      \
                          argv[c-1]);                                   \
        }                                                               \
        Cprint("Set %s to %ld\n",                                       \
               a->name,                                                 \
               (long int)*((__TYPE*) a->pointer));                      \
    }

/*
 * Hence macros for setting int, unsigned int, long int
 */
#define Arg_set_int Arg_set_int_of_type(int)
#define Arg_set_unsigned_int Arg_set_int_of_type(unsigned int)
#define Arg_set_long_int Arg_set_int_of_type(long int)


/*
 * Match a format statement containing a single %d to represent 
 * an integer. 
 */
#define Arg_scanf_set_int                                       \
    {                                                           \
        errno = 0;                                              \
        const long int test = strtol(argv[++c],NULL,10);        \
        Arg_test_int_under_or_overflow;                         \
        *((int*)cmd_line_args[i].pointer + offset) =            \
            (int)test;                                          \
        Cprint("Set %s to %d\n",                                \
               cmd_line_args[i].name,                           \
               *((int*) cmd_line_args[i].pointer + offset));    \
    }

/*
 * Match a format statement containing a single %d to represent 
 * an integer, and put it in a Boolean. Note that if the argument
 * fails to match a boolean type, we set it to FALSE. 
 */
#define Arg_scanf_set_Boolean                                           \
    {                                                                   \
        errno = 0;                                                      \
        c++;                                                            \
        const Boolean test = Arg_is_true(argv[c]) ? TRUE : FALSE;       \
        *((Boolean*)cmd_line_args[i].pointer + offset) =                \
            test;                                                       \
        Cprint("Set %s to %s\n",                                        \
               cmd_line_args[i].name,                                   \
               Truefalse(*((Boolean*) cmd_line_args[i].pointer +        \
                           offset)));                                   \
    }

/*
 * Match a format statement containing a single %d to represent 
 * an integer. 
 */
#define Arg_scanf_set_double                                            \
    {                                                                   \
        errno = 0;                                                      \
        const double test = strtod(argv[++c],NULL);                     \
        int errnum = errno;                                             \
        if(errno)                                                       \
        {                                                               \
            char errstring[100];                                        \
            char * x = strerror_r(errnum,errstring,100);                \
            Exit_binary_c(                                              \
                BINARY_C_UNDER_OR_OVERFLOW,                             \
                "Argument %d (string %s after %s) has caused a floating point %sflow (errno = %d which is %s %s)\n", \
                c,                                                      \
                argv[c],                                                \
                argv[c-1],                                              \
                ((test<0.0)?"under":"over"),                            \
                errnum,                                                 \
                errstring,                                              \
                x);                                                     \
        }                                                               \
        *((double*)cmd_line_args[i].pointer + offset) =                 \
            (double)test;                                               \
        Cprint("Set %s to %g\n",                                        \
               cmd_line_args[i].name,                                   \
               *((double*) cmd_line_args[i].pointer + offset));         \
    }


/*
 * Boolean tests
 */
#define Arg_is_true(X) String_is_true(X)
#define Arg_is_false(X) String_is_false(X)
#define Arg_is_boolean(X) String_is_boolean(X)

/*
 * generic boolean setter. X is the default, either TRUE or FALSE.
 * Only sets the boolean if the next argument matches Arg_is_boolean above.
 */
#define Arg_set_boolean(X)                                              \
    {                                                                   \
        Boolean test = (X);                                             \
        Cprint("c+1 = %d < argc = %d : \"%s\" is boolean ? %s\n",       \
               c+1,                                                     \
               argc,                                                    \
               argv[c+1],                                               \
               Yesno(Arg_is_boolean(argv[c+1])));                       \
        if(c+1<argc && Arg_is_boolean(argv[c+1]))                       \
        {                                                               \
            c++;                                                        \
            test =                                                      \
                Arg_is_true(argv[c]) ? TRUE :                           \
                Arg_is_false(argv[c]) ? FALSE :                         \
                (Boolean)Long_int_to_boolean(strtol(argv[++c],          \
                                                    NULL,               \
                                                    10));               \
            Cprint("test %d (c=%d vs argc=%d arg is %s)\n",             \
                   test,c,argc,argv[c]);                                \
        }                                                               \
        *((Boolean*)cmd_line_args[i].pointer) = test;                   \
        Cprint("Set %s to %s\n",                                        \
               cmd_line_args[i].name,                                   \
               Truefalse(*((Boolean*)cmd_line_args[i].pointer))         \
            );                                                          \
    }

/* hence some that default to TRUE and FALSE */
#define Arg_set_boolean_true                    \
    Arg_set_boolean(TRUE)

#define Arg_set_boolean_false                   \
    Arg_set_boolean(FALSE)

#define Arg_set_string                                          \
    {                                                           \
        strlcpy(cmd_line_args[i].pointer,                       \
                argv[++c],                                      \
                (size_t)STRING_LENGTH);                         \
        Cprint("Set \"%s\" from \"%s\" to \"%s\" or \"%s\"\n",  \
               (char*)cmd_line_args[i].name,                    \
               (char*)argv[c],                                  \
               (char*)cmd_line_args[i].pointer,                 \
               stardata->preferences->Seitenzahl2013_model);    \
    }

#define Arg_call_subroutine                             \
    {                                                   \
        void (*func)(ARG_SUBROUTINE_DECLARATION);       \
        func = cmd_line_args[i].pointer;                \
        func(ARG_SUBROUTINE_ARGS);                      \
        break;                                          \
    }

#define Arg_value_subroutine(VALUE,TYPE)                \
    {                                                   \
        TYPE (*func)(ARG_SUBROUTINE_DECLARATION);       \
        func = cmd_line_args[i].pointer;                \
        (VALUE) = func(ARG_SUBROUTINE_ARGS2);           \
    }

#define Arg_is_batch(TYPE)                      \
    (                                           \
        (TYPE)==BATCH_ARG_SUBROUTINE ||         \
        (TYPE)==BATCH_ARG_BOOLEAN               \
        )

#define Arg_is_variable(TYPE)                   \
    (                                           \
        (TYPE) == ARG_FLOAT ||                  \
        (TYPE) == ARG_INTEGER ||                \
        (TYPE) == ARG_UNSIGNED_INTEGER ||       \
        (TYPE) == ARG_LONG_INTEGER ||           \
        (TYPE) == ARG_STRING ||                 \
        (TYPE) == ARG_BOOLEAN ||                \
        (TYPE) == ARG_NOT_BOOLEAN               \
        )

#define Arg_is_subroutine(TYPE)                 \
    (                                           \
        (TYPE) == BATCH_ARG_SUBROUTINE ||       \
        (TYPE) == ARG_SUBROUTINE ||             \
        (TYPE) == ARG_SUBROUTINE_RETURN_INT ||  \
        (TYPE) == ARG_SUBROUTINE_RETURN_FLOAT   \
        )

#define Arg_is_function_pointer(TYPE)           \
    (                                           \
        (TYPE) == ARG_SUBROUTINE ||             \
        (TYPE) == ARG_SUBROUTINE_RETURN_INT ||  \
        (TYPE) == ARGV_SUBROUTINE_RETURN_FLOAT  \
        )

#define Arg_is_scanf(TYPE)                      \
    (                                           \
        (TYPE) == ARG_INTEGER_SCANF ||          \
        (TYPE) == ARG_BOOLEAN_SCANF ||          \
        (TYPE) == ARG_FLOAT_SCANF               \
        )

#define Argtypestring(TYPE)                                     \
    (                                                           \
        (TYPE)==ARG_FLOAT ? "Float" :                           \
        (TYPE)==ARG_STRING ? "String" :                         \
        (TYPE)==ARG_NONE ? "" :                                 \
        (TYPE)==ARG_INTEGER ? "Integer" :                       \
        (TYPE)==ARG_SUBROUTINE ? "*" :                          \
        (TYPE)==ARG_SUBROUTINE_RETURN_FLOAT ? "Float" :         \
        (TYPE)==ARG_SUBROUTINE_RETURN_INT ? "Int" :             \
        (TYPE)==ARG_BOOLEAN ? "True|False" :                    \
        (TYPE)==ARG_LONG_INTEGER ? "Integer" :                  \
        (TYPE)==ARG_NOT_BOOLEAN ? "" :                          \
        (TYPE)==BATCH_ARG_SUBROUTINE ? "*" :                    \
        (TYPE)==BATCH_ARG_BOOLEAN ? "True|False" :              \
        (TYPE)==ARG_INTEGER_SCANF ? "Int(scanf)" :              \
        (TYPE)==ARG_BOOLEAN_SCANF ? "Boolean(scanf)" :          \
        (TYPE)==ARG_FLOAT_SCANF ? "Float(scanf)" :              \
        (TYPE)==ARG_UNSIGNED_INTEGER ? "Unsigned integer" :     \
        "*"                                                     \
        )

#define Arg_format(TYPE)                        \
    (                                           \
        (TYPE)==ARG_FLOAT ? "%g" :              \
        (TYPE)==ARG_STRING ? "%s" :             \
        (TYPE)==ARG_INTEGER ? "%d" :            \
        (TYPE)==ARG_BOOLEAN ? "%s" :            \
        (TYPE)==ARG_LONG_INTEGER ? "%ld" :      \
        (TYPE)==ARG_NOT_BOOLEAN ? "%s" :        \
        (TYPE)==BATCH_ARG_BOOLEAN ? "%s" :      \
        (TYPE)==ARG_UNSIGNED_INTEGER ? "%u" :   \
        NULL                                    \
        )


#endif // CMD_LINE_FUNCTION_MACROS_H
