#include "../binary_c.h"
#include "cmd_line_function_macros.h"
/*
 * Functions to set non-standard arguments
 */
static char * arg_variable_default_string(
    const struct cmd_line_arg_t * RESTRICT const arg);


void binary_c_warmup_cpu(ARG_SUBROUTINE_DECLARATION)
{
    (*c)++;
    const int secs = Long_int_to_int(strtol(argv[*c],NULL,10));
    if(secs!=0)warmup_cpu(stardata,secs);
}



void No_return binary_c_speedtests(ARG_SUBROUTINE_DECLARATION)
{
    /*
     * Perform speed tests for binary_c
     */

    Printf("binary_c speed performance tests\n");
    
    ticks tick0,tick1;
    long int ntests;
    int j;
#define Start_test tick0=getticks(); for(j=0;j<ntests;j++)
#define TIME_TAKEN Timer_seconds(tick1-tick0)
#define End_test(...) tick1=getticks(); Printf(__VA_ARGS__);fflush(stdout);

    fflush(stdout);fflush(stderr);

    /************************************************************/
    
    ntests=5000000;
  
    Start_test
    {
	for(i=0;i<ntests;i++)
	{
            double x=(double)rand();
            x*=1.0;
        }
    }
    End_test("Multiply by FLOAT_TYPE rand : %g s\n",TIME_TAKEN);

    Exit_binary_c(BINARY_C_NORMAL_EXIT,"Done speed performance tests.");
}



static char * arg_variable_default_string(
    const struct cmd_line_arg_t * RESTRICT const a)
{
    /*
     * Return a string of the default value.
     *
     * Returns "subroutine" for ARG_SUBROUTINE* types.
     */
    char * c = NULL;
    if(a->pointer != NULL)
    {
        if(Arg_is_subroutine(a->type))
        {
            if(asprintf(&c,
                        "%s",
                        "Subroutine")<=0)
            {
                c = NULL;
            }
        }
        else if(a->type == ARG_INTEGER)
        {
            if(asprintf(&c,
                        "%d",
                        *((int*)a->pointer))<=0)
            {
                c = NULL;
            }
        }
        else if(a->type == ARG_UNSIGNED_INTEGER)
        {
            if(asprintf(&c,
                        "%u",
                        *((unsigned int*)a->pointer))<=0)
            {
                c = NULL;
            }
        }
        else if(a->type == ARG_LONG_INTEGER)
        {
            if(asprintf(&c,
                        "%ld",
                        *((long int*)a->pointer))<=0)
            {
                c = NULL;
            }
        }        
        else if(a->type == ARG_FLOAT)
        {
            if(asprintf(&c,
                        "%g",
                        *((double*)a->pointer))<=0)
            {
                c = NULL;
            }
        }
        else if(a->type == ARG_BOOLEAN ||
                a->type == ARG_NOT_BOOLEAN)
        {
            if(asprintf(&c,
                        "%s",
                        Truefalse(*((Boolean*)a->pointer)))<=0)
            {
                c = NULL;
            }
        }
        else if(a->type == ARG_STRING)
        {
            if(asprintf(&c,
                        "%s",
                        ((char*)a->pointer))<=0)
            {
                c = NULL;
            }
        }
        else
        {
            c = NULL;
        }
    }

    /*
     * NULL pointer should give string "NULL"
     */
    if(c == NULL)
    {
        if(asprintf(&c,"NULL") <=0)
        {
            c = NULL;
        }
    }
        
    return c;
}

void binary_c_help_from_arg(ARG_SUBROUTINE_DECLARATION)
{
    /*
     * Output help: either a general help statement (binary_c --help),
     * or per-argument help (binary_c --help <arg1> <arg2> ...)
     */
    Boolean __exit = argc >= 0 ? TRUE : FALSE;
    if(argc < 0) argc = -argc;
    
    if(*c==argc-1)
    {
	/* no extra help required */
	Printf("Usage: binary_c <cmd line args>\n\nwhere the arguments are a selection of : \n\n");
	for(i=0;i<arg_count;i++) 
        {
            if(cmd_line_args[i].type != BATCH_ARG_SUBROUTINE &&
               cmd_line_args[i].type != BATCH_ARG_BOOLEAN &&
               cmd_line_args[i].type != BATCH_ARG_NOT_BOOLEAN)
                Printf("%s ",cmd_line_args[i].name);
	}
        Printf("\n\nTry running\n\nbinary_c help <argname>\n\nfor more help on a particular argument.\n\n");
        
	Exit_binary_c(BINARY_C_QUIET_EXIT,"No command line args given.");
    }
    else
    {
	char *next = NULL;
        int head=0;
        (*c)++;
        while(*c<argc)
	{
	    next = argv[*c];
     
            Boolean success = FALSE;
	    for(i=0;i<arg_count;i++)
	    {
                struct cmd_line_arg_t * a = &cmd_line_args[i];
                if(Strings_equal(next,a->name))
		{
                    /*
                     * Found matching help exactly
                     */
                    char * default_string = arg_variable_default_string(a);
                    Printf("binary_c help for variable : %s <%s>\n\n%s\n\nDefault : %s\n",
                           next,
                           Argtypestring(a->type),
                           a->help,
                           default_string
                        );
                    Safe_free(default_string);
                    if(a->npairs > 0)
                    {
                        unsigned int j;
                        printf("Available macros:\n\n");
                        for(j=0;j<a->npairs;j++)
                        {
                            Printf("%s = %g\n",
                                   a->pairs[j].string,
                                   a->pairs[j].value
                                );
                        }
                    }
                    Printf("\n\n\n");
                    success=TRUE;
		}
	    
                if(success==FALSE)
                {
                    /*
                     * Search for substrings
                     */
                    if(strstr(cmd_line_args[i].name,next) != NULL)
                    {
                        if(head==0)
                        {
                            Printf("Did you mean :\n\n");
                            head=1;
                        }
                        Printf("  %s\n",cmd_line_args[i].name);
                    }
                }
            }
	

 	    if(success==FALSE) Printf("\nBinary_c help : no help available for %s\n",next);
	    (*c)++;
	}
	
	if(__exit)
        {
            Exit_binary_c(BINARY_C_NORMAL_EXIT,"Exit after help\n");
        }
        else
        {
            return;
        }
    }
}


void No_return binary_c_help_all(ARG_SUBROUTINE_DECLARATION)
{
    /* show help for all arguments */
    static const char *cc[] = ARG_SECTION_STRINGS;
    int j;
    for(j=0;j<NUMBER_OF_ARG_SECTIONS;j++)
    {
	Printf("\n############################################################\n##### Section %s\n############################################################\n",cc[j]);
	for(i=0;i<arg_count;i++)
	{
	    if(cmd_line_args[i].section == j)
	    {
		Printf("%s : %s : %s\n",
		       cmd_line_args[i].name,
		       cmd_line_args[i].help,
		       cmd_line_args[i].wtts_string);
	    }
	}
    }
    Exit_binary_c(BINARY_C_NORMAL_EXIT,NULL);
}

#ifdef BATCHMODE

void toggle_batchmode(ARG_SUBROUTINE_DECLARATION)
{
    /* toggle batchmode Boolean */
    stardata->preferences->batchmode = 
	stardata->preferences->batchmode == TRUE ? FALSE : TRUE;
}
#endif //BATCHMODE


void reset_stars_defaults(ARG_SUBROUTINE_DECLARATION)
{
    // reset_stars combined with defaults
    Star_number k;
    Starloop(k)
    {
        SETstar(k);
        init_star(stardata,star);
        star->starnum = k;
    }
    init_model(&(stardata->model));
    init_common(stardata);

    // defaults
    default_stardata(stardata);
}

void No_return list_available_args_and_exit(ARG_SUBROUTINE_DECLARATION)
{
    list_available_args(ARG_SUBROUTINE_ARGS2);
    Exit_binary_c(BINARY_C_NORMAL_EXIT,"Exit after listing arguments");    
}

void list_available_args(ARG_SUBROUTINE_DECLARATION)
{
    /*
     * For binary_grid Perl module : list available args
     */
    Printf("__ARG_BEGIN\n");

    
    int buffering = stardata->preferences->internal_buffering;
    reset_stars_defaults(ARG_SUBROUTINE_ARGS2);
    stardata->preferences->internal_buffering = buffering;
        
    *c=-1;
    int xint;
    double xdouble;
    char * cc;
    for(i=0;i<arg_count;i++)
    {
        struct cmd_line_arg_t * a = &cmd_line_args[i]; 
        if(! Arg_is_batch(a->type))
        {
            Printf("%s = ",a->name);
            if(a->pointer == NULL)
            {
                Printf("NULL");
            }
            else
            {
                switch(a->type)
                {
                case ARG_NONE:
                    /* do nothing */
                    break;
                case ARG_FLOAT:
                case ARG_INTEGER:
                case ARG_UNSIGNED_INTEGER:
                case ARG_LONG_INTEGER:
                case ARG_STRING:
                case ARG_BOOLEAN:
                case ARG_NOT_BOOLEAN:
                    
                     cc = arg_variable_default_string(a);
                    Printf("%s",cc);
                    Safe_free(cc);
                    break;
                case ARG_SUBROUTINE_RETURN_FLOAT:
                    Arg_value_subroutine(xdouble,double);
                    Printf("%g",xdouble);
                    break;
                case ARG_SUBROUTINE_RETURN_INT:
                    Arg_value_subroutine(xint,int);
                    Printf("%d",xint);
                    break;
                case ARG_SUBROUTINE:
                    Printf("Function");
                    break;
                }
            }
            Printf("\n");
        }
    }

    Printf("__ARG_END\n");
}



void dummyfunc(ARG_SUBROUTINE_DECLARATION)
{
    /* function to do nothing */
}

void binary_c_version_internal(ARG_SUBROUTINE_DECLARATION)
{
    /* allocations are for the isotope list */
    version(stardata);
}

void version_only(ARG_SUBROUTINE_DECLARATION)
{
    version(NULL);
}

void No_return dumpversion(ARG_SUBROUTINE_DECLARATION)
{
    Printf("%s\n",BINARY_C_VERSION);
    Exit_binary_c(BINARY_C_QUIET_EXIT,NULL);
}


void set_init_abund_mult(ARG_SUBROUTINE_DECLARATION)
{
    (*c)++;
    Isotope n MAYBE_UNUSED = (Isotope)Long_int_to_unsigned_short_int(strtol(argv[*c],NULL,10));
    (*c)++;
#ifdef NUCSYN
    double f = strtod(argv[*c],NULL);
    if(n<ISOTOPE_ARRAY_SIZE) stardata->preferences->initial_abundance_multiplier[n]=f;
#endif
}

void set_init_abund_dex(ARG_SUBROUTINE_DECLARATION)
{
    (*c)++;
    Isotope n MAYBE_UNUSED = (Isotope)Long_int_to_unsigned_short_int(strtol(argv[*c],NULL,10));
    (*c)++;
#ifdef NUCSYN
    double f = strtod(argv[*c],NULL);
    f = pow(10.0,f);
    if(n<ISOTOPE_ARRAY_SIZE) stardata->preferences->initial_abundance_multiplier[n]=f;
    //fprintf(stderr,"SET MULT %d to %g\n",n,f);
#endif
}

void set_init_abund(ARG_SUBROUTINE_DECLARATION)
{
    (*c)++;
    Isotope n MAYBE_UNUSED = (Isotope)Long_int_to_unsigned_short_int(strtol(argv[*c],NULL,10));
    (*c)++;
#ifdef NUCSYN
    double X = strtod(argv[*c],NULL);
    if(n<ISOTOPE_ARRAY_SIZE) stardata->preferences->the_initial_abundances[n]=X;
#endif
}

void set_third_dup_multiplier(ARG_SUBROUTINE_DECLARATION)
{
    (*c)++;
    Isotope n MAYBE_UNUSED = (Isotope)Long_int_to_unsigned_short_int(strtol(argv[*c],NULL,10));
    (*c)++;
#if defined (NUCSYN) && defined(THIRD_DREDGE_UP) && defined(NUCSYN_THIRD_DREDGE_UP_MULTIPLIERS)
    double X = strtod(argv[*c],NULL);
    if(n<ISOTOPE_ARRAY_SIZE) stardata->preferences->third_dup_multiplier[n]=X;
    preferences->boost_third_dup=TRUE;
#endif
    
}
