#!/usr/bin/perl
use strict;
use List::MoreUtils qw/uniq/;
# script to install Perl modules
# from .tar.gz files.
#
# Assumes you have cpanminus (cpanm) installed.
#
# You can override the cpanm comment with the CPANM environment
# variable.
#
my $cpanm = $ENV{CPANM} // 'cpanm';

print "Install all required perl modules using cpanm (to default location)\n";

# make list of modules, in order
my @mods;

# hard wired fix for an old mistake
@mods = (`ls Hash-RobMerge*`);
chomp @mods;

# dependencies file
if(-f 'deps')
{
    open(my $deps,'<','deps') || 
        die("cannot open deps file even though it exists\n");
    while(my $l = <$deps>)
    {
        chomp $l;
        if($l=~m!.*\/(\S+)\.pm$/!)
        {
            my $short = $1; # short module name
            my $r = `ls $short*.tar.gz 2>\&1`;
            if($r =~ /^$short/)
            {
                chomp $r;
                push(@mods,$r);
            }
        }
        elsif($l=~/tar.gz$/)
        {
            push(@mods,$l) if(-f $l);
        }
    }
    close $deps;
}

push (@mods, `ls *.tar.gz`);
chomp @mods;
@mods = uniq @mods;

foreach my $tgz (@mods)
{
    my $d=($tgz=~/(.*)\.tar\.gz/)[0];
    
    print "Install $tgz using cpanm\n";
    print `$cpanm --installdeps ./$tgz;`;
    print `$cpanm --force --notest ./$tgz;`;
}
    
