#!/bin/bash

# make data objects for the opacity library of binary_c
# http://gareus.org/wiki/embedding_resources_in_executables

: ${CC:="gcc"}
: ${OBJCOPY_OPTS:="-I binary -B i386:x86-64 -O elf64-x86-64"}

# Ferguson/Opal opacity table as generated on 16/06/2017
# based on the data Adam Jermyn sent RGI, with nearest-neighbour
# interpolation where gaps appear 
HFILE=ferguson_opal_16062017.dat.bz2
TMPFILE=ferguson_opal_16062017.dat
OBJFILE=ferguson_opal_16062017.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    bzcat $HFILE | ./double2bin > $TMPFILE

    # The opacity table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE

# STARS code Z=0.02 opacity 
HFILE=STARS_Z0.02.dat.bz2
TMPFILE=STARS_Z0.02.dat
OBJFILE=STARS_Z0.02.dat.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    bzcat $HFILE | ./double2bin > $TMPFILE

    # The opacity table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE
