/* Useful function to calculate the total mass fraction from Xmin to Xmax */
#include "../binary_c.h"

#ifdef NUCSYN


double Pure_function Nonnull_some_arguments(1,2) nucsyn_totalX(struct stardata_t * const stardata,
                                                 const Abundance * const RESTRICT X,
                                                 const Isotope Xmin,
                                                 const Isotope Xmax)
{
    Abundance Xsum;
    Isotope i;
    if(Xmax==ISOTOPE_ARRAY_SIZE && Xmin==0)
    {
        Xsum = XXsum(stardata,X);
    }
    else
    {
        Xsum = 0.0;
        for(i=Xmin;i<Xmax;i++)
        {
            Xsum += X[i];
        }
    }
    return Xsum;
}

double Pure_function Nonnull_some_arguments(1,2) XXsum(const struct stardata_t * RESTRICT const stardata,
                                                       const Abundance * RESTRICT const X)
{

    Abundance Xsum = 0.0;
    Isotope i;
    Isotope_loop(i)
    {
        prefetch(X+i+Isotope_loop_sign);
        Xsum += X[i];
    }
    return Xsum;
}

#endif// NUCSYN
