#include "../binary_c.h"
#ifdef NUCSYN 
Yield_source Pure_function nucsyn_sn_source(struct star_t * RESTRICT const exploder)
{
    /*
     * Given a supernova type, return the nucsyn source ID
     */
    Yield_source src_id;
    switch(exploder->SN_type)
    {
    case SN_IA_He_Coal:
    case SN_IA_He:
        src_id = NUCSYN_SOURCE_SNIa_He;
        break;
    case SN_IA_ELD:
        src_id = NUCSYN_SOURCE_SNIa_ELD;
        break;
    case SN_IA_CHAND_Coal:
    case SN_IA_CHAND:
        src_id = NUCSYN_SOURCE_SNIa_CHAND;
        break;
    case SN_AIC:
        src_id = NUCSYN_SOURCE_SNAIC;
        break;
    case SN_GRB_COLLAPSAR:    
    case SN_IBC:
        src_id = NUCSYN_SOURCE_SNIbc;
        break;
    case SN_II:
        src_id = NUCSYN_SOURCE_SNII;
        break;
    default:
        src_id = -1;
        break;
    }
    return src_id;
}
#endif //NUCSYN
