#include "nucsyn.h"

/*
 * Electron capture SN yields
 */
#ifdef NUCSYN
#include "nucsyn_isotopes.h"

void nucsyn_sn_electron_capture(Abundance * RESTRICT const X)
{
    Clear_isotope_array(X);
#ifdef NUCSYN_SN_ELECTRON_CAPTURE_WANAJO_2008

    /*
     * Use yields of Wanajo et al 2008: either the ST model
     * or the FP3 model. ST should be the default.
     */

#ifdef NUCSYN_SN_ELECTRON_CAPTURE_WANAJO_2008_ST
#include "nucsyn_sn_electron_capture_wanajo_ST.h"
#endif //  NUCSYN_SN_ELECTRON_CAPTURE_WANAJO_2008_ST

#ifdef NUCSYN_SN_ELECTRON_CAPTURE_WANAJO_2008_FP3
#include "nucsyn_sn_electron_capture_wanajo_FP3.h"
#endif

#endif //  NUCSYN_SN_ELECTRON_CAPTURE_WANAJO_2008
}
 
#endif // NUCSYN
