#pragma once
#ifndef NUCSYN_SEITENZAHL2013_H
#define NUCSYN_SEITENZAHL2013_H

/*
 * Seitenzahl et al. 2013 3D MCh SNIa yields  
 */

#define SEITENZAHL2013_N_MODELS 17
#define SEITENZAHL2013_N_ISOTOPES 69

/*
 * Model map
 */
#define SEITENZAHL2013_MODEL_MAP {		\
    "0","N1",					\
    "1","N3",					\
    "2","N5",					\
    "3","N10",					\
    "4","N20",					\
    "5","N40",					\
    "6","N100L",				\
    "7","N100",					\
    "8","N100H",				\
    "9","N150",					\
    "10","N200",				\
    "11","N300C",				\
    "12","N1600",				\
    "13","N1600C",				\
    "14","N100_Z0.5",				\
    "15","N100_Z0.1",				\
    "16","N100_Z0.01"				\
  }

/*
 * Yield tables
 */
#define SEITENZAHL2013_DATA {						\
									\
    {									\
									\
      /* Model N1 */							\
									\
      0.00261,1.84e-08,2.92e-06,3.36e-09,0.0263,3.96e-07,3.32e-09,3.73e-11,0.00147,3.08e-07,6.4e-05,2.2e-05,0.00393,3.35e-05,5.15e-05,0.000198,0.0632,0.000269,0.000596,0.00014,0.0262,7.51e-05,0.000826,4.29e-05,0.00452,8.12e-08,7.32e-06,0.000377,2.26e-05,1.68e-09,0.00405,1.29e-06,8.32e-06,1.63e-08,3.25e-06,5.12e-08,1.58e-11,4.33e-06,1.8e-07,1.97e-15,0.000102,8.06e-06,0.000101,2.48e-08,8.95e-10,3.41e-05,0.00355,0.000525,9.85e-07,0.0302,0.00874,1.11,0.0337,7.14e-06,0.0726,0.000418,0.00201,8.45e-05,0.000655,4.44e-07,4.24e-09,1.72e-06,1.09e-07,2.55e-06,1.48e-09,9.01e-10,5.66e-14,3.39e-16,2.06e-15 \
    },									\
									\
    {									\
									\
      /* Model N3 */							\
									\
      0.0099,6.15e-08,9.93e-06,1.22e-08,0.0474,1.37e-06,1.33e-08,1.35e-10,0.00337,9.79e-07,0.000326,6.41e-05,0.00713,9.26e-05,0.000136,0.000395,0.0899,0.000464,0.001,0.000228,0.037,0.000106,0.00116,6.2e-05,0.00636,1.35e-07,9.62e-06,0.000515,2.98e-05,2.45e-09,0.00574,1.65e-06,1.11e-05,1.93e-08,4.4e-06,6.53e-08,1.99e-11,5.72e-06,2.28e-07,3.88e-15,0.000141,1.07e-05,0.000139,5.52e-08,1.21e-09,4.14e-05,0.00406,0.000527,2.06e-06,0.0307,0.00693,1.04,0.0305,1.41e-05,0.0678,0.000497,0.00263,9.36e-05,0.000731,4.94e-07,8.11e-09,1.83e-06,1.15e-07,2.7e-06,1.53e-09,9.38e-10,8.72e-14,6.43e-16,2.25e-15 \
    },									\
									\
    {									\
									\
      /* Model N5 */							\
									\
      0.00905,5.05e-08,8.46e-06,1.03e-08,0.0563,1.16e-06,1.11e-08,1.17e-10,0.00375,8.81e-07,0.000287,6.09e-05,0.00853,8.92e-05,0.000134,0.000456,0.119,0.000568,0.00123,0.000287,0.0479,0.000142,0.00157,8.27e-05,0.00803,1.65e-07,1.34e-05,0.000718,4.12e-05,3.13e-09,0.00709,2.3e-06,1.55e-05,2.63e-08,5.24e-06,8.56e-08,2.66e-11,8.01e-06,3.01e-07,7.61e-15,0.000167,1.29e-05,0.000184,1.33e-07,1.94e-09,5.01e-05,0.00456,0.000591,4.54e-06,0.0384,0.0068,0.98,0.0291,3.21e-05,0.0698,0.000562,0.00322,0.000102,0.00081,5.59e-07,1.94e-08,2.09e-06,1.32e-07,3.11e-06,1.77e-09,1.1e-09,1.77e-13,1.52e-15,3.31e-15 \
    },									\
									\
    {									\
									\
      /* Model N10 */							\
									\
      0.00443,2.57e-08,3.85e-06,4.47e-09,0.0516,5.34e-07,4.54e-09,5.05e-11,0.0024,4.16e-07,0.000131,3.22e-05,0.00777,5.07e-05,7.55e-05,0.000371,0.138,0.000517,0.00118,0.000278,0.0574,0.000153,0.00175,8.37e-05,0.00989,1.41e-07,1.53e-05,0.000801,4.65e-05,2.9e-09,0.00882,2.66e-06,1.74e-05,2.92e-08,6.49e-06,1.03e-07,2.64e-11,9.13e-06,3.58e-07,7.56e-15,0.000207,1.61e-05,0.000227,1.44e-07,2.34e-09,6.18e-05,0.00545,0.000709,5.18e-06,0.0477,0.00761,0.946,0.0282,3.63e-05,0.0713,0.000598,0.00358,0.000101,0.000806,5.71e-07,2.15e-08,2.11e-06,1.32e-07,3.13e-06,1.79e-09,1.12e-09,2e-13,1.63e-15,3.49e-15 \
    },									\
									\
    {									\
									\
      /* Model N20 */							\
									\
      0.0092,4.52e-08,8.34e-06,1.03e-08,0.0904,1.12e-06,1.12e-08,1.22e-10,0.00541,9.63e-07,0.000258,7.3e-05,0.0146,0.000111,0.000171,0.000732,0.198,0.000949,0.00212,0.000487,0.0774,0.000243,0.00284,0.000135,0.0128,2.54e-07,2.26e-05,0.00125,6.8e-05,4.79e-09,0.0113,3.8e-06,2.65e-05,4.29e-08,8.14e-06,1.36e-07,4.01e-11,1.33e-05,4.84e-07,1.86e-14,0.000267,2.07e-05,0.000308,3.43e-07,3.7e-09,8.06e-05,0.00723,0.000948,1.08e-05,0.0671,0.0097,0.79,0.0231,7.37e-05,0.0663,0.000612,0.00431,9.18e-05,0.000749,5.62e-07,4.72e-08,2.09e-06,1.31e-07,3.04e-06,1.75e-09,1.13e-09,3.3e-13,3.67e-15,4.73e-15 \
    },									\
									\
    {									\
									\
      /* Model N40 */							\
									\
      0.0039,2.18e-08,4.3e-06,5.16e-09,0.0989,5.54e-07,5.29e-09,6.22e-11,0.00415,5.43e-07,5.77e-05,4.66e-05,0.0154,7.7e-05,0.000117,0.000705,0.259,0.00103,0.00235,0.00056,0.101,0.000314,0.00373,0.000167,0.0161,2.57e-07,3.14e-05,0.00172,9.52e-05,5.27e-09,0.0135,5.38e-06,3.69e-05,5.62e-08,9.14e-06,1.83e-07,4.76e-11,1.87e-05,6.33e-07,5.84e-15,0.000285,2.35e-05,0.000406,1.62e-07,4.68e-09,9.51e-05,0.0077,0.00112,7.59e-06,0.09,0.0121,0.67,0.0203,5.33e-05,0.0689,0.000559,0.0044,6.57e-05,0.000527,4.43e-07,2.4e-08,1.71e-06,1.05e-07,2.41e-06,1.42e-09,8.87e-10,2.72e-13,1.36e-15,3.43e-15 \
    },									\
									\
    {									\
									\
      /* Model N100L */							\
									\
      0.00385,2.17e-08,3.98e-06,4.66e-09,0.124,5.14e-07,4.61e-09,5.68e-11,0.00433,5.17e-07,5.51e-05,4.68e-05,0.0183,8.02e-05,0.000119,0.000832,0.355,0.00125,0.00286,0.000709,0.138,0.000421,0.00502,0.000227,0.0217,3.05e-07,4.49e-05,0.00248,0.000139,6.6e-09,0.0175,7.87e-06,5.44e-05,7.44e-08,1.11e-05,2.51e-07,6.06e-11,2.75e-05,8.51e-07,3.04e-15,0.000336,2.76e-05,0.000463,6.88e-10,3.84e-09,0.000101,0.00802,0.000998,1.11e-05,0.057,0.0133,0.533,0.0143,1.27e-07,0.0381,0.000148,0.000764,3.09e-05,0.000246,1.72e-07,5.26e-14,9.19e-07,6.04e-08,1.44e-06,8.79e-10,5.26e-10,6.71e-15,5.97e-24,1.22e-15	\
    },									\
									\
    {									\
									\
      /* Model N100 */							\
									\
      0.00304,1.74e-08,3.21e-06,3.67e-09,0.101,4.13e-07,3.53e-09,4.39e-11,0.00353,4.11e-07,4.07e-05,3.74e-05,0.0152,6.49e-05,9.66e-05,0.000674,0.284,0.00103,0.00236,0.000577,0.111,0.000339,0.00404,0.000178,0.0177,2.47e-07,3.51e-05,0.00191,0.000107,5.21e-09,0.0147,6.08e-06,4.15e-05,6.12e-08,1e-05,2.05e-07,4.85e-11,2.11e-05,7.05e-07,7.85e-15,0.000314,2.59e-05,0.000451,2.6e-07,5.56e-09,0.000105,0.00857,0.00124,2.61e-07,0.0994,0.00929,0.622,0.0188,8.02e-05,0.069,0.000534,0.00454,4.76e-05,0.0004,3.78e-07,3.83e-08,1.32e-06,8.02e-08,1.79e-06,1.09e-09,7.24e-10,3.93e-13,2.23e-15,4.03e-15 \
    },									\
									\
    {									\
									\
      /* Model N100H */							\
									\
      0.00387,2.28e-08,4.25e-06,5.24e-09,0.073,5.61e-07,5.59e-09,6.32e-11,0.00366,5.2e-07,7.62e-05,4.25e-05,0.0115,6.86e-05,0.000104,0.000547,0.212,0.000773,0.00172,0.00042,0.0855,0.000237,0.00274,0.000127,0.0143,1.89e-07,2.44e-05,0.00129,7.4e-05,3.81e-09,0.0124,4.22e-06,2.8e-05,4.37e-08,8.92e-06,1.56e-07,7.13e-10,1.46e-05,5.44e-07,9.97e-11,0.000287,2.35e-05,0.000395,0.000102,3.2e-08,0.000151,0.0116,0.00146,0.00125,0.098,0.0139,0.747,0.0225,0.00509,0.0754,0.000996,0.00879,0.00012,0.00285,2.32e-06,9.61e-06,1.94e-06,3.23e-07,2.74e-06,2.26e-09,1.07e-08,1.04e-11,2.23e-12,3.47e-13 \
    },									\
									\
    {									\
									\
      /* Model N150 */							\
									\
      0.0172,1e-07,1.84e-05,2.29e-08,0.124,2.48e-06,2.52e-08,2.64e-10,0.00872,1.98e-06,0.000483,0.000138,0.0193,0.000202,0.000307,0.00104,0.271,0.0013,0.00277,0.000659,0.107,0.000327,0.00368,0.000189,0.0176,3.59e-07,3.14e-05,0.00169,9.53e-05,6.64e-09,0.015,5.36e-06,3.63e-05,5.57e-08,1.04e-05,1.92e-07,5.5e-11,1.86e-05,6.53e-07,6.17e-15,0.000331,2.69e-05,0.000447,1.61e-07,5.07e-09,0.000109,0.0089,0.00129,8.55e-06,0.104,0.0139,0.584,0.0179,6.05e-05,0.0701,0.000523,0.00456,3.51e-05,0.000294,3.2e-07,2.44e-08,1.06e-06,6.14e-08,1.39e-06,8.61e-10,5.68e-10,3.27e-13,1.25e-15,3.15e-15 \
    },									\
									\
    {									\
									\
      /* Model N200 */							\
									\
      0.0121,6.57e-08,1.33e-05,1.71e-08,0.196,1.74e-06,1.98e-08,2.13e-10,0.0115,1.68e-06,0.000234,0.000138,0.0332,0.000214,0.000327,0.00164,0.328,0.00208,0.00476,0.00108,0.11,0.000523,0.00622,0.000289,0.015,5.42e-07,4.66e-05,0.00269,0.000142,1.04e-08,0.0107,7.81e-06,5.71e-05,8.61e-08,6.45e-06,2.2e-07,8.6e-11,2.72e-05,7.66e-07,5.21e-15,0.00018,1.72e-05,0.000448,4.58e-08,6.16e-09,8.19e-05,0.00562,0.00106,4.94e-06,0.113,0.0131,0.436,0.0153,2.83e-05,0.0729,0.000528,0.00467,1.69e-05,0.000131,2.1e-07,5.97e-09,5.45e-07,2.58e-08,5.97e-07,3.91e-10,2.58e-10,1.39e-13,1.76e-16,1.24e-15 \
    },									\
									\
    {									\
									\
      /* Model N300C */							\
									\
      0.00886,4.95e-08,9.16e-06,1.14e-08,0.121,1.22e-06,1.25e-08,1.36e-10,0.00676,1.08e-06,0.000211,8.53e-05,0.0197,0.000133,0.000201,0.000968,0.319,0.00129,0.00287,0.000685,0.127,0.000365,0.00422,0.0002,0.0208,3.23e-07,3.63e-05,0.00196,0.00011,6.29e-09,0.0178,6.21e-06,4.22e-05,6.03e-08,1.19e-05,2.2e-07,5.65e-11,2.17e-05,7.44e-07,8.89e-14,0.000378,3.05e-05,0.000505,1.25e-06,6.72e-09,0.00012,0.00985,0.00136,3.24e-05,0.103,0.0135,0.533,0.0156,0.000213,0.0626,0.000503,0.00457,2.56e-05,0.000301,3.23e-07,1.63e-07,6.42e-07,4.13e-08,7.64e-07,4.91e-10,5.91e-10,8.44e-13,1.48e-14,9.47e-15 \
    },									\
									\
    {									\
									\
      /* Model N1600 */							\
									\
      0.0106,5.57e-08,1.04e-05,1.29e-08,0.191,1.36e-06,1.44e-08,1.58e-10,0.0094,1.29e-06,0.000232,0.000109,0.0308,0.000175,0.000263,0.00148,0.361,0.00197,0.00453,0.00105,0.122,0.000547,0.00656,0.000298,0.0164,4.97e-07,5.22e-05,0.00298,0.00016,9.87e-09,0.011,8.93e-06,6.44e-05,9.21e-08,6.08e-06,2.48e-07,8.43e-11,3.11e-05,8.46e-07,4.52e-15,0.00015,1.62e-05,0.000508,1.19e-09,6.11e-09,8.09e-05,0.00478,0.00106,3.17e-06,0.122,0.0131,0.39,0.0145,7.02e-06,0.0748,0.000623,0.00579,1.48e-05,9.83e-05,1.91e-07,1.78e-11,5.66e-07,2.41e-08,5.74e-07,3.76e-10,2.29e-10,9.1e-15,7.4e-22,6.14e-16 \
    },									\
									\
    {									\
									\
      /* Model N1600C */						\
									\
      0.0168,8.44e-08,1.88e-05,2.41e-08,0.272,2.42e-06,2.73e-08,2.97e-10,0.0173,2.39e-06,0.000297,0.000202,0.0464,0.000312,0.000482,0.00237,0.344,0.00286,0.00655,0.00147,0.103,0.000679,0.00806,0.000384,0.0123,7.68e-07,5.75e-05,0.00342,0.000175,1.48e-08,0.0075,9.65e-06,7.3e-05,1.14e-07,4.06e-06,2.45e-07,1.24e-10,3.34e-05,8.59e-07,6.99e-15,9.3e-05,1.03e-05,0.000401,1.72e-09,7.52e-09,6.01e-05,0.00394,0.00092,4.06e-06,0.1,0.0113,0.354,0.0126,8.7e-06,0.0616,0.00062,0.00675,1.61e-05,0.000105,2.29e-07,2.55e-11,6.38e-07,2.77e-08,6.45e-07,4.24e-10,2.53e-10,1.15e-14,1.25e-21,7.02e-16 \
    },									\
									\
    {									\
									\
      /* Model N100_Z0.5 */						\
									\
      0.0031,8.47e-09,1.8e-06,2.07e-09,0.0987,2.84e-07,2.23e-09,2.2e-11,0.0036,1.97e-07,1.65e-05,2.63e-05,0.0202,3.09e-05,4.44e-05,0.000588,0.29,0.000728,0.00119,0.000358,0.112,0.000239,0.00186,9.91e-05,0.0185,3.86e-08,2.27e-05,0.000831,6.25e-05,4.66e-10,0.0157,3.85e-06,1.67e-05,2.35e-08,1.08e-05,1.43e-07,2.24e-12,9.34e-06,3.37e-07,5.04e-15,0.000343,2.06e-05,0.000253,2.52e-07,3.01e-09,7.65e-05,0.00897,0.00102,1.07e-05,0.0819,0.0111,0.646,0.0166,7.85e-05,0.059,0.000509,0.00487,5.04e-05,0.000301,3.17e-07,3.72e-08,2.22e-06,9.98e-08,1.43e-06,7.08e-10,3.7e-10,3.81e-13,2.16e-15,3.06e-15 \
    },									\
									\
    {									\
									\
      /* Model N100_Z0.1 */						\
									\
      0.00315,1.91e-09,4.71e-07,2.98e-09,0.0964,9.32e-08,1.21e-09,1.48e-11,0.00369,4.47e-08,2.3e-06,1.96e-05,0.0269,1.06e-05,7.36e-06,0.000268,0.294,0.00043,0.000144,0.000105,0.112,0.000104,0.00026,2.64e-05,0.0192,1.64e-09,9.14e-06,0.000119,1.89e-05,9.87e-12,0.0166,1.42e-06,2.08e-06,6.22e-09,1.18e-05,7.69e-08,5.88e-13,1.37e-06,9.3e-08,4.85e-15,0.000373,1.27e-05,0.000111,2.47e-07,2.3e-09,3.99e-05,0.00944,0.000761,1.05e-05,0.0687,0.00873,0.666,0.0141,7.72e-05,0.0509,0.00044,0.00539,4.62e-05,0.000154,3.27e-06,3.65e-08,1.73e-05,1.26e-07,6.29e-07,2.47e-10,1.71e-10,3.73e-13,2.1e-15,2.69e-15	\
    },									\
									\
    {									\
									\
      /* Model N100_Z0.01 */						\
									\
      0.00316,2.72e-10,7.22e-08,8.73e-08,0.0947,5.43e-09,9.93e-10,4.79e-11,0.00374,6.93e-09,1.71e-07,1.72e-05,0.029,8.99e-07,1.04e-06,8.71e-05,0.289,0.000135,1.84e-05,3.54e-05,0.115,4.57e-05,7.14e-06,5.65e-06,0.0204,1.73e-11,3.52e-06,5.4e-06,3.57e-06,5.11e-14,0.0177,4.92e-07,8.87e-08,6.23e-09,1.27e-05,3.94e-08,5.82e-13,2.19e-07,9.9e-08,4.82e-15,0.000387,6.83e-06,8.59e-05,2.46e-07,2.28e-09,2.62e-05,0.00964,0.000627,1.05e-05,0.0662,0.00784,0.672,0.0128,7.7e-05,0.0501,0.000753,0.00536,2.71e-05,0.000125,1.29e-05,3.63e-08,2.64e-05,1.45e-07,4.37e-07,1.73e-10,1.51e-10,3.72e-13,2.09e-15,2.66e-15 \
    }									\
  }

#endif // NUCSYN_SEITENZAHL2013_H
