#include "../binary_c.h"

/* Function to set the nuclear masses into the mnuc array */

#ifdef NUCSYN
void nucsyn_set_nuc_masses(Nuclear_mass * RESTRICT mnuc,
                           Nuclear_mass * RESTRICT imnuc,
                           Nuclear_mass * RESTRICT mnuc_amu, // (as mnuc /= AMU_GRAMS)
                           Nuclear_mass * RESTRICT imnuc_amu, 
                           Molecular_weight * RESTRICT  molweight,
                           double * RESTRICT ZonA,
                           Atomic_number * RESTRICT atomic_number,
                           Nucleon_number * RESTRICT nucleon_number)
{
    static const char s[][10]=NUCSYN_SHORT_ELEMENT_STRINGS;
    Isotope i;
    mnuc[Xn]=1.67492716e-24; atomic_number[Xn]=0; nucleon_number[Xn]=1;
    mnuc[Xe]=9.10938188e-28; atomic_number[Xe]=0; nucleon_number[Xe]=0;
    /*
     * Nuclear masses from http://wwwndc.jaea.go.jp/NuC/
     */
#include "nucsyn_nuc_masses.h"

    Ordered_isotope_loop(i)
    {
#ifdef Xelse
        if(i!=Xelse)
#endif
        {
            if(Is_really_zero(mnuc[i]))
            {
                Isotope j = i==0 ? 0 : i-1;
                fprintf(stderr,
                        "Nuclear mass of isotope %u is zero : everything will fail :( ... previous isotope is %u which is %s%d\n",
                        i,j,s[atomic_number[j]],nucleon_number[j]);
            }
            const Nuclear_mass temp = 1.0 / mnuc[i];
            const double Z = (double) atomic_number[i];

            imnuc[i] = temp;
            ZonA[i]  =  Z * temp;

            mnuc_amu[i] = mnuc[i] / AMU_GRAMS;
            imnuc_amu[i] = imnuc[i] * AMU_GRAMS;
            molweight[i] = (Z + 1.0) * temp;
            
            nucleon_number[i] = (int)(0.5 + mnuc_amu[i]); /* approximately! */

#ifdef NUC_MASSES_DEBUG
            _printf(
                "Isotope %d , mnuc=%g (/anu=%g) Z=%d is %s i.e. %s%d\n",
                i,
                mnuc[i],
                mnuc[i]/AMU_GRAMS,
                atomic_number[i],
                s[atomic_number[i]],
                s[atomic_number[i]],
                nucleon_number[i]);
#endif
        }
    }
  
}
#endif /* NUCSYN */
