#include "nucsyn.h"

#ifdef NUCSYN

/*
 * Given an array of abundances X, renormalize
 * the total to 1.0
 */
void nucsyn_renormalize_abundance(struct stardata_t * const stardata,
                                  Abundance * RESTRICT const X)
{
    const double inverse_Xsum = 1.0 / XXsum(stardata,X);
    if(!Fequal(inverse_Xsum,1.0))
    {
        Xmult(X,inverse_Xsum);
    }
}

#endif //NUCSYN
