#include "../binary_c.h"

#ifdef NUCSYN

void nucsyn_remove_mass_from_surface(
#if defined DEBUG && DEBUG > 0
    struct stardata_t * stardata,
#endif
    struct star_t * RESTRICT star,
    const double dm,
    Abundance ** RESTRICT Xp,
    double * RESTRICT ndmacc,
    Boolean * RESTRICT allocated)
{
    /* 
     * Remove material dm (>0.0) from the star, and
     * set X, the abundance of the material removed,
     * if X is non-NULL.
     *
     * Allocated can be NULL but only if X is NULL.
     */

    ndmacc[star->starnum] = Max(0.0, ndmacc[star->starnum] - dm);
    if(likely(Xp!=NULL))
    {
        nucsyn_remove_dm_from_surface(
#if defined DEBUG && DEBUG > 0
            stardata,
#endif
            star,
            dm,
            Xp,
            allocated);
    }
    else if(allocated != NULL)
    {
        *allocated = FALSE;
    }
}
#endif //NUCSYN
