#include "../binary_c.h"

#if (defined NUCSYN && defined NUCSYN_RADIOACTIVE_DECAY)

/* fold radioactive decay into easy macro: but choose your form carefully... 
 * CLEVER_DECAY may be faster! (or may not...) */
#define CLEVER_DECAY

/* define the timestep in YEARS */
#define TIMESTEP dt

#ifdef CLEVER_DECAY
#define __multiplier(B) pow(et,1.0/((B)*1e-6))
#else
#define __multiplier(B) exp(-TIMESTEP/(B))
#endif

#define DO_RADIOACTIVE_DECAY(A,B,C) if(Isotope_is_valid(A))   \
    {                                                   \
        x=X[(A)];                                       \
        if(x>ABUND_ZERO)                                \
        {                                               \
            X[(A)]*=(__multiplier(B));                  \
            X[(C)]+=(x-X[(A)]);                         \
        }                                               \
    }



void nucsyn_radioactive_decay(struct stardata_t * RESTRICT const stardata)
{
    // Radioactive decay of elements
    Abundance x;
    Star_number k;
    const double dt= (1e6*stardata->model.dtm);
    
    double *X;
#ifdef CLEVER_DECAY
    double et=exp(-stardata->model.dtm);
#endif

    if(TIMESTEP < 0.0) return;

    Starloop(k)
    {
        
	SETstar(k);
	X=star->Xenv;
	    
	Dprint("star %d (k=%d) Tc was %g (dt=%g / %g) now ",
	       k,
	       stardata->star[k].stellar_type,
	       X[XTc99],
	       TIMESTEP,
	       XTc99_BETA_DECAY);

	/* standard isotopes (NOT s elements except Tc) */
	DO_RADIOACTIVE_DECAY(XTc99,XTc99_BETA_DECAY,XRu99);
	DO_RADIOACTIVE_DECAY(XAl26,XAl26_BETA_DECAY,XMg26);
	DO_RADIOACTIVE_DECAY(XBe7,XBe7_BETA_DECAY,XLi7);
	DO_RADIOACTIVE_DECAY(XNa22,XNa22_BETA_DECAY,XNe22);
	//DO_RADIOACTIVE_DECAY(XCa41,XNi59_BETA_DECAY,XK41);
	//DO_RADIOACTIVE_DECAY(XFe60,XFe60_BETA_DECAY,XNi60); // OOPS!
	//DO_RADIOACTIVE_DECAY(XNi59,XNi59_BETA_DECAY,XCo59); // OOPS!      
	DO_RADIOACTIVE_DECAY(XV50,XV50_BETA_DECAY,XTi50);
	DO_RADIOACTIVE_DECAY(XS30,XS30_BETA_DECAY,XP30);
	DO_RADIOACTIVE_DECAY(XO15,XO15_BETA_DECAY,XN15);
	//DO_RADIOACTIVE_DECAY(XF17,XF17_BETA_DECAY,XO17);
          
	DO_RADIOACTIVE_DECAY(XP30,XP30_BETA_DECAY,XSi30);
	DO_RADIOACTIVE_DECAY(XK40,XK40_BETA_DECAY,XCa40);
	// broken? DO_RADIOACTIVE_DECAY(XN13,XN13_BETA_DECAY,XC13);
      
#ifdef NUCSYN_EXTENDED_S_PROCESS
	/* do extended s-process isotopes */

	DO_RADIOACTIVE_DECAY(XSe79,XSe79_BETA_DECAY,XBr79);
	DO_RADIOACTIVE_DECAY(XKr81,XKr81_BETA_DECAY,XBr81);
	DO_RADIOACTIVE_DECAY(XZr93,XZr93_BETA_DECAY,XNb93);
	DO_RADIOACTIVE_DECAY(XTc99,XTc99_BETA_DECAY,XRu99);
	DO_RADIOACTIVE_DECAY(XCs135,XCs135_BETA_DECAY,XBa135);
	DO_RADIOACTIVE_DECAY(XAg111,XAg111_BETA_DECAY,XCd111);
	DO_RADIOACTIVE_DECAY(XAs76,XAs76_BETA_DECAY,XSe76);
	DO_RADIOACTIVE_DECAY(XAs77,XAs77_BETA_DECAY,XSe77);
	DO_RADIOACTIVE_DECAY(XAu198,XAu198_BETA_DECAY,XHg198);
	DO_RADIOACTIVE_DECAY(XAu199,XAu199_BETA_DECAY,XHg199);
	DO_RADIOACTIVE_DECAY(XBa139,XBa139_BETA_DECAY,XLa139);
	DO_RADIOACTIVE_DECAY(XBa140,XBa140_BETA_DECAY,XLa140);
	DO_RADIOACTIVE_DECAY(XBi210,XBi210_BETA_DECAY,XPo210);
	DO_RADIOACTIVE_DECAY(XBr80,XBr80_BETA_DECAY,XKr80);
	DO_RADIOACTIVE_DECAY(XBr82,XBr82_BETA_DECAY,XKr82);
	DO_RADIOACTIVE_DECAY(XBr83,XBr83_BETA_DECAY,XKr83);
	DO_RADIOACTIVE_DECAY(XCd109,XCd109_BETA_DECAY,XAg109);
	DO_RADIOACTIVE_DECAY(XCd113,XCd113_BETA_DECAY,XIn113);
	DO_RADIOACTIVE_DECAY(XCd115,XCd115_BETA_DECAY,XIn115);
	DO_RADIOACTIVE_DECAY(XCd117,XCd117_BETA_DECAY,XIn117);
	DO_RADIOACTIVE_DECAY(XCe141,XCe141_BETA_DECAY,XPr141);
	DO_RADIOACTIVE_DECAY(XCe143,XCe143_BETA_DECAY,XPr143);
	DO_RADIOACTIVE_DECAY(XCl36,XCl36_BETA_DECAY,XAr36);
	DO_RADIOACTIVE_DECAY(XCs134,XCs134_BETA_DECAY,XBa134);
	DO_RADIOACTIVE_DECAY(XCs136,XCs136_BETA_DECAY,XBa136);
	DO_RADIOACTIVE_DECAY(XCs137,XCs137_BETA_DECAY,XBa137);
	DO_RADIOACTIVE_DECAY(XCu67,XCu67_BETA_DECAY,XZn67);
	DO_RADIOACTIVE_DECAY(XDy165,XDy165_BETA_DECAY,XHo165);
	DO_RADIOACTIVE_DECAY(XDy166,XDy166_BETA_DECAY,XHo166);
	DO_RADIOACTIVE_DECAY(XEr165,XEr165_BETA_DECAY,XHo165);
	DO_RADIOACTIVE_DECAY(XEr169,XEr169_BETA_DECAY,XTm169);
	DO_RADIOACTIVE_DECAY(XEr171,XEr171_BETA_DECAY,XTm171);
	DO_RADIOACTIVE_DECAY(XEr172,XEr172_BETA_DECAY,XTm172);
	DO_RADIOACTIVE_DECAY(XEu152,XEu152_BETA_DECAY,XSm152);
	DO_RADIOACTIVE_DECAY(XEu154,XEu154_BETA_DECAY,XGd154);
	DO_RADIOACTIVE_DECAY(XEu155,XEu155_BETA_DECAY,XGd155);
	DO_RADIOACTIVE_DECAY(XEu156,XEu156_BETA_DECAY,XGd156);
	DO_RADIOACTIVE_DECAY(XEu157,XEu157_BETA_DECAY,XGd157);
	DO_RADIOACTIVE_DECAY(XGa72,XGa72_BETA_DECAY,XGe72);
	DO_RADIOACTIVE_DECAY(XGa73,XGa73_BETA_DECAY,XGe73);
	DO_RADIOACTIVE_DECAY(XGd153,XGd153_BETA_DECAY,XEu153);
	DO_RADIOACTIVE_DECAY(XGd159,XGd159_BETA_DECAY,XTb159);
	DO_RADIOACTIVE_DECAY(XHf181,XHf181_BETA_DECAY,XTa181);
	DO_RADIOACTIVE_DECAY(XHf182,XHf182_BETA_DECAY,XTa182);
	DO_RADIOACTIVE_DECAY(XHg203,XHg203_BETA_DECAY,XTl203);
	DO_RADIOACTIVE_DECAY(XHo163,XHo163_BETA_DECAY,XDy163);
	DO_RADIOACTIVE_DECAY(XHo164,XHo164_BETA_DECAY,XDy164);
	DO_RADIOACTIVE_DECAY(XHo166,XHo166_BETA_DECAY,XEr166);
	DO_RADIOACTIVE_DECAY(XHo167,XHo167_BETA_DECAY,XEr167);
	DO_RADIOACTIVE_DECAY(XI128,XI128_BETA_DECAY,XXe128);
	DO_RADIOACTIVE_DECAY(XI129,XI129_BETA_DECAY,XXe129);
	DO_RADIOACTIVE_DECAY(XI130,XI130_BETA_DECAY,XXe130);
	DO_RADIOACTIVE_DECAY(XI131,XI131_BETA_DECAY,XXe131);
	DO_RADIOACTIVE_DECAY(XIn115,XIn115_BETA_DECAY,XSn115);
	DO_RADIOACTIVE_DECAY(XIn117,XIn117_BETA_DECAY,XSn117);
	DO_RADIOACTIVE_DECAY(XIr192,XIr192_BETA_DECAY,XPt192);
	DO_RADIOACTIVE_DECAY(XIr194,XIr194_BETA_DECAY,XPt194);
	DO_RADIOACTIVE_DECAY(XIr195,XIr195_BETA_DECAY,XPt195);
	DO_RADIOACTIVE_DECAY(XKr85,XKr85_BETA_DECAY,XRb85);
	DO_RADIOACTIVE_DECAY(XLa140,XLa140_BETA_DECAY,XCe140);
	DO_RADIOACTIVE_DECAY(XLa141,XLa141_BETA_DECAY,XCe141);
	DO_RADIOACTIVE_DECAY(XLu176,XLu176_BETA_DECAY,XHf176);
	DO_RADIOACTIVE_DECAY(XLu177,XLu177_BETA_DECAY,XHf177);
	DO_RADIOACTIVE_DECAY(XLu178,XLu178_BETA_DECAY,XHf178);
	DO_RADIOACTIVE_DECAY(XMo93,XMo93_BETA_DECAY,XNb93);
	DO_RADIOACTIVE_DECAY(XMo99,XMo99_BETA_DECAY,XTc99);
	// repeated ? DO_RADIOACTIVE_DECAY(XNa22,XNa22_BETA_DECAY,XNe22);

	DO_RADIOACTIVE_DECAY(XNb94,XNb94_BETA_DECAY,XMo94);
	DO_RADIOACTIVE_DECAY(XNb95,XNb95_BETA_DECAY,XMo95);
	DO_RADIOACTIVE_DECAY(XNb96,XNb96_BETA_DECAY,XMo96);
	DO_RADIOACTIVE_DECAY(XNd147,XNd147_BETA_DECAY,XPm147);
	DO_RADIOACTIVE_DECAY(XNd149,XNd149_BETA_DECAY,XPm149);
	DO_RADIOACTIVE_DECAY(XOs191,XOs191_BETA_DECAY,XIr191);
	DO_RADIOACTIVE_DECAY(XOs193,XOs193_BETA_DECAY,XIr193);
	DO_RADIOACTIVE_DECAY(XOs194,XOs194_BETA_DECAY,XIr194);
	DO_RADIOACTIVE_DECAY(XPb205,XPb205_BETA_DECAY,XTl205);
	DO_RADIOACTIVE_DECAY(XPd107,XPd107_BETA_DECAY,XAg107);
	DO_RADIOACTIVE_DECAY(XPd109,XPd109_BETA_DECAY,XAg109);
	DO_RADIOACTIVE_DECAY(XPm145,XPm145_BETA_DECAY,XNd145);
	DO_RADIOACTIVE_DECAY(XPm146,XPm146_BETA_DECAY,XNd146);
	DO_RADIOACTIVE_DECAY(XPm147,XPm147_BETA_DECAY,XSm147);
	DO_RADIOACTIVE_DECAY(XPm148,XPm148_BETA_DECAY,XSm148);
	DO_RADIOACTIVE_DECAY(XPm149,XPm149_BETA_DECAY,XSm149);
	DO_RADIOACTIVE_DECAY(XPr142,XPr142_BETA_DECAY,XNd142);
	DO_RADIOACTIVE_DECAY(XPr143,XPr143_BETA_DECAY,XNd143);
	DO_RADIOACTIVE_DECAY(XPt193,XPt193_BETA_DECAY,XIr193);
	DO_RADIOACTIVE_DECAY(XPt197,XPt197_BETA_DECAY,XAu197);
	DO_RADIOACTIVE_DECAY(XRb86,XRb86_BETA_DECAY,XSr86);
	DO_RADIOACTIVE_DECAY(XRb87,XRb87_BETA_DECAY,XSr87);
	DO_RADIOACTIVE_DECAY(XRe186,XRe186_BETA_DECAY,XOs186);
	DO_RADIOACTIVE_DECAY(XRe187,XRe187_BETA_DECAY,XOs187);
	DO_RADIOACTIVE_DECAY(XRe188,XRe188_BETA_DECAY,XOs188);
	DO_RADIOACTIVE_DECAY(XRh105,XRh105_BETA_DECAY,XPd105);
	DO_RADIOACTIVE_DECAY(XRu103,XRu103_BETA_DECAY,XRh103);
	DO_RADIOACTIVE_DECAY(XRu97,XRu97_BETA_DECAY,XTc97);
	DO_RADIOACTIVE_DECAY(XSb122,XSb122_BETA_DECAY,XTe122);
	DO_RADIOACTIVE_DECAY(XSb124,XSb124_BETA_DECAY,XTe124);
	DO_RADIOACTIVE_DECAY(XSb125,XSb125_BETA_DECAY,XTe125);
	DO_RADIOACTIVE_DECAY(XSm145,XSm145_BETA_DECAY,XPm145);
	DO_RADIOACTIVE_DECAY(XSm151,XSm151_BETA_DECAY,XEu151);
	DO_RADIOACTIVE_DECAY(XSm153,XSm153_BETA_DECAY,XEu153);
	DO_RADIOACTIVE_DECAY(XSn121,XSn121_BETA_DECAY,XSb121);
	DO_RADIOACTIVE_DECAY(XSn123,XSn123_BETA_DECAY,XSb123);
	DO_RADIOACTIVE_DECAY(XSr89,XSr89_BETA_DECAY,XY89);
	DO_RADIOACTIVE_DECAY(XSr90,XSr90_BETA_DECAY,XY90);
	DO_RADIOACTIVE_DECAY(XTa179,XTa179_BETA_DECAY,XHf179);
	DO_RADIOACTIVE_DECAY(XTa180,XTa180_BETA_DECAY,XHf180);
	DO_RADIOACTIVE_DECAY(XTa182,XTa182_BETA_DECAY,XW182);
	DO_RADIOACTIVE_DECAY(XTa183,XTa183_BETA_DECAY,XW183);
	DO_RADIOACTIVE_DECAY(XTa184,XTa184_BETA_DECAY,XW184);
	DO_RADIOACTIVE_DECAY(XTb160,XTb160_BETA_DECAY,XDy160);
	DO_RADIOACTIVE_DECAY(XTb161,XTb161_BETA_DECAY,XDy161);
	DO_RADIOACTIVE_DECAY(XTc97,XTc97_BETA_DECAY,XMo97);
	DO_RADIOACTIVE_DECAY(XTc98,XTc98_BETA_DECAY,XRu98);
	DO_RADIOACTIVE_DECAY(XTe127,XTe127_BETA_DECAY,XI127);
	DO_RADIOACTIVE_DECAY(XTl204,XTl204_BETA_DECAY,XPb204);
	DO_RADIOACTIVE_DECAY(XTm170,XTm170_BETA_DECAY,XYb170);
	DO_RADIOACTIVE_DECAY(XTm171,XTm171_BETA_DECAY,XYb171);
	DO_RADIOACTIVE_DECAY(XTm172,XTm172_BETA_DECAY,XYb172);
	DO_RADIOACTIVE_DECAY(XW181,XW181_BETA_DECAY,XTa181);
	DO_RADIOACTIVE_DECAY(XW185,XW185_BETA_DECAY,XRe185);
	DO_RADIOACTIVE_DECAY(XW187,XW187_BETA_DECAY,XRe187);
	DO_RADIOACTIVE_DECAY(XW188,XW188_BETA_DECAY,XRe188);
	DO_RADIOACTIVE_DECAY(XXe133,XXe133_BETA_DECAY,XCs133);
	DO_RADIOACTIVE_DECAY(XXe135,XXe135_BETA_DECAY,XCs135);
	DO_RADIOACTIVE_DECAY(XY90,XY90_BETA_DECAY,XZr90);
	DO_RADIOACTIVE_DECAY(XY91,XY91_BETA_DECAY,XZr91);
	DO_RADIOACTIVE_DECAY(XYb175,XYb175_BETA_DECAY,XLu175);
	DO_RADIOACTIVE_DECAY(XZr95,XZr95_BETA_DECAY,XNb95);
	DO_RADIOACTIVE_DECAY(XNd144,XNd144_ALPHA_DECAY,XCe140);
	DO_RADIOACTIVE_DECAY(XPm145,XPm145_ALPHA_DECAY,XPr141);
	DO_RADIOACTIVE_DECAY(XSm146,XSm146_ALPHA_DECAY,XNd142);
	DO_RADIOACTIVE_DECAY(XSm147,XSm147_ALPHA_DECAY,XNd143);
	DO_RADIOACTIVE_DECAY(XSm148,XSm148_ALPHA_DECAY,XNd144);
	DO_RADIOACTIVE_DECAY(XGd152,XGd152_ALPHA_DECAY,XSm148);
	DO_RADIOACTIVE_DECAY(XOs186,XOs186_ALPHA_DECAY,XW182);
	DO_RADIOACTIVE_DECAY(XPo210,XPo210_ALPHA_DECAY,XPb206);
#endif
    }

    Dprint("Done radioactive decay\n");

}

#endif // NUCSYN_RADIOACTIVE_DECAY && NUCSYN

