#include "nucsyn.h"
#ifdef NUCSYN

Moles Pure_function nucsyn_mole_fraction(const Isotope i, /* the species */
                                         const Abundance * RESTRICT const X, /* mass fractions */
                                         const Abundance * RESTRICT const mnuc /* nuclear masses */)
{
    /*
     * Function to calculate the mole fraction (or the number fraction) of a
     * species
     */
    Isotope j;
    Moles molefrac=0.0;
    Isotope_loop(j)
    {
        molefrac+=X[j]/mnuc[j];
    }
    molefrac *= mnuc[i];
    molefrac = X[i]/molefrac;
    return molefrac;
}

#endif /* NUCSYN */
