
#include "../binary_c.h"

#if (defined NUCSYN && defined NUCSYN_LOWZ_SNE_THRESHOLD)


#define LOWZ_YIELDS_TABLE                                               \
    13,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0, \
        1.342e+01,7.739e+00,6.639e-17,3.030e-05,4.681e+00,5.413e-19,7.307e-11,3.675e-38,3.779e-18,8.247e-16,1.534e-01,1.270e-08,4.806e-08,1.381e-10,2.343e-01,3.715e-09,4.601e-08,2.467e-10,1.045e-01,1.774e-05,2.636e-06,1.328e-03,5.829e-02,5.322e-04,6.682e-04,1.602e-03,5.522e-02,6.256e-04,4.529e-04,1.707e-04,2.438e-02,1.267e-04,8.784e-04,6.231e-08,4.453e-05,1.174e-05,3.981e-03,2.475e-04,1.489e-09,1.115e-05,1.233e-08,8.803e-07,3.334e-03,3.983e-06,9.418e-09,1.063e-04,3.296e-12,1.686e-17,1.777e-06,2.058e-06,5.127e-08,1.724e-04,2.834e-06,3.608e-11,1.176e-10,2.099e-06,9.306e-06,6.605e-04,4.202e-05,1.921e-09,1.189e-04,9.624e-04,6.158e-02,2.499e-03,5.593e-10,2.212e-03,1.321e-03,1.954e-06,5.755e-12,8.421e-19,1.568e-13,2.708e-12,1.870e-07,3.146e-15,1.174e-20,1.684e-21, \
        1.826e+01,9.751e+00,6.496e-17,2.866e-05,6.270e+00,2.512e-18,1.980e-10,3.556e-37,3.688e-17,2.195e-15,4.042e-01,4.119e-08,7.028e-08,4.028e-10,6.913e-01,1.052e-08,7.016e-08,1.215e-09,2.866e-01,6.389e-05,1.439e-05,3.807e-03,1.281e-01,1.391e-03,1.535e-03,3.101e-03,1.161e-01,1.224e-03,8.630e-04,3.216e-04,5.102e-02,2.411e-04,1.533e-03,1.060e-07,7.635e-05,2.506e-05,8.288e-03,4.124e-04,2.312e-09,2.006e-05,1.988e-08,1.679e-06,7.009e-03,6.406e-06,1.349e-08,1.510e-04,5.007e-12,1.970e-17,6.290e-06,3.170e-06,7.447e-08,2.864e-04,5.251e-06,5.335e-11,1.886e-10,4.989e-06,1.945e-05,1.529e-03,9.235e-05,3.020e-09,2.776e-04,1.979e-03,1.406e-01,4.254e-03,8.646e-10,2.237e-03,1.986e-03,2.305e-06,7.386e-12,1.138e-18,2.109e-13,9.586e-13,1.448e-07,1.308e-15,3.102e-21,1.819e-22, \
        2.343e+01,1.149e+01,7.419e-17,2.785e-05,7.857e+00,6.598e-18,2.254e-10,1.273e-36,1.338e-16,3.892e-15,5.490e-01,2.433e-07,6.821e-08,6.758e-10,1.514e+00,1.575e-08,9.918e-08,3.471e-09,1.152e+00,2.369e-04,7.642e-05,9.634e-03,2.794e-01,2.314e-03,2.838e-03,6.912e-03,6.617e-02,7.062e-04,4.072e-04,1.493e-04,2.334e-02,9.653e-05,4.398e-04,1.239e-08,3.013e-05,1.159e-05,4.004e-03,1.125e-04,2.738e-10,6.682e-06,4.654e-09,6.489e-07,3.642e-03,1.625e-06,4.022e-09,4.898e-05,3.126e-13,3.936e-19,3.084e-06,8.743e-07,2.658e-08,1.013e-04,2.183e-06,1.204e-11,4.093e-11,1.137e-06,3.539e-06,6.401e-04,4.152e-05,4.701e-10,7.477e-05,4.043e-04,3.130e-02,5.955e-04,1.531e-10,1.285e-03,5.576e-04,1.641e-06,9.386e-13,1.563e-19,2.872e-14,1.637e-11,1.822e-07,3.720e-14,4.933e-19,3.583e-22, \
        3.302e+01,1.474e+01,9.714e-17,2.699e-05,1.075e+01,4.183e-17,2.298e-10,1.762e-33,2.624e-15,1.004e-13,1.235e+00,6.718e-05,2.229e-04,6.361e-07,3.571e+00,8.728e-06,1.631e-05,6.387e-07,9.448e-01,3.733e-04,1.962e-04,9.747e-03,3.452e-01,2.066e-03,1.758e-03,5.134e-03,2.910e-01,2.209e-03,1.516e-03,5.600e-04,1.197e-01,3.872e-04,2.160e-03,1.302e-07,1.017e-04,3.852e-05,1.932e-02,4.636e-04,2.294e-09,3.006e-05,1.575e-08,2.707e-06,1.685e-02,6.782e-06,1.283e-08,2.082e-04,2.075e-10,1.121e-10,1.840e-05,4.001e-06,1.020e-07,5.059e-04,9.763e-06,2.921e-10,1.409e-10,9.452e-06,3.046e-05,3.862e-03,1.974e-04,2.535e-09,5.156e-04,3.097e-03,3.200e-01,6.897e-03,8.013e-10,2.008e-03,3.358e-03,2.962e-06,2.672e-11,7.515e-11,1.663e-11,1.491e-11,8.086e-08,2.222e-11,5.126e-12,9.548e-10, \
        4.795e+01,1.936e+01,1.301e-16,2.684e-05,1.528e+01,3.037e-17,2.411e-10,5.181e-36,1.491e-15,7.077e-15,2.506e+00,2.280e-06,1.114e-06,9.156e-09,6.881e+00,6.289e-08,3.058e-08,4.332e-09,2.005e+00,2.508e-04,2.557e-04,1.070e-02,3.247e-01,6.535e-04,6.771e-04,3.694e-03,2.362e-01,6.208e-04,3.321e-04,1.610e-04,1.121e-01,2.050e-04,9.471e-04,3.458e-09,5.003e-05,3.754e-05,1.969e-02,3.190e-04,7.067e-11,2.677e-05,3.268e-09,2.857e-06,1.769e-02,5.364e-06,9.623e-09,2.137e-04,5.260e-14,1.106e-19,1.939e-05,3.521e-06,9.568e-08,5.021e-04,9.277e-06,2.412e-11,9.072e-11,7.998e-06,2.269e-05,3.683e-03,1.882e-04,1.564e-09,4.644e-04,2.447e-03,3.100e-01,5.921e-03,5.577e-10,1.671e-03,3.915e-03,2.719e-06,2.904e-12,6.793e-19,9.397e-14,1.375e-13,7.734e-08,2.216e-16,4.498e-22,1.073e-22, \
        7.758e+01,2.679e+01,9.521e-16,2.743e-05,2.471e+01,1.113e-16,2.592e-10,3.855e-34,1.386e-13,2.868e-14,4.671e+00,1.354e-07,1.954e-06,2.649e-08,1.504e+01,3.910e-08,2.348e-08,4.089e-09,2.625e+00,1.883e-04,1.964e-04,7.621e-03,6.025e-01,5.593e-04,4.860e-04,3.193e-03,5.247e-01,2.286e-03,1.217e-03,6.495e-04,2.483e-01,5.136e-04,2.255e-03,8.426e-08,1.122e-04,5.948e-05,4.339e-02,5.961e-04,8.844e-10,5.360e-05,1.105e-08,5.929e-06,4.015e-02,1.027e-05,1.914e-08,4.149e-04,1.288e-12,1.195e-18,3.866e-05,7.866e-06,2.470e-07,1.072e-03,1.915e-05,8.928e-12,7.415e-11,1.599e-05,4.124e-05,8.724e-03,3.979e-04,2.139e-09,9.202e-04,4.454e-03,8.200e-01,1.634e-02,8.631e-10,3.572e-03,7.314e-03,6.628e-06,3.192e-12,4.909e-19,1.316e-13,1.439e-13,1.118e-07,2.511e-16,3.994e-22,1.513e-22, \
        80,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0, \
        149,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0, \
        1.500e+02,3.566e+01,2.852e-16,2.726e-05,4.171e+01,1.905e-19,2.967e-10,8.762e-22,1.260e-14,6.806e-14,6.325e+00,3.259e-07,1.424e-02,6.181e-07,5.306e+01,3.918e-05,2.526e-07,1.045e-08,3.384e+00,8.805e-04,8.894e-04,9.371e-03,2.759e+00,4.271e-03,2.245e-03,2.807e-02,4.766e+00,2.224e-02,3.322e-03,2.266e-03,1.805e+00,6.371e-03,5.793e-03,5.009e-08,6.229e-04,5.923e-04,2.351e-01,3.485e-03,2.065e-10,7.993e-04,3.341e-08,1.352e-04,1.883e-01,8.577e-05,7.103e-08,2.834e-05,2.163e-11,4.401e-12,2.747e-06,3.385e-05,1.751e-07,3.545e-05,4.256e-06,4.486e-12,1.027e-10,6.041e-06,1.133e-04,2.558e-04,3.014e-05,4.016e-09,2.739e-04,3.911e-03,5.284e-03,7.033e-05,5.362e-09,2.329e-06,4.347e-04,4.129e-06,1.564e-10,1.822e-11,7.272e-11,8.721e-11,1.320e-10,1.805e-10,8.277e-11,1.551e-10, \
        1.700e+02,4.081e+01,3.667e-05,1.122e-04,4.795e+01,3.928e-15,5.766e-09,1.291e-14,6.640e-22,8.212e-09,2.297e+00,3.849e-07,1.039e-02,4.813e-06,4.423e+01,4.546e-05,9.985e-03,6.489e-07,1.190e+00,1.632e-04,1.021e-03,5.762e-03,1.943e+00,1.264e-03,3.624e-04,2.038e-02,1.616e+01,2.192e-02,2.043e-04,4.027e-04,8.663e+00,1.221e-02,7.065e-04,6.776e-10,3.045e-04,1.608e-03,1.419e+00,8.338e-04,1.036e-11,5.029e-04,1.932e-08,4.032e-04,1.319e+00,2.452e-05,1.136e-08,2.037e-04,1.413e-12,1.539e-16,7.492e-06,1.350e-05,3.035e-07,6.251e-03,1.890e-04,4.479e-14,3.071e-11,1.992e-04,4.818e-04,1.335e-01,5.560e-03,6.950e-09,1.795e-02,1.089e-01,3.630e+00,1.768e-02,1.137e-08,1.422e-05,1.180e-02,1.475e-05,9.618e-10,5.968e-15,2.862e-11,3.317e-13,1.117e-10,1.885e-11,1.742e-13,3.459e-12, \
        2.000e+02,3.725e+01,2.038e-16,3.183e-05,4.903e+01,1.583e-20,5.789e-10,2.838e-18,2.027e-14,1.441e-12,4.241e+00,3.491e-07,5.839e-04,1.114e-06,5.595e+01,7.757e-07,1.054e-05,9.477e-08,3.748e+00,2.001e-04,2.251e-04,6.999e-03,3.075e+00,1.268e-03,3.690e-04,1.557e-02,2.122e+01,1.412e-02,9.665e-04,7.493e-04,1.310e+01,6.068e-03,1.085e-04,4.821e-10,1.266e-04,8.106e-04,2.361e+00,1.949e-05,4.287e-12,4.590e-05,1.618e-09,1.947e-04,2.316e+00,7.254e-07,2.025e-07,4.717e-04,4.228e-12,2.751e-12,8.101e-06,9.282e-07,3.490e-06,1.148e-02,3.354e-04,2.769e-12,8.221e-12,1.308e-04,1.232e-04,1.795e-01,6.882e-03,5.898e-11,8.977e-03,2.332e-02,7.249e+00,8.856e-02,8.554e-10,2.465e-03,6.394e-02,2.270e-02,4.245e-03,1.358e-11,2.161e-05,1.872e-06,1.419e-04,4.107e-05,4.517e-08,9.072e-09, \
        2.700e+02,6.582e+01,1.838e-13,3.955e-05,7.901e+01,9.328e-18,5.522e-09,4.396e-21,3.622e-16,7.461e-09,1.886e+00,4.724e-04,1.263e-02,1.844e-02,4.431e+01,1.503e-02,4.010e-04,2.038e-06,4.697e+00,9.380e-04,7.623e-04,7.159e-03,4.778e+00,1.821e-02,3.029e-03,8.621e-02,2.695e+01,5.876e-02,4.331e-02,3.101e-02,1.578e+01,3.382e-02,2.719e-02,7.981e-07,1.874e-02,2.464e-02,2.602e+00,3.902e-02,3.527e-09,3.196e-03,1.229e-08,1.126e-03,2.752e+00,1.085e-03,1.544e-03,9.011e-03,4.766e-08,1.307e-14,6.597e-04,7.756e-04,7.576e-04,1.316e-02,6.297e-04,1.593e-11,5.282e-10,1.253e-03,6.641e-03,2.561e-01,2.902e-02,4.016e-06,2.613e-01,5.676e+00,1.046e+01,2.978e-01,3.447e-05,1.778e-02,3.785e+00,1.593e-01,1.708e-05,1.203e-11,8.094e-07,8.436e-09,5.897e-06,2.257e-08,6.145e-09,6.217e-09, \
        271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0
  
  
void nucsyn_lowz_yields(Abundance * RESTRICT const X,
                        double mass)
{
    Const_data_table table[]={LOWZ_YIELDS_TABLE};
    Abundance zeroZabund[76];

    double input[1]={mass};
    interpolate(table,1,75,14,input,zeroZabund,FALSE);
  
    Set_isotopic_property(X,XH1,zeroZabund[0]);
    Set_isotopic_property(X,XH2,zeroZabund[1]);
    Set_isotopic_property(X,XHe3,zeroZabund[2]);
    Set_isotopic_property(X,XHe4,zeroZabund[3]);
    Set_isotopic_property(X,XLi6,zeroZabund[4]);
    Set_isotopic_property(X,XLi7,zeroZabund[5]);
    Set_isotopic_property(X,XBe9,zeroZabund[6]);
    Set_isotopic_property(X,XB10,zeroZabund[7]);
    Set_isotopic_property(X,XB11,zeroZabund[8]);
    Set_isotopic_property(X,XC12,zeroZabund[9]);
    Set_isotopic_property(X,XC13,zeroZabund[10]);
    Set_isotopic_property(X,XN14,zeroZabund[11]);
    Set_isotopic_property(X,XN15,zeroZabund[12]);
    Set_isotopic_property(X,XO16,zeroZabund[13]);
    Set_isotopic_property(X,XO17,zeroZabund[14]);
    Set_isotopic_property(X,XO18,zeroZabund[15]);
    Set_isotopic_property(X,XF19,zeroZabund[16]);
    Set_isotopic_property(X,XNe20,zeroZabund[17]);
    Set_isotopic_property(X,XNe21,zeroZabund[18]);
    Set_isotopic_property(X,XNe22,zeroZabund[19]);
    Set_isotopic_property(X,XNa23,zeroZabund[20]);
    Set_isotopic_property(X,XMg24,zeroZabund[21]);
    Set_isotopic_property(X,XMg25,zeroZabund[22]);
    Set_isotopic_property(X,XMg26,zeroZabund[23]);
    Set_isotopic_property(X,XAl27,zeroZabund[24]);
    Set_isotopic_property(X,XSi28,zeroZabund[25]);
    Set_isotopic_property(X,XSi29,zeroZabund[26]);
    Set_isotopic_property(X,XSi30,zeroZabund[27]);
    Set_isotopic_property(X,XP31,zeroZabund[28]);
    Set_isotopic_property(X,XS32,zeroZabund[29]);
    Set_isotopic_property(X,XS33,zeroZabund[30]);
    Set_isotopic_property(X,XS34,zeroZabund[31]);
    Set_isotopic_property(X,XS36,zeroZabund[32]);
    Set_isotopic_property(X,XCl35,zeroZabund[33]);
    Set_isotopic_property(X,XCl37,zeroZabund[34]);
    Set_isotopic_property(X,XAr36,zeroZabund[35]);
    Set_isotopic_property(X,XAr38,zeroZabund[36]);
    Set_isotopic_property(X,XAr40,zeroZabund[37]);
    Set_isotopic_property(X,XK39,zeroZabund[38]);
    Set_isotopic_property(X,XK40,zeroZabund[39]);
    Set_isotopic_property(X,XK41,zeroZabund[40]);
    Set_isotopic_property(X,XCa40,zeroZabund[41]);
    Set_isotopic_property(X,XCa42,zeroZabund[42]);
    Set_isotopic_property(X,XCa43,zeroZabund[43]);
    Set_isotopic_property(X,XCa44,zeroZabund[44]);
    Set_isotopic_property(X,XCa46,zeroZabund[45]);
    Set_isotopic_property(X,XCa48,zeroZabund[46]);
    Set_isotopic_property(X,XSc45,zeroZabund[47]);
    Set_isotopic_property(X,XTi46,zeroZabund[48]);
    Set_isotopic_property(X,XTi47,zeroZabund[49]);
    Set_isotopic_property(X,XTi48,zeroZabund[50]);
    Set_isotopic_property(X,XTi49,zeroZabund[51]);
    Set_isotopic_property(X,XTi50,zeroZabund[52]);
    Set_isotopic_property(X,XV50,zeroZabund[53]);
    Set_isotopic_property(X,XV51,zeroZabund[54]);
    Set_isotopic_property(X,XCr50,zeroZabund[55]);
    Set_isotopic_property(X,XCr52,zeroZabund[56]);
    Set_isotopic_property(X,XCr53,zeroZabund[57]);
    Set_isotopic_property(X,XCr54,zeroZabund[58]);
    Set_isotopic_property(X,XMn55,zeroZabund[59]);
    Set_isotopic_property(X,XFe54,zeroZabund[60]);
    Set_isotopic_property(X,XFe56,zeroZabund[61]);
    Set_isotopic_property(X,XFe57,zeroZabund[62]);
    Set_isotopic_property(X,XFe58,zeroZabund[63]);
    Set_isotopic_property(X,XCo59,zeroZabund[64]);
    Set_isotopic_property(X,XNi58,zeroZabund[65]);
    Set_isotopic_property(X,XNi60,zeroZabund[66]);
    Set_isotopic_property(X,XNi62,zeroZabund[68]);
    Set_isotopic_property(X,XNi64,zeroZabund[69]);
    Set_isotopic_property(X,XCu63,zeroZabund[70]);
    Set_isotopic_property(X,XCu65,zeroZabund[71]);
    Set_isotopic_property(X,XZn64,zeroZabund[72]);
    Set_isotopic_property(X,XZn66,zeroZabund[73]);
    Set_isotopic_property(X,XZn67,zeroZabund[74]);
 
    Set_isotopic_property(X,XZn68,zeroZabund[75]);
 
  
    //printf("Yield X=%g Y=%g C12=%g O16=%g\n",Set_isotopic_property(X,XH1],Set_isotopic_property(X,XHe4],Set_isotopic_property(X,XC12],Set_isotopic_property(X,XO16]);


  
}
#endif

