#include "../binary_c.h"
#include "nucsyn.h"
 
/* Function to output the results of nucleosynthesis calculations */

#ifdef NUCSYN

#include "nucsyn_log.h"

#ifdef NUCSYN_LOG
/* Function to output details of nucleosynthesis to a log */
void nucsyn_log(const double t,
                const double m,
                const double mc,
                double r,
                const double rc,
                const double lum,
                struct star_t * star,
                struct stardata_t *stardata,
                double lambda,
                Abundance * RESTRICT Xabund,
                const double tpagb_runtime)
{
#ifdef NUCSYN_LOGGING
#ifdef NUCSYN_J_LOG
    double corat,c12c13rat;
#endif
    static const char *nucstrings[]=NUCSYN_SHORT_ELEMENT_STRINGS;
    char headstring[20];
    snprintf(headstring,19,HEAD_STRING);
    Isotope i;

    /* if you want the headers each time, uncomment the next line */
    //stardata->common.nucsyn_log_count=0;
    if(stardata->common.nucsyn_log_count==0)
    {

        /* First time setup */
        /*indices[0]=XH1;  zz[0]=1; nn[0]=0;
          indices[1]=XHe4; zz[1]=2; nn[1]=2;
          indices[2]=XC12; zz[2]=6; nn[2]=6;
          indices[3]=XN14; zz[3]=7; nn[3]=7;
          indices[4]=XO16; zz[4]=8; nn[4]=8;
          indices[5]=XN13; zz[5]=7; nn[5]=6;
          indices[6]=XC13; zz[6]=6; nn[6]=7;
          indices[7]=XO15; zz[7]=8; nn[7]=7;
          indices[8]=XN15; zz[8]=7; nn[8]=8;
          indices[9]=XO17; zz[9]=8; nn[9]=9;
          indices[10]=XF17; zz[10]=9; nn[10]=8;
          indices[11]=XNe22; zz[11]=10; nn[11]=12;
          indices[12]=XMg24; zz[12]=12; nn[12]=12;
        */
        fprintf(OUTPUT,"%s%-14.14s%-14.14s%-14.14s",
                HEADER,
                "#Time","Mass","Mc");
        FLUSH;

        stardata->common.nucsyn_log_count=1;
        Ordered_isotope_loop(i)
        {
            fprintf(OUTPUT,"%2.2s%-2d           ",
                    nucstrings[stardata->store->atomic_number[i]],
                    (int)(stardata->store->mnuc[i]/AMU_GRAMS+0.5)
                ); 
        }
        fprintf(OUTPUT," %-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s%-14.14s",
                "XC12/XC13","XC/XO","Rho","Temp","Lsurf","Menv","Mcnodup","R","Rc","Lambda","log10dMcnodup","Mdot","MiraPeriod","R_eff","T_ip","AGBruntime","Timestep","NC12/NC13","NC/NO","NTP","DNTP");
        fprintf(OUTPUT,"\n");
    }
 
    if(star->stellar_type==TPAGB)
    {
        /* HEADER, Time, mass etc. */
        fprintf(OUTPUT,"%s %8e  %8e  %8e  ",
                HEADER,
                t,m,mc);
        
        Ordered_isotope_loop(i)
        {
            /* loop over isotopes giving output */
            fprintf(OUTPUT," %8e  ",
                    ABUND(i));
        }
 
        /* Ratios are exceptions */
        fprintf(OUTPUT,"%8e  %8e  ",XRATIO(XC12,XC13),XCORATIO);

        if(lambda<TINY)
        {
            lambda=star->prevlambda;
        }
        else
        {
            star->prevlambda=lambda;
        }
        
        if(r<TINY)
        {
            r=star->prevr;
        }
        else
        {
            star->prevr=r;
        }

        
        /* Output physical state of the star */
        double mdot = calc_stellar_wind_mass_loss(TPAGB,
                                                  lum,
                                                  r,
                                                  m,
                                                  mc,
                                                  r*10000,
                                                  stardata->common.metallicity,
                                                  0.0,
                                                  stardata,
                                                  star->starnum);
        fprintf(OUTPUT,"%8e  ",star->rho);
        fprintf(OUTPUT,"%8e  ", star->temp);
        fprintf(OUTPUT,"%8e  ",lum);//498
        fprintf(OUTPUT,"%8e  ",m - mc);
        fprintf(OUTPUT,"%8e  ",star->core_mass_no_3dup);//500
        fprintf(OUTPUT,"%8e  ",r);
        fprintf(OUTPUT,"%8e  ",rc);
        fprintf(OUTPUT,"%8e  ",star->lambda_3dup);//502
        fprintf(OUTPUT,"%8e  ",log10(star->core_mass_no_3dup-star->mc_1tp+TINY) /* dmcnodup */);
        fprintf(OUTPUT,"%8e  ",mdot);
        fprintf(OUTPUT,"%8e  ",star->mira);//505
        fprintf(OUTPUT,"%8e  ",star->radius);
        fprintf(OUTPUT,"%8e  ",star->interpulse_period);
        fprintf(OUTPUT,"%8e  ",tpagb_runtime);
        fprintf(OUTPUT,"%8e  ",stardata->model.dt); //508
        
        /* number ratios this time! */
        fprintf(OUTPUT,"%8e  %8e  ",
                NRATIO(XC12,XC13),
                NCORATIO);

        fprintf(OUTPUT,"%8e  ",star->num_thermal_pulses);//511
        fprintf(OUTPUT,"%8e  ",star->dntp); //512

        fprintf(OUTPUT,"\n");
        FLUSH;
    }

#endif /* NUCSYN_LOGGING */
}
#endif /* NUCSYN_LOG */ 
/* undef these just in case they are used elsewhere */
#undef OUTPUT
#undef HEADER
#undef NUM_INDICES

#endif /* NUCSYN */
