#include "nucsyn.h"

#ifdef NUCSYN
Constant_function double nucsyn_lamaxf(double m,
                                const Abundance z,
                                const struct star_t *star,
                                const struct stardata_t *stardata
    )
     
{
/*
 * Asymptotic value of dredge-up parameter lambda, according to the fitting
 * formula by Amanda Karakas (for non-overshooting models!).
 */


    double l=0.0;
#ifdef THIRD_DREDGE_UP_KARAKAS2002

    /* 
     * Maximum dredge-up parameter (asymptotic value) as a function
     * of total mass M and metallicity Z.
     *  Fitting formula from Karakas, Lattanzio & Pols 2002.
     */
    m=Max(1.0,m);/* only valid for m>1.0 */
    m=Min(6.5,m);/* and for m<~6.5 */

#define ASIZE 4

/*
 * Asymptotic value of dredge-up parameter lambda, according to the fitting
 * formula by Amanda Karakas (for non-overshooting models!). NB: the
 * Z-dependence has not yet been included, m is the mass at the beginning of
 * the AGB (NOT the current mass!)
 */

    const double zz1 = 0.02;
    const double zz2 = 0.008; 
    const double zz3 = 0.004;
    const double zz4 = 0.0001;
    double h1,h2;
    const double a1[ASIZE] = {-1.17696,0.76262,0.026028,0.041019}; 
    const double a2[ASIZE] = {-0.609465,0.55430,0.056878,0.069227}; 
    const double a3[ASIZE] = {-0.764199,0.70859,0.058833,0.075921};
    //const double a4[ASIZE] = {-0.82367052137017,0.855045797056254,0.075969726978165,0.094591645793495};
  
    /* better fit from Rob */
    //const double a4[ASIZE] = {-8.90480e-01,8.84020e-01,1.12030e-01,1.41860e-01};

    /* new fit based on Amanda's new "radius tables":
     *  This is a smoother transition from amanda's functions to the newer fit
     * and neglects her pulses which have lambda>1.1 (the 'degenerate' pulses - I guess!)
     */
    const double a4[ASIZE]={-5.62410e-01,7.32720e-01,1.63250e-02,3.45080e-02};

    double a[ASIZE];
    double zz = z; //log10(z/0.02);
    unsigned int i;

    zz=z;
    if(zz>zz2) 
    {
        h1 = (zz-zz2)/(zz1-zz2);
        h2 = 1.0 - h1;
        for(i=0;i<ASIZE;i++)
        {
            a[i] = a1[i]*h1 + a2[i]*h2;
        }
    }
    else if(zz>zz3)
    {
        h1 = (zz-zz3)/(zz2-zz3);
        h2 = 1.0 - h1;
        for(i=0;i<ASIZE;i++)
        {
            a[i] = a2[i]*h1 + a3[i]*h2;
        }
    }
    else
    {
        h1 = (zz-zz4)/(zz3-zz4);
        h2 = 1.0 - h1;
        for(i=0;i<ASIZE;i++)
        {
            a[i] = a3[i]*h1 + a4[i]*h2;
        }
    }

    double m3=Pow3(m);

    l = (a[0] + a[1]*m + a[2]*m3)/(1.0 + a[3]*m3);
    
    // limit lambda to 0<lambda<1 - none of amanda's models go outside this
    // range.
    l = Max(0.0,Min(1.0,l));
    l*=stardata->preferences->lambda_multiplier;


#undef ASIZE
#endif //THIRD_DREDGE_UP_KARAKAS2002
    return (l);
}
#endif //NUCSYN
