#pragma once
#ifndef NUCSYN_FUNCTION_MACROS_H
#define NUCSYN_FUNCTION_MACROS_H
#ifdef NUCSYN
/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES
 *
 *
 * This file contains function macros used for nucleosynthesis.
 */

/*
 * Observed surface abundance 
 */
#define Observed_surface(S)                     \
    ((S)->dmacc>TINY ? &((S)->Xacc[0]) : &((S)->Xenv[0]))

/*
 * Observed surface abundance of isotope I
 * in star S
 */
#define Observed_abundance(S,I)                 \
    (*(Observed_surface(S)+(int)I))


/* define conditions for burning of the dredge-up material */
#define Third_dredge_up_burning_conditions(TEMP,DENS)           \
    ((TEMP >= T_MIN_HBB) &&                                     \
     (DENS >= RHO_MIN_HBB) &&                                   \
     (m0 > nucsyn_mhbbmin(stardata->common.metallicity) ||      \
      stardata->common.metallicity <= 0.004))
/* or NEVER dup burn */
//#define Third_dredge_up_burning_conditions(A,B) (1==0)



/*
 * Define an expression that is true if hbb should occur, otherwise it's false
 */
#define HBB_Conditions(T,RHO,MENV,MZERO)        \
    (                                           \
        (T) >= (T_MIN_HBB) &&                   \
        (RHO) >= (RHO_MIN_HBB) &&               \
        (MENV) > 0.2*(MZERO)                    \
        )

/* Logging command */
#ifdef NUCSYN_LOG

#ifndef NUCSYN_THIRD_DREDGE_UP
#define __LAMBDA 0.0
#else
#define __LAMBDA (stardata->star[0].lambda_3dup)
#endif

#define Log_nucsyn(C,A,B,D) \
    nucsyn_log(                                 \
        (A),                                    \
        *mt,                                    \
        *mc,                                    \
        *r,                                     \
        *rc,                                    \
        *lum,                                   \
        newstar,                                \
        stardata,                               \
        (__LAMBDA),                             \
        (B),                                    \
        D);
#else
#define Log_nucsyn(C,A,B,D) /* */
#endif


/* macro for timescale against proton capture */
#define Nuclear_burning_timescale(A) (invNH1/sigmav[(A)])
#define Inverse_nuclear_burning_timescale(A) (sigmav[(A)]/invNH1)



#endif // NUCSYN
#endif // NUCSYN_FUNCTION_MACROS_H
