#include "nucsyn.h"

#ifdef NUCSYN

double Pure_function nucsyn_envelope_mass(const struct star_t * RESTRICT const star)
{
    /*
     * Return the envelope mass through which thermohaline mixing
     * should occur. The mixing is into star 
     */
  
    if(star->stellar_type <= 1)
    {
        return star->mass;
    }
    else if(star->stellar_type>=HeWD)
    {
        return 0.0;
    }
    else
    {
        return star->mass - star->core_mass;
    }
}


#endif
