#ifndef NUCSYN_ENSEMBLE_H
#define NUCSYN_ENSEMBLE_H

/*
 * The GCE/nucsyn ensemble types.
 *
 * See nucsyn_ensemble_log.c for details
 */

#define NUCSYN_ENSEMBLE_WNL 0
#define NUCSYN_ENSEMBLE_WNE 1
#define NUCSYN_ENSEMBLE_WC 2
#define NUCSYN_ENSEMBLE_WO 3
#define NUCSYN_ENSEMBLE_RSG 4
#define NUCSYN_ENSEMBLE_ISG 5
#define NUCSYN_ENSEMBLE_BSG 6
#define NUCSYN_ENSEMBLE_SN_IA_He 7
#define NUCSYN_ENSEMBLE_SN_IA_ELD 8
#define NUCSYN_ENSEMBLE_SN_IA_CHAND 9
#define NUCSYN_ENSEMBLE_SN_AIC 10
#define NUCSYN_ENSEMBLE_SN_IA_He_Coal 11
#define NUCSYN_ENSEMBLE_SN_IA_CHAND_Coal 12
#define NUCSYN_ENSEMBLE_SN_IBC 13
#define NUCSYN_ENSEMBLE_SN_II 14
#define NUCSYN_ENSEMBLE_SN_IIa 15

// integrated luminosities
#define NUCSYN_ENSEMBLE_WNL_LUM 16
#define NUCSYN_ENSEMBLE_WNE_LUM 17
#define NUCSYN_ENSEMBLE_WC_LUM 18
#define NUCSYN_ENSEMBLE_WO_LUM 19
#define NUCSYN_ENSEMBLE_RSG_LUM 20
#define NUCSYN_ENSEMBLE_ISG_LUM 21
#define NUCSYN_ENSEMBLE_BSG_LUM 22

/* stellar type counts : note these MUST be in order! */
#define NUCSYN_ENSEMBLE_NUMBER_OF_STARS 23
#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_STARS 24

#define NUCSYN_ENSEMBLE_LMMS 25
#define NUCSYN_ENSEMBLE_LMMS_LUM 26
#define NUCSYN_ENSEMBLE_MS 27
#define NUCSYN_ENSEMBLE_MS_LUM 28
#define NUCSYN_ENSEMBLE_HG 29
#define NUCSYN_ENSEMBLE_HG_LUM 30
#define NUCSYN_ENSEMBLE_GB 31
#define NUCSYN_ENSEMBLE_GB_LUM 32
#define NUCSYN_ENSEMBLE_CHeB 33
#define NUCSYN_ENSEMBLE_CHeB_LUM 34
#define NUCSYN_ENSEMBLE_EAGB 35
#define NUCSYN_ENSEMBLE_EAGB_LUM 36
#define NUCSYN_ENSEMBLE_TPAGB 37
#define NUCSYN_ENSEMBLE_TPAGB_LUM 38
#define NUCSYN_ENSEMBLE_HeMS 39
#define NUCSYN_ENSEMBLE_HeMS_LUM 40
#define NUCSYN_ENSEMBLE_HeHG 41
#define NUCSYN_ENSEMBLE_HeHG_LUM 42
#define NUCSYN_ENSEMBLE_HeGB 43
#define NUCSYN_ENSEMBLE_HeGB_LUM 44
#define NUCSYN_ENSEMBLE_HeWD 45
#define NUCSYN_ENSEMBLE_HeWD_LUM 46
#define NUCSYN_ENSEMBLE_COWD 47
#define NUCSYN_ENSEMBLE_COWD_LUM 48
#define NUCSYN_ENSEMBLE_ONeWD 49
#define NUCSYN_ENSEMBLE_ONeWD_LUM 50
#define NUCSYN_ENSEMBLE_NS 51
#define NUCSYN_ENSEMBLE_NS_LUM 52
#define NUCSYN_ENSEMBLE_BH 53
#define NUCSYN_ENSEMBLE_BH_LUM 54
#define NUCSYN_ENSEMBLE_MASSLESS_REMNANT 55
#define NUCSYN_ENSEMBLE_MASSLESS_REMNANT_LUM 56

/* GRB progenitors */
#define NUCSYN_ENSEMBLE_GRB_NS_NS 57
#define NUCSYN_ENSEMBLE_GRB_COLLAPSAR 58

/* X-ray binaries */
#define NUCSYN_ENSEMBLE_XRAY_LMXB 59
#define NUCSYN_ENSEMBLE_XRAY_LMXB_LUM 60
#define NUCSYN_ENSEMBLE_XRAY_WDXB 61
#define NUCSYN_ENSEMBLE_XRAY_WDXB_LUM 62
#define NUCSYN_ENSEMBLE_XRAY_HMXB 63
#define NUCSYN_ENSEMBLE_XRAY_HMXB_LUM 64

/* spectral types */
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_O 65
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_O_LUM 66
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_B 67
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_B_LUM 68
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_A 69
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_A_LUM 70
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_F 71
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_F_LUM 72
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_G 73
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_G_LUM 74
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_K 75
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_K_LUM 76
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_M 77
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_M_LUM 78
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_C 79
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_C_LUM 80
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_S 81
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_S_LUM 82
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Tc 83
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Tc_LUM 84
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Ba 85
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Ba_LUM 86
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_WR 87
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_WR_LUM 88
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_R 108
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_R_LUM 109 
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_DWARF_C 112
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_DWARF_C_LUM 113
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_GIANT_C 114
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_GIANT_C_LUM 115
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_J 116
#define NUCSYN_ENSEMBLE_SPECTRAL_TYPE_J_LUM 117

/* special types of stellar system */
#define NUCSYN_ENSEMBLE_WDWD_DD 89
#define NUCSYN_ENSEMBLE_WDNS_DD 90
#define NUCSYN_ENSEMBLE_WDBH_DD 91
#define NUCSYN_ENSEMBLE_NSNS_DD 92
#define NUCSYN_ENSEMBLE_NSBH_DD 93
#define NUCSYN_ENSEMBLE_BHBH_DD 94
#define NUCSYN_ENSEMBLE_CLASSICAL_CV 95
#define NUCSYN_ENSEMBLE_GK_PER_CV 96
#define NUCSYN_ENSEMBLE_SYMBIOTIC_CV 97
#define NUCSYN_ENSEMBLE_SDB 98
#define NUCSYN_ENSEMBLE_PRE_ALGOL 99
#define NUCSYN_ENSEMBLE_MS_ALGOL 100
#define NUCSYN_ENSEMBLE_COLD_ALGOL 101
#define NUCSYN_ENSEMBLE_HOT_ALGOL 102
#define NUCSYN_ENSEMBLE_BLUE_STRAGGLER 103
#define NUCSYN_ENSEMBLE_LOW_MASS_He_WD 104
#define NUCSYN_ENSEMBLE_LOW_MASS_CO_WD 105
#define NUCSYN_ENSEMBLE_D_TYPE_SYMBIOTIC 106
#define NUCSYN_ENSEMBLE_S_TYPE_SYMBIOTIC 107
#define NUCSYN_ENSEMBLE_LBV 110
#define NUCSYN_ENSEMBLE_LBV_LUM 111


#define NUCSYN_ENSEMBLE_MASS_IN_STARS 118

/* count for single stars, binary stars, disrupted and merged binaries */
#define NUCSYN_ENSEMBLE_NUMBER_OF_SINGLE_STARS 119
#define NUCSYN_ENSEMBLE_NUMBER_OF_BINARY_STARS 120
#define NUCSYN_ENSEMBLE_NUMBER_OF_DISRUPTED_BINARIES 121 
#define NUCSYN_ENSEMBLE_NUMBER_OF_MERGED_BINARIES 122 
#define NUCSYN_ENSEMBLE_NUMBER_OF_RUNAWAY_STARS 131

#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_SINGLE_STARS 123
#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_BINARY_STARS 124
#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_DISRUPTED_BINARIES 125
#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_MERGED_BINARIES 126
#define NUCSYN_ENSEMBLE_LUMINOSITY_OF_RUNAWAY_STARS 132

#define NUCSYN_ENSEMBLE_MASS_IN_SINGLE_STARS 127
#define NUCSYN_ENSEMBLE_MASS_IN_BINARY_STARS 128
#define NUCSYN_ENSEMBLE_MASS_IN_DISRUPTED_BINARIES 129
#define NUCSYN_ENSEMBLE_MASS_IN_MERGED_BINARIES 130
#define NUCSYN_ENSEMBLE_MASS_IN_RUNAWAY_STARS 133

/* detached comenvs */
#define NUCSYN_ENSEMBLE_COMENV_HG_DETACHED 134
#define NUCSYN_ENSEMBLE_COMENV_GB_DETACHED 135
#define NUCSYN_ENSEMBLE_COMENV_CHeB_DETACHED 136
#define NUCSYN_ENSEMBLE_COMENV_EAGB_DETACHED 137
#define NUCSYN_ENSEMBLE_COMENV_TPAGB_DETACHED 138
#define NUCSYN_ENSEMBLE_COMENV_HeHG_DETACHED 139
#define NUCSYN_ENSEMBLE_COMENV_HeGB_DETACHED 140

/* merged comenvs */
#define NUCSYN_ENSEMBLE_COMENV_HG_MERGER 141
#define NUCSYN_ENSEMBLE_COMENV_GB_MERGER 142
#define NUCSYN_ENSEMBLE_COMENV_CHeB_MERGER 143
#define NUCSYN_ENSEMBLE_COMENV_EAGB_MERGER 144
#define NUCSYN_ENSEMBLE_COMENV_TPAGB_MERGER 145
#define NUCSYN_ENSEMBLE_COMENV_HeHG_MERGER 146
#define NUCSYN_ENSEMBLE_COMENV_HeGB_MERGER 147

/* total merger and detached rate */
#define NUCSYN_ENSEMBLE_COMENV_MERGER 148
#define NUCSYN_ENSEMBLE_COMENV_DETACHED 149

// 150 is empty

#define NUCSYN_ENSEMBLE_FK_COMAE 151

/* stellar colours */
#define NUCSYN_ENSEMBLE_MAGNITUDE_U 152 
#define NUCSYN_ENSEMBLE_MAGNITUDE_B 153
#define NUCSYN_ENSEMBLE_MAGNITUDE_V 154
#define NUCSYN_ENSEMBLE_MAGNITUDE_R 155
#define NUCSYN_ENSEMBLE_MAGNITUDE_I 156
#define NUCSYN_ENSEMBLE_MAGNITUDE_J 157
#define NUCSYN_ENSEMBLE_MAGNITUDE_H 158
#define NUCSYN_ENSEMBLE_MAGNITUDE_K 159
#define NUCSYN_ENSEMBLE_MAGNITUDE_u 160
#define NUCSYN_ENSEMBLE_MAGNITUDE_g 161
#define NUCSYN_ENSEMBLE_MAGNITUDE_r 162
#define NUCSYN_ENSEMBLE_MAGNITUDE_i 163
#define NUCSYN_ENSEMBLE_MAGNITUDE_z 164
#define NUCSYN_ENSEMBLE_MAGNITUDE_f300w 165
#define NUCSYN_ENSEMBLE_MAGNITUDE_f336w 166
#define NUCSYN_ENSEMBLE_MAGNITUDE_f435w 167
#define NUCSYN_ENSEMBLE_MAGNITUDE_f450w 168
#define NUCSYN_ENSEMBLE_MAGNITUDE_f555w 169
#define NUCSYN_ENSEMBLE_MAGNITUDE_f606w 170
#define NUCSYN_ENSEMBLE_MAGNITUDE_f814w 171
#define NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_G 172
#define NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GBP 173
#define NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GRP 174
#define NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GRVS 175

#define NUCSYN_ENSEMBLE_BINARY_BLUE_STRAGGLER 176
#define NUCSYN_ENSEMBLE_SINGLE_BLUE_STRAGGLER 177

#define NUCSYN_ENSEMBLE_NUMBER_OF_OBSERVABLE_SINGLE_STARS 178
#define NUCSYN_ENSEMBLE_NUMBER_OF_OBSERVABLE_BINARY_STARS 179

#define NUCSYN_ENSEMBLE_MERGER_INTO_LMMS 180
#define NUCSYN_ENSEMBLE_MERGER_INTO_MS 181
#define NUCSYN_ENSEMBLE_MERGER_INTO_HG 182
#define NUCSYN_ENSEMBLE_MERGER_INTO_GB 183
#define NUCSYN_ENSEMBLE_MERGER_INTO_CHeB 184
#define NUCSYN_ENSEMBLE_MERGER_INTO_EAGB 185
#define NUCSYN_ENSEMBLE_MERGER_INTO_TPAGB 186
#define NUCSYN_ENSEMBLE_MERGER_INTO_HeMS 187
#define NUCSYN_ENSEMBLE_MERGER_INTO_HeHG 188
#define NUCSYN_ENSEMBLE_MERGER_INTO_HeGB 189
#define NUCSYN_ENSEMBLE_MERGER_INTO_HeWD 190
#define NUCSYN_ENSEMBLE_MERGER_INTO_COWD 191
#define NUCSYN_ENSEMBLE_MERGER_INTO_ONeWD 192
#define NUCSYN_ENSEMBLE_MERGER_INTO_NS 193
#define NUCSYN_ENSEMBLE_MERGER_INTO_BH 194
#define NUCSYN_ENSEMBLE_MERGER_INTO_MASSLESS_REMNANT 195

/*
 * Collision matrix : these are set by
 * ./src/perl/scripts/make_merger_ensemble.pl  
 */

#define NUCSYN_ENSEMBLE_MERGER_LMMS_LMMS 196
#define NUCSYN_ENSEMBLE_MERGER_MS_LMMS 197
#define NUCSYN_ENSEMBLE_MERGER_HG_LMMS 198
#define NUCSYN_ENSEMBLE_MERGER_GB_LMMS 199
#define NUCSYN_ENSEMBLE_MERGER_CHeB_LMMS 200
#define NUCSYN_ENSEMBLE_MERGER_EAGB_LMMS 201
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_LMMS 202
#define NUCSYN_ENSEMBLE_MERGER_HeMS_LMMS 203
#define NUCSYN_ENSEMBLE_MERGER_HeHG_LMMS 204
#define NUCSYN_ENSEMBLE_MERGER_HeGB_LMMS 205
#define NUCSYN_ENSEMBLE_MERGER_HeWD_LMMS 206
#define NUCSYN_ENSEMBLE_MERGER_COWD_LMMS 207
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_LMMS 208
#define NUCSYN_ENSEMBLE_MERGER_NS_LMMS 209
#define NUCSYN_ENSEMBLE_MERGER_BH_LMMS 210
#define NUCSYN_ENSEMBLE_MERGER_MS_MS 211
#define NUCSYN_ENSEMBLE_MERGER_HG_MS 212
#define NUCSYN_ENSEMBLE_MERGER_GB_MS 213
#define NUCSYN_ENSEMBLE_MERGER_CHeB_MS 214
#define NUCSYN_ENSEMBLE_MERGER_EAGB_MS 215
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_MS 216
#define NUCSYN_ENSEMBLE_MERGER_HeMS_MS 217
#define NUCSYN_ENSEMBLE_MERGER_HeHG_MS 218
#define NUCSYN_ENSEMBLE_MERGER_HeGB_MS 219
#define NUCSYN_ENSEMBLE_MERGER_HeWD_MS 220
#define NUCSYN_ENSEMBLE_MERGER_COWD_MS 221
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_MS 222
#define NUCSYN_ENSEMBLE_MERGER_NS_MS 223
#define NUCSYN_ENSEMBLE_MERGER_BH_MS 224
#define NUCSYN_ENSEMBLE_MERGER_HG_HG 225
#define NUCSYN_ENSEMBLE_MERGER_GB_HG 226
#define NUCSYN_ENSEMBLE_MERGER_CHeB_HG 227
#define NUCSYN_ENSEMBLE_MERGER_EAGB_HG 228
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_HG 229
#define NUCSYN_ENSEMBLE_MERGER_HeMS_HG 230
#define NUCSYN_ENSEMBLE_MERGER_HeHG_HG 231
#define NUCSYN_ENSEMBLE_MERGER_HeGB_HG 232
#define NUCSYN_ENSEMBLE_MERGER_HeWD_HG 233
#define NUCSYN_ENSEMBLE_MERGER_COWD_HG 234
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_HG 235
#define NUCSYN_ENSEMBLE_MERGER_NS_HG 236
#define NUCSYN_ENSEMBLE_MERGER_BH_HG 237
#define NUCSYN_ENSEMBLE_MERGER_GB_GB 238
#define NUCSYN_ENSEMBLE_MERGER_CHeB_GB 239
#define NUCSYN_ENSEMBLE_MERGER_EAGB_GB 240
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_GB 241
#define NUCSYN_ENSEMBLE_MERGER_HeMS_GB 242
#define NUCSYN_ENSEMBLE_MERGER_HeHG_GB 243
#define NUCSYN_ENSEMBLE_MERGER_HeGB_GB 244
#define NUCSYN_ENSEMBLE_MERGER_HeWD_GB 245
#define NUCSYN_ENSEMBLE_MERGER_COWD_GB 246
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_GB 247
#define NUCSYN_ENSEMBLE_MERGER_NS_GB 248
#define NUCSYN_ENSEMBLE_MERGER_BH_GB 249
#define NUCSYN_ENSEMBLE_MERGER_CHeB_CHeB 250
#define NUCSYN_ENSEMBLE_MERGER_EAGB_CHeB 251
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_CHeB 252
#define NUCSYN_ENSEMBLE_MERGER_HeMS_CHeB 253
#define NUCSYN_ENSEMBLE_MERGER_HeHG_CHeB 254
#define NUCSYN_ENSEMBLE_MERGER_HeGB_CHeB 255
#define NUCSYN_ENSEMBLE_MERGER_HeWD_CHeB 256
#define NUCSYN_ENSEMBLE_MERGER_COWD_CHeB 257
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_CHeB 258
#define NUCSYN_ENSEMBLE_MERGER_NS_CHeB 259
#define NUCSYN_ENSEMBLE_MERGER_BH_CHeB 260
#define NUCSYN_ENSEMBLE_MERGER_EAGB_EAGB 261
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_EAGB 262
#define NUCSYN_ENSEMBLE_MERGER_HeMS_EAGB 263
#define NUCSYN_ENSEMBLE_MERGER_HeHG_EAGB 264
#define NUCSYN_ENSEMBLE_MERGER_HeGB_EAGB 265
#define NUCSYN_ENSEMBLE_MERGER_HeWD_EAGB 266
#define NUCSYN_ENSEMBLE_MERGER_COWD_EAGB 267
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_EAGB 268
#define NUCSYN_ENSEMBLE_MERGER_NS_EAGB 269
#define NUCSYN_ENSEMBLE_MERGER_BH_EAGB 270
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_TPAGB 271
#define NUCSYN_ENSEMBLE_MERGER_HeMS_TPAGB 272
#define NUCSYN_ENSEMBLE_MERGER_HeHG_TPAGB 273
#define NUCSYN_ENSEMBLE_MERGER_HeGB_TPAGB 274
#define NUCSYN_ENSEMBLE_MERGER_HeWD_TPAGB 275
#define NUCSYN_ENSEMBLE_MERGER_COWD_TPAGB 276
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_TPAGB 277
#define NUCSYN_ENSEMBLE_MERGER_NS_TPAGB 278
#define NUCSYN_ENSEMBLE_MERGER_BH_TPAGB 279
#define NUCSYN_ENSEMBLE_MERGER_HeMS_HeMS 280
#define NUCSYN_ENSEMBLE_MERGER_HeHG_HeMS 281
#define NUCSYN_ENSEMBLE_MERGER_HeGB_HeMS 282
#define NUCSYN_ENSEMBLE_MERGER_HeWD_HeMS 283
#define NUCSYN_ENSEMBLE_MERGER_COWD_HeMS 284
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_HeMS 285
#define NUCSYN_ENSEMBLE_MERGER_NS_HeMS 286
#define NUCSYN_ENSEMBLE_MERGER_BH_HeMS 287
#define NUCSYN_ENSEMBLE_MERGER_HeHG_HeHG 288
#define NUCSYN_ENSEMBLE_MERGER_HeGB_HeHG 289
#define NUCSYN_ENSEMBLE_MERGER_HeWD_HeHG 290
#define NUCSYN_ENSEMBLE_MERGER_COWD_HeHG 291
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_HeHG 292
#define NUCSYN_ENSEMBLE_MERGER_NS_HeHG 293
#define NUCSYN_ENSEMBLE_MERGER_BH_HeHG 294
#define NUCSYN_ENSEMBLE_MERGER_HeGB_HeGB 295
#define NUCSYN_ENSEMBLE_MERGER_HeWD_HeGB 296
#define NUCSYN_ENSEMBLE_MERGER_COWD_HeGB 297
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_HeGB 298
#define NUCSYN_ENSEMBLE_MERGER_NS_HeGB 299
#define NUCSYN_ENSEMBLE_MERGER_BH_HeGB 300
#define NUCSYN_ENSEMBLE_MERGER_HeWD_HeWD 301
#define NUCSYN_ENSEMBLE_MERGER_COWD_HeWD 302
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_HeWD 303
#define NUCSYN_ENSEMBLE_MERGER_NS_HeWD 304
#define NUCSYN_ENSEMBLE_MERGER_BH_HeWD 305
#define NUCSYN_ENSEMBLE_MERGER_COWD_COWD 306
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_COWD 307
#define NUCSYN_ENSEMBLE_MERGER_NS_COWD 308
#define NUCSYN_ENSEMBLE_MERGER_BH_COWD 309
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_ONeWD 310
#define NUCSYN_ENSEMBLE_MERGER_NS_ONeWD 311
#define NUCSYN_ENSEMBLE_MERGER_BH_ONeWD 312
#define NUCSYN_ENSEMBLE_MERGER_NS_NS 313
#define NUCSYN_ENSEMBLE_MERGER_BH_NS 314
#define NUCSYN_ENSEMBLE_MERGER_BH_BH 315
#define NUCSYN_ENSEMBLE_DAVIES_RSG 316
#define NUCSYN_ENSEMBLE_DAVIES_RSG_LUM 317
#define NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p8 318
#define NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p7  319
#define NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p6  320
#define NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p5  321
#define NUCSYN_ENSEMBLE_PERETS_HeWD_ONeWD  322
#define NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p8 323        
#define NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p7 324        
#define NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p6 325        
#define NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p5 326        
#define NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_ONeWD 327             
#define NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p8 328       
#define NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p7 329       
#define NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p6 330       
#define NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p5 331       
#define NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_ONeWD 332
#define NUCSYN_ENSEMBLE_AMCVN 333
#define NUCSYN_ENSEMBLE_SDO 334
#define NUCSYN_ENSEMBLE_SN_TZ 335
#define NUCSYN_ENSEMBLE_SN_AIC_BH 336
#define NUCSYN_ENSEMBLE_SN_BH_NS 337
#define NUCSYN_ENSEMBLE_SN_BH_BH 338
#define NUCSYN_ENSEMBLE_TEST_COUNT 339
#define NUCSYN_ENSEMBLE_TEST_RATE 340
#define NUCSYN_ENSEMBLE_WIND_KINETIC_POWER 341
#define NUCSYN_ENSEMBLE_WIND_RSG_KINETIC_POWER 342
#define NUCSYN_ENSEMBLE_WIND_ISG_KINETIC_POWER 343
#define NUCSYN_ENSEMBLE_WIND_BSG_KINETIC_POWER 344
#define NUCSYN_ENSEMBLE_WIND_WOLF_RAYET_KINETIC_POWER 345
#define NUCSYN_ENSEMBLE_WIND_AGB_KINETIC_POWER 346
#define NUCSYN_ENSEMBLE_SUPERNOVA_KINETIC_POWER 347
#define NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_KINETIC_POWER 348
#define NUCSYN_ENSEMBLE_SUPERNOVA_IA_KINETIC_POWER 349
#define NUCSYN_ENSEMBLE_NOVA_KINETIC_POWER 350
#define NUCSYN_ENSEMBLE_SUPERNOVA_LUMINOSITY 351
#define NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_LUMINOSITY 352
#define NUCSYN_ENSEMBLE_SUPERNOVA_IA_LUMINOSITY 353
#define NUCSYN_ENSEMBLE_NOVA_LUMINOSITY 354
#define NUCSYN_ENSEMBLE_WIND_MOMENTUM 355
#define NUCSYN_ENSEMBLE_WIND_RSG_MOMENTUM 356
#define NUCSYN_ENSEMBLE_WIND_ISG_MOMENTUM 357
#define NUCSYN_ENSEMBLE_WIND_BSG_MOMENTUM 358
#define NUCSYN_ENSEMBLE_WIND_WOLF_RAYET_MOMENTUM 359
#define NUCSYN_ENSEMBLE_WIND_AGB_MOMENTUM 360
#define NUCSYN_ENSEMBLE_SUPERNOVA_MOMENTUM 361
#define NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_MOMENTUM 362
#define NUCSYN_ENSEMBLE_SUPERNOVA_IA_MOMENTUM 363
#define NUCSYN_ENSEMBLE_NOVA_MOMENTUM 364
#define NUCSYN_ENSEMBLE_MERGER_HeWD_gt_COWD 365
#define NUCSYN_ENSEMBLE_SN_IA_Hybrid_HeCOWD 366
#define NUCSYN_ENSEMBLE_Hybrid_HeCOWD 367
#define NUCSYN_ENSEMBLE_Hybrid_HeCOWD_LUM 368
#define NUCSYN_ENSEMBLE_MERGER_LMMS_Hybrid_HeCOWD 369
#define NUCSYN_ENSEMBLE_MERGER_MS_Hybrid_HeCOWD 370
#define NUCSYN_ENSEMBLE_MERGER_HG_Hybrid_HeCOWD 371
#define NUCSYN_ENSEMBLE_MERGER_GB_Hybrid_HeCOWD 372
#define NUCSYN_ENSEMBLE_MERGER_CHeB_Hybrid_HeCOWD 373
#define NUCSYN_ENSEMBLE_MERGER_EAGB_Hybrid_HeCOWD 374
#define NUCSYN_ENSEMBLE_MERGER_TPAGB_Hybrid_HeCOWD 375
#define NUCSYN_ENSEMBLE_MERGER_HeMS_Hybrid_HeCOWD 376
#define NUCSYN_ENSEMBLE_MERGER_HeHG_Hybrid_HeCOWD 377
#define NUCSYN_ENSEMBLE_MERGER_HeGB_Hybrid_HeCOWD 378
#define NUCSYN_ENSEMBLE_MERGER_HeWD_Hybrid_HeCOWD 379
#define NUCSYN_ENSEMBLE_MERGER_COWD_Hybrid_HeCOWD 380
#define NUCSYN_ENSEMBLE_MERGER_ONeWD_Hybrid_HeCOWD 381
#define NUCSYN_ENSEMBLE_MERGER_NS_Hybrid_HeCOWD 382
#define NUCSYN_ENSEMBLE_MERGER_BH_Hybrid_HeCOWD 383
#define NUCSYN_ENSEMBLE_MERGER_Hybrid_HeCOWD_Hybrid_HeCOWD 384
#define NUCSYN_ENSEMBLE_SN_IA_Hybrid_HeCOWD_subluminous 385
#define NUCSYN_ENSEMBLE_TZ_M1_LT8 386
#define NUCSYN_ENSEMBLE_TZ_M1_8_9 387
#define NUCSYN_ENSEMBLE_TZ_M1_9_10 388
#define NUCSYN_ENSEMBLE_TZ_M1_10_11 389
#define NUCSYN_ENSEMBLE_TZ_M1_11_12 390
#define NUCSYN_ENSEMBLE_TZ_M1_12_13 391
#define NUCSYN_ENSEMBLE_TZ_M1_13_14 392
#define NUCSYN_ENSEMBLE_TZ_M1_14_15 393
#define NUCSYN_ENSEMBLE_TZ_M1_15_16 394
#define NUCSYN_ENSEMBLE_TZ_M1_16_17 395
#define NUCSYN_ENSEMBLE_TZ_M1_17_18 396
#define NUCSYN_ENSEMBLE_TZ_M1_18_19 397
#define NUCSYN_ENSEMBLE_TZ_M1_19_20 398
#define NUCSYN_ENSEMBLE_TZ_M1_20_21 399
#define NUCSYN_ENSEMBLE_TZ_M1_21_22 400
#define NUCSYN_ENSEMBLE_TZ_M1_22_23 401
#define NUCSYN_ENSEMBLE_TZ_M1_23_24 402
#define NUCSYN_ENSEMBLE_TZ_M1_24_25 403
#define NUCSYN_ENSEMBLE_TZ_M1_25_26 404
#define NUCSYN_ENSEMBLE_TZ_M1_26_27 405
#define NUCSYN_ENSEMBLE_TZ_M1_27_28 406
#define NUCSYN_ENSEMBLE_TZ_M1_28_29 407
#define NUCSYN_ENSEMBLE_TZ_M1_29_30 408
#define NUCSYN_ENSEMBLE_TZ_M1_GT30 409





#define NUCSYN_ENSEMBLE_MERGER_MATRIX {                                 \
        {196,197,198,199,200,201,202,203,204,205,206,207,208,209,210},  \
        {197,211,212,213,214,215,216,217,218,219,220,221,222,223,224},  \
        {198,212,225,226,227,228,229,230,231,232,233,234,235,236,237},  \
        {199,213,226,238,239,240,241,242,243,244,245,246,247,248,249},  \
        {200,214,227,239,250,251,252,253,254,255,256,257,258,259,260},  \
        {201,215,228,240,251,261,262,263,264,265,266,267,268,269,270},  \
        {202,216,229,241,252,262,271,272,273,274,275,276,277,278,279},  \
        {203,217,230,242,253,263,272,280,281,282,283,284,285,286,287},  \
        {204,218,231,243,254,264,273,281,288,289,290,291,292,293,294},  \
        {205,219,232,244,255,265,274,282,289,295,296,297,298,299,300},  \
        {206,220,233,245,256,266,275,283,290,296,301,302,303,304,305},  \
        {207,221,234,246,257,267,276,284,291,297,302,306,307,308,309},  \
        {208,222,235,247,258,268,277,285,292,298,303,307,310,311,312},  \
        {209,223,236,248,259,269,278,286,293,299,304,308,311,313,314},  \
        {210,224,237,249,260,270,279,287,294,300,305,309,312,314,315}   \
    }


#define NUCSYN_ENSEMBLE_STRINGS                                         \
    "NUCSYN_ENSEMBLE_WNL", /* 0 */                                      \
        "NUCSYN_ENSEMBLE_WNE", /* 1 */                                  \
        "NUCSYN_ENSEMBLE_WC", /* 2 */                                   \
        "NUCSYN_ENSEMBLE_WO", /* 3 */                                   \
        "NUCSYN_ENSEMBLE_RSG", /* 4 */                                  \
        "NUCSYN_ENSEMBLE_ISG", /* 5 */                                  \
        "NUCSYN_ENSEMBLE_BSG", /* 6 */                                  \
        "NUCSYN_ENSEMBLE_SN_IA_He", /* 7 */                             \
        "NUCSYN_ENSEMBLE_SN_IA_ELD", /* 8 */                            \
        "NUCSYN_ENSEMBLE_SN_IA_CHAND", /* 9 */                          \
        "NUCSYN_ENSEMBLE_SN_AIC", /* 10 */                              \
        "NUCSYN_ENSEMBLE_SN_IA_He_Coal", /* 11 */                       \
        "NUCSYN_ENSEMBLE_SN_IA_CHAND_Coal", /* 12 */                    \
        "NUCSYN_ENSEMBLE_SN_IBC", /* 13 */                              \
        "NUCSYN_ENSEMBLE_SN_II", /* 14 */                               \
        "NUCSYN_ENSEMBLE_SN_IIa", /* 15 */                              \
        "NUCSYN_ENSEMBLE_WNL_LUM", /* 16 */                             \
        "NUCSYN_ENSEMBLE_WNE_LUM", /* 17 */                             \
        "NUCSYN_ENSEMBLE_WC_LUM", /* 18 */                              \
        "NUCSYN_ENSEMBLE_WO_LUM", /* 19 */                              \
        "NUCSYN_ENSEMBLE_RSG_LUM", /* 20 */                             \
        "NUCSYN_ENSEMBLE_ISG_LUM", /* 21 */                             \
        "NUCSYN_ENSEMBLE_BSG_LUM", /* 22 */                             \
        "NUCSYN_ENSEMBLE_NUMBER_OF_STARS", /* 23 */                     \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_STARS", /* 24 */                 \
        "NUCSYN_ENSEMBLE_LMMS", /* 25 */                                \
        "NUCSYN_ENSEMBLE_LMMS_LUM", /* 26 */                            \
        "NUCSYN_ENSEMBLE_MS", /* 27 */                                  \
        "NUCSYN_ENSEMBLE_MS_LUM", /* 28 */                              \
        "NUCSYN_ENSEMBLE_HG", /* 29 */                                  \
        "NUCSYN_ENSEMBLE_HG_LUM", /* 30 */                              \
        "NUCSYN_ENSEMBLE_GB", /* 31 */                                  \
        "NUCSYN_ENSEMBLE_GB_LUM", /* 32 */                              \
        "NUCSYN_ENSEMBLE_CHeB", /* 33 */                                \
        "NUCSYN_ENSEMBLE_CHeB_LUM", /* 34 */                            \
        "NUCSYN_ENSEMBLE_EAGB", /* 35 */                                \
        "NUCSYN_ENSEMBLE_EAGB_LUM", /* 36 */                            \
        "NUCSYN_ENSEMBLE_TPAGB", /* 37 */                               \
        "NUCSYN_ENSEMBLE_TPAGB_LUM", /* 38 */                           \
        "NUCSYN_ENSEMBLE_HeMS", /* 39 */                                \
        "NUCSYN_ENSEMBLE_HeMS_LUM", /* 40 */                            \
        "NUCSYN_ENSEMBLE_HeHG", /* 41 */                                \
        "NUCSYN_ENSEMBLE_HeHG_LUM", /* 42 */                            \
        "NUCSYN_ENSEMBLE_HeGB", /* 43 */                                \
        "NUCSYN_ENSEMBLE_HeGB_LUM", /* 44 */                            \
        "NUCSYN_ENSEMBLE_HeWD", /* 45 */                                \
        "NUCSYN_ENSEMBLE_HeWD_LUM", /* 46 */                            \
        "NUCSYN_ENSEMBLE_COWD", /* 47 */                                \
        "NUCSYN_ENSEMBLE_COWD_LUM", /* 48 */                            \
        "NUCSYN_ENSEMBLE_ONeWD", /* 49 */                               \
        "NUCSYN_ENSEMBLE_ONeWD_LUM", /* 50 */                           \
        "NUCSYN_ENSEMBLE_NS", /* 51 */                                  \
        "NUCSYN_ENSEMBLE_NS_LUM", /* 52 */                              \
        "NUCSYN_ENSEMBLE_BH", /* 53 */                                  \
        "NUCSYN_ENSEMBLE_BH_LUM", /* 54 */                              \
        "NUCSYN_ENSEMBLE_MASSLESS_REMNANT", /* 55 */                    \
        "NUCSYN_ENSEMBLE_MASSLESS_REMNANT_LUM", /* 56 */                \
        "NUCSYN_ENSEMBLE_GRB_NS_NS", /* 57 */                           \
        "NUCSYN_ENSEMBLE_GRB_COLLAPSAR", /* 58 */                       \
        "NUCSYN_ENSEMBLE_XRAY_LMXB", /* 59 */                           \
        "NUCSYN_ENSEMBLE_XRAY_LMXB_LUM", /* 60 */                       \
        "NUCSYN_ENSEMBLE_XRAY_WDXB", /* 61 */                           \
        "NUCSYN_ENSEMBLE_XRAY_WDXB_LUM", /* 62 */                       \
        "NUCSYN_ENSEMBLE_XRAY_HMXB", /* 63 */                           \
        "NUCSYN_ENSEMBLE_XRAY_HMXB_LUM", /* 64 */                       \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_O", /* 65 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_O_LUM", /* 66 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_B", /* 67 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_B_LUM", /* 68 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_A", /* 69 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_A_LUM", /* 70 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_F", /* 71 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_F_LUM", /* 72 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_G", /* 73 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_G_LUM", /* 74 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_K", /* 75 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_K_LUM", /* 76 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_M", /* 77 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_M_LUM", /* 78 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_C", /* 79 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_C_LUM", /* 80 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_S", /* 81 */                     \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_S_LUM", /* 82 */                 \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Tc", /* 83 */                    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Tc_LUM", /* 84 */                \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Ba", /* 85 */                    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_Ba_LUM", /* 86 */                \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_WR", /* 87 */                    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_WR_LUM", /* 88 */                \
        "NUCSYN_ENSEMBLE_WDWD_DD", /* 89 */                             \
        "NUCSYN_ENSEMBLE_WDNS_DD", /* 90 */                             \
        "NUCSYN_ENSEMBLE_WDBH_DD", /* 91 */                             \
        "NUCSYN_ENSEMBLE_NSNS_DD", /* 92 */                             \
        "NUCSYN_ENSEMBLE_NSBH_DD", /* 93 */                             \
        "NUCSYN_ENSEMBLE_BHBH_DD", /* 94 */                             \
        "NUCSYN_ENSEMBLE_CLASSICAL_CV", /* 95 */                        \
        "NUCSYN_ENSEMBLE_GK_PER_CV", /* 96 */                           \
        "NUCSYN_ENSEMBLE_SYMBIOTIC_CV", /* 97 */                        \
        "NUCSYN_ENSEMBLE_SDB", /* 98 */                                 \
        "NUCSYN_ENSEMBLE_PRE_ALGOL", /* 99 */                           \
        "NUCSYN_ENSEMBLE_MS_ALGOL", /* 100 */                           \
        "NUCSYN_ENSEMBLE_COLD_ALGOL", /* 101 */                         \
        "NUCSYN_ENSEMBLE_HOT_ALGOL", /* 102 */                          \
        "NUCSYN_ENSEMBLE_BLUE_STRAGGLER", /* 103 */                     \
        "NUCSYN_ENSEMBLE_LOW_MASS_He_WD", /* 104 */                     \
        "NUCSYN_ENSEMBLE_LOW_MASS_CO_WD", /* 105 */                     \
        "NUCSYN_ENSEMBLE_D_TYPE_SYMBIOTIC", /* 106 */                   \
        "NUCSYN_ENSEMBLE_S_TYPE_SYMBIOTIC", /* 107 */                   \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_R", /* 108 */                    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_R_LUM", /* 109 */                \
        "NUCSYN_ENSEMBLE_LBV", /* 110 */                                \
        "NUCSYN_ENSEMBLE_LBV_LUM", /* 111 */                            \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_DWARF_C", /* 112 */    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_DWARF_C_LUM", /* 113 */ \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_GIANT_C", /* 114 */    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_EXTRINSIC_GIANT_C_LUM", /* 115 */ \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_J", /* 116 */                    \
        "NUCSYN_ENSEMBLE_SPECTRAL_TYPE_J_LUM", /* 117 */                \
        "NUCSYN_ENSEMBLE_MASS_IN_STARS", /* 118 */                      \
        "NUCSYN_ENSEMBLE_NUMBER_OF_SINGLE_STARS", /* 119 */             \
        "NUCSYN_ENSEMBLE_NUMBER_OF_BINARY_STARS", /* 120 */             \
        "NUCSYN_ENSEMBLE_NUMBER_OF_DISRUPTED_BINARIES", /* 121 */       \
        "NUCSYN_ENSEMBLE_NUMBER_OF_MERGED_BINARIES", /* 122 */          \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_SINGLE_STARS", /* 123 */         \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_BINARY_STARS", /* 124 */         \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_DISRUPTED_BINARIES", /* 125 */   \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_MERGED_BINARIES", /* 126 */      \
        "NUCSYN_ENSEMBLE_MASS_IN_SINGLE_STARS", /* 127 */               \
        "NUCSYN_ENSEMBLE_MASS_IN_BINARY_STARS", /* 128 */               \
        "NUCSYN_ENSEMBLE_MASS_IN_DISRUPTED_BINARIES", /* 129 */         \
        "NUCSYN_ENSEMBLE_MASS_IN_MERGED_BINARIES", /* 130 */            \
        "NUCSYN_ENSEMBLE_NUMBER_OF_RUNAWAY_STARS", /* 131 */            \
        "NUCSYN_ENSEMBLE_LUMINOSITY_OF_RUNAWAY_STARS", /* 132 */        \
        "NUCSYN_ENSEMBLE_MASS_IN_RUNAWAY_STARS", /* 133 */              \
        "NUCSYN_ENSEMBLE_COMENV_HG_DETACHED", /* 134 */                 \
        "NUCSYN_ENSEMBLE_COMENV_GB_DETACHED", /* 135 */                 \
        "NUCSYN_ENSEMBLE_COMENV_CHeB_DETACHED", /* 136 */               \
        "NUCSYN_ENSEMBLE_COMENV_EAGB_DETACHED", /* 137 */               \
        "NUCSYN_ENSEMBLE_COMENV_TPAGB_DETACHED", /* 138 */              \
        "NUCSYN_ENSEMBLE_COMENV_HeHG_DETACHED", /* 139 */               \
        "NUCSYN_ENSEMBLE_COMENV_HeGB_DETACHED", /* 140 */               \
        "NUCSYN_ENSEMBLE_COMENV_HG_MERGER", /* 141 */                   \
        "NUCSYN_ENSEMBLE_COMENV_GB_MERGER", /* 142 */                   \
        "NUCSYN_ENSEMBLE_COMENV_CHeB_MERGER", /* 143 */                 \
        "NUCSYN_ENSEMBLE_COMENV_EAGB_MERGER", /* 144 */                 \
        "NUCSYN_ENSEMBLE_COMENV_TPAGB_MERGER", /* 145 */                \
        "NUCSYN_ENSEMBLE_COMENV_HeHG_MERGER", /* 146 */                 \
        "NUCSYN_ENSEMBLE_COMENV_HeGB_MERGER", /* 147 */                 \
        "NUCSYN_ENSEMBLE_COMENV_MERGER", /* 148 */                      \
        "NUCSYN_ENSEMBLE_COMENV_DETACHED", /* 149 */                    \
        "", /* 150 */                                                   \
        "NUCSYN_ENSEMBLE_FK_COMAE", /* 151 */                           \
        "NUCSYN_ENSEMBLE_MAGNITUDE_U", /* 152 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_B", /* 153 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_V", /* 154 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_R", /* 155 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_I", /* 156 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_J", /* 157 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_H", /* 158 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_K", /* 159 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_u", /* 160 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_g", /* 161 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_r", /* 162 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_i", /* 163 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_z", /* 164 */                        \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f300w", /* 165 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f336w", /* 166 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f435w", /* 167 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f450w", /* 168 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f555w", /* 169 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f606w", /* 170 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_f814w", /* 171 */                    \
        "NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_G", /* 172 */                   \
        "NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GBP", /* 173 */                 \
        "NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GRP", /* 174 */                 \
        "NUCSYN_ENSEMBLE_MAGNITUDE_GAIA_GRVS", /* 175 */                \
        "NUCSYN_ENSEMBLE_BINARY_BLUE_STRAGGLER", /* 176 */              \
        "NUCSYN_ENSEMBLE_SINGLE_BLUE_STRAGGLER", /* 177 */              \
        "NUCSYN_ENSEMBLE_NUMBER_OF_OBSERVABLE_SINGLE_STARS", /* 178 */  \
        "NUCSYN_ENSEMBLE_NUMBER_OF_OBSERVABLE_BINARY_STARS", /* 179 */  \
        "NUCSYN_ENSEMBLE_MERGER_INTO_LMMS", /* 180 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_MS", /* 181 */                     \
        "NUCSYN_ENSEMBLE_MERGER_INTO_HG", /* 182 */                     \
        "NUCSYN_ENSEMBLE_MERGER_INTO_GB", /* 183 */                     \
        "NUCSYN_ENSEMBLE_MERGER_INTO_CHeB", /* 184 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_EAGB", /* 185 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_TPAGB", /* 186 */                  \
        "NUCSYN_ENSEMBLE_MERGER_INTO_HeMS", /* 187 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_HeHG", /* 188 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_HeGB", /* 189 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_HeWD", /* 190 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_COWD", /* 191 */                   \
        "NUCSYN_ENSEMBLE_MERGER_INTO_ONeWD", /* 192 */                  \
        "NUCSYN_ENSEMBLE_MERGER_INTO_NS", /* 193 */                     \
        "NUCSYN_ENSEMBLE_MERGER_INTO_BH", /* 194 */                     \
        "NUCSYN_ENSEMBLE_MERGER_INTO_MASSLESS_REMNANT", /* 195 */       \
        "NUCSYN_ENSEMBLE_MERGER_LMMS_LMMS", /* 196 */                   \
        "NUCSYN_ENSEMBLE_MERGER_MS_LMMS", /* 197 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HG_LMMS", /* 198 */                     \
        "NUCSYN_ENSEMBLE_MERGER_GB_LMMS", /* 199 */                     \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_LMMS", /* 200 */                   \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_LMMS", /* 201 */                   \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_LMMS", /* 202 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_LMMS", /* 203 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_LMMS", /* 204 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_LMMS", /* 205 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_LMMS", /* 206 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_LMMS", /* 207 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_LMMS", /* 208 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_LMMS", /* 209 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_LMMS", /* 210 */                     \
        "NUCSYN_ENSEMBLE_MERGER_MS_MS", /* 211 */                       \
        "NUCSYN_ENSEMBLE_MERGER_HG_MS", /* 212 */                       \
        "NUCSYN_ENSEMBLE_MERGER_GB_MS", /* 213 */                       \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_MS", /* 214 */                     \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_MS", /* 215 */                     \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_MS", /* 216 */                    \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_MS", /* 217 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_MS", /* 218 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_MS", /* 219 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_MS", /* 220 */                     \
        "NUCSYN_ENSEMBLE_MERGER_COWD_MS", /* 221 */                     \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_MS", /* 222 */                    \
        "NUCSYN_ENSEMBLE_MERGER_NS_MS", /* 223 */                       \
        "NUCSYN_ENSEMBLE_MERGER_BH_MS", /* 224 */                       \
        "NUCSYN_ENSEMBLE_MERGER_HG_HG", /* 225 */                       \
        "NUCSYN_ENSEMBLE_MERGER_GB_HG", /* 226 */                       \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_HG", /* 227 */                     \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_HG", /* 228 */                     \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_HG", /* 229 */                    \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_HG", /* 230 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_HG", /* 231 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_HG", /* 232 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_HG", /* 233 */                     \
        "NUCSYN_ENSEMBLE_MERGER_COWD_HG", /* 234 */                     \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_HG", /* 235 */                    \
        "NUCSYN_ENSEMBLE_MERGER_NS_HG", /* 236 */                       \
        "NUCSYN_ENSEMBLE_MERGER_BH_HG", /* 237 */                       \
        "NUCSYN_ENSEMBLE_MERGER_GB_GB", /* 238 */                       \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_GB", /* 239 */                     \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_GB", /* 240 */                     \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_GB", /* 241 */                    \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_GB", /* 242 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_GB", /* 243 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_GB", /* 244 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_GB", /* 245 */                     \
        "NUCSYN_ENSEMBLE_MERGER_COWD_GB", /* 246 */                     \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_GB", /* 247 */                    \
        "NUCSYN_ENSEMBLE_MERGER_NS_GB", /* 248 */                       \
        "NUCSYN_ENSEMBLE_MERGER_BH_GB", /* 249 */                       \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_CHeB", /* 250 */                   \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_CHeB", /* 251 */                   \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_CHeB", /* 252 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_CHeB", /* 253 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_CHeB", /* 254 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_CHeB", /* 255 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_CHeB", /* 256 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_CHeB", /* 257 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_CHeB", /* 258 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_CHeB", /* 259 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_CHeB", /* 260 */                     \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_EAGB", /* 261 */                   \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_EAGB", /* 262 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_EAGB", /* 263 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_EAGB", /* 264 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_EAGB", /* 265 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_EAGB", /* 266 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_EAGB", /* 267 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_EAGB", /* 268 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_EAGB", /* 269 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_EAGB", /* 270 */                     \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_TPAGB", /* 271 */                 \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_TPAGB", /* 272 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_TPAGB", /* 273 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_TPAGB", /* 274 */                  \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_TPAGB", /* 275 */                  \
        "NUCSYN_ENSEMBLE_MERGER_COWD_TPAGB", /* 276 */                  \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_TPAGB", /* 277 */                 \
        "NUCSYN_ENSEMBLE_MERGER_NS_TPAGB", /* 278 */                    \
        "NUCSYN_ENSEMBLE_MERGER_BH_TPAGB", /* 279 */                    \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_HeMS", /* 280 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_HeMS", /* 281 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_HeMS", /* 282 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_HeMS", /* 283 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_HeMS", /* 284 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_HeMS", /* 285 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_HeMS", /* 286 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_HeMS", /* 287 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_HeHG", /* 288 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_HeHG", /* 289 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_HeHG", /* 290 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_HeHG", /* 291 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_HeHG", /* 292 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_HeHG", /* 293 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_HeHG", /* 294 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_HeGB", /* 295 */                   \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_HeGB", /* 296 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_HeGB", /* 297 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_HeGB", /* 298 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_HeGB", /* 299 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_HeGB", /* 300 */                     \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_HeWD", /* 301 */                   \
        "NUCSYN_ENSEMBLE_MERGER_COWD_HeWD", /* 302 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_HeWD", /* 303 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_HeWD", /* 304 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_HeWD", /* 305 */                     \
        "NUCSYN_ENSEMBLE_MERGER_COWD_COWD", /* 306 */                   \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_COWD", /* 307 */                  \
        "NUCSYN_ENSEMBLE_MERGER_NS_COWD", /* 308 */                     \
        "NUCSYN_ENSEMBLE_MERGER_BH_COWD", /* 309 */                     \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_ONeWD", /* 310 */                 \
        "NUCSYN_ENSEMBLE_MERGER_NS_ONeWD", /* 311 */                    \
        "NUCSYN_ENSEMBLE_MERGER_BH_ONeWD", /* 312 */                    \
        "NUCSYN_ENSEMBLE_MERGER_NS_NS", /* 313 */                       \
        "NUCSYN_ENSEMBLE_MERGER_BH_NS", /* 314 */                       \
        "NUCSYN_ENSEMBLE_MERGER_BH_BH", /* 315 */                       \
        "NUCSYN_ENSEMBLE_DAVIES_RSG", /* 316 */                         \
        "NUCSYN_ENSEMBLE_DAVIES_RSG_LUM", /* 317 */                     \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p8", /* 318 */             \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p7", /* 319 */             \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p6", /* 320 */             \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_COWD_LT0p5", /* 321 */             \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_ONeWD", /* 322 */                  \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p8", /* 323 */       \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p7", /* 324 */       \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p6", /* 325 */       \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_COWD_LT0p5", /* 326 */       \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_GT0p3_ONeWD", /* 327 */            \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p8", /* 328 */      \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p7", /* 329 */      \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p6", /* 330 */      \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_COWD_LT0p5", /* 331 */      \
        "NUCSYN_ENSEMBLE_PERETS_HeWD_LT0p25_ONeWD", /* 332 */           \
        "NUCSYN_ENSEMBLE_AMCVN", /* 333 */                              \
        "NUCSYN_ENSEMBLE_SDO", /* 334 */                                \
        "NUCSYN_ENSEMBLE_SN_TZ", /* 335 */                              \
        "NUCSYN_ENSEMBLE_SN_AIC_BH", /* 336 */                          \
        "NUCSYN_ENSEMBLE_SN_BH_NS", /* 337 */                           \
        "NUCSYN_ENSEMBLE_SN_BH_BH", /* 338 */                           \
        "NUCSYN_ENSEMBLE_TEST_COUNT", /* 339 */                         \
        "NUCSYN_ENSEMBLE_TEST_RATE", /* 340 */                          \
        "NUCSYN_ENSEMBLE_WIND_KINETIC_POWER", /* 341 */                 \
        "NUCSYN_ENSEMBLE_WIND_RSG_KINETIC_POWER", /* 342 */             \
        "NUCSYN_ENSEMBLE_WIND_ISG_KINETIC_POWER", /* 343 */             \
        "NUCSYN_ENSEMBLE_WIND_BSG_KINETIC_POWER", /* 344 */             \
        "NUCSYN_ENSEMBLE_WIND_WOLF_RAYET_KINETIC_POWER", /* 345 */      \
        "NUCSYN_ENSEMBLE_WIND_AGB_KINETIC_POWER", /* 346 */             \
        "NUCSYN_ENSEMBLE_SUPERNOVA_KINETIC_POWER", /* 347 */            \
        "NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_KINETIC_POWER", /* 348 */ \
        "NUCSYN_ENSEMBLE_SUPERNOVA_IA_KINETIC_POWER", /* 349 */         \
        "NUCSYN_ENSEMBLE_NOVA_KINETIC_POWER", /* 350 */                 \
        "NUCSYN_ENSEMBLE_SUPERNOVA_LUMINOSITY", /* 351 */               \
        "NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_LUMINOSITY", /* 352 */ \
        "NUCSYN_ENSEMBLE_SUPERNOVA_IA_LUMINOSITY", /* 353 */            \
        "NUCSYN_ENSEMBLE_NOVA_LUMINOSITY", /* 354 */                    \
        "NUCSYN_ENSEMBLE_WIND_MOMENTUM", /* 355 */                      \
        "NUCSYN_ENSEMBLE_WIND_RSG_MOMENTUM", /* 356 */                  \
        "NUCSYN_ENSEMBLE_WIND_ISG_MOMENTUM", /* 357 */                  \
        "NUCSYN_ENSEMBLE_WIND_BSG_MOMENTUM", /* 358 */                  \
        "NUCSYN_ENSEMBLE_WIND_WOLF_RAYET_MOMENTUM", /* 359 */           \
        "NUCSYN_ENSEMBLE_WIND_AGB_MOMENTUM", /* 360 */                  \
        "NUCSYN_ENSEMBLE_SUPERNOVA_MOMENTUM", /* 361 */                 \
        "NUCSYN_ENSEMBLE_SUPERNOVA_CORE_COLLAPSE_MOMENTUM", /* 362 */   \
        "NUCSYN_ENSEMBLE_SUPERNOVA_IA_MOMENTUM", /* 363 */              \
        "NUCSYN_ENSEMBLE_NOVA_MOMENTUM", /* 364 */                      \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_gt_COWD", /* 365 */                \
        "NUCSYN_ENSEMBLE_SN_IA_Hybrid_HeCOWD", /* 366 */                \
        "NUCSYN_ENSEMBLE_Hybrid_HeCOWD", /* 367 */                      \
        "NUCSYN_ENSEMBLE_Hybrid_HeCOWD_LUM", /* 368 */                  \
        "NUCSYN_ENSEMBLE_MERGER_LMMS_Hybrid_HeCOWD", /* 369 */          \
        "NUCSYN_ENSEMBLE_MERGER_MS_Hybrid_HeCOWD", /* 370 */            \
        "NUCSYN_ENSEMBLE_MERGER_HG_Hybrid_HeCOWD", /* 371 */            \
        "NUCSYN_ENSEMBLE_MERGER_GB_Hybrid_HeCOWD", /* 372 */            \
        "NUCSYN_ENSEMBLE_MERGER_CHeB_Hybrid_HeCOWD", /* 373 */          \
        "NUCSYN_ENSEMBLE_MERGER_EAGB_Hybrid_HeCOWD", /* 374 */          \
        "NUCSYN_ENSEMBLE_MERGER_TPAGB_Hybrid_HeCOWD", /* 375 */         \
        "NUCSYN_ENSEMBLE_MERGER_HeMS_Hybrid_HeCOWD", /* 376 */          \
        "NUCSYN_ENSEMBLE_MERGER_HeHG_Hybrid_HeCOWD", /* 377 */          \
        "NUCSYN_ENSEMBLE_MERGER_HeGB_Hybrid_HeCOWD", /* 378 */          \
        "NUCSYN_ENSEMBLE_MERGER_HeWD_Hybrid_HeCOWD", /* 379 */          \
        "NUCSYN_ENSEMBLE_MERGER_COWD_Hybrid_HeCOWD", /* 380 */          \
        "NUCSYN_ENSEMBLE_MERGER_ONeWD_Hybrid_HeCOWD", /* 381 */         \
        "NUCSYN_ENSEMBLE_MERGER_NS_Hybrid_HeCOWD", /* 382 */            \
        "NUCSYN_ENSEMBLE_MERGER_BH_Hybrid_HeCOWD", /* 383 */            \
        "NUCSYN_ENSEMBLE_MERGER_Hybrid_HeCOWD_Hybrid_HeCOWD", /* 384 */ \
        "NUCSYN_ENSEMBLE_SN_IA_Hybrid_HeCOWD_subluminous", /* 385 */    \
        "NUCSYN_ENSEMBLE_TZ_M1_LT8", /* 386 */                          \
        "NUCSYN_ENSEMBLE_TZ_M1_8_9", /* 387 */                          \
        "NUCSYN_ENSEMBLE_TZ_M1_9_10", /* 388 */                         \
        "NUCSYN_ENSEMBLE_TZ_M1_10_11", /* 389 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_11_12", /* 390 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_12_13", /* 391 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_13_14", /* 392 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_14_15", /* 393 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_15_16", /* 394 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_16_17", /* 395 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_17_18", /* 396 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_18_19", /* 397 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_19_20", /* 398 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_20_21", /* 399 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_21_22", /* 400 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_22_23", /* 401 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_23_24", /* 402 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_24_25", /* 403 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_25_26", /* 404 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_26_27", /* 405 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_27_28", /* 406 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_28_29", /* 407 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_29_30", /* 408 */                        \
        "NUCSYN_ENSEMBLE_TZ_M1_GT30" /* 409 */


/*
 * number of observables : this should be one more
 * than your final ensemble item index
 */
#define NUCSYN_ENSEMBLE_N 410


#endif // NUCSYN_ENSEMBLE_H
